/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.MapEntry;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class OrderedMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    private final OrderedSet<K> keySet;
    private final ArrayList<V> valueList;
    private final CollectionHost<K> host;
    private boolean inUpdate;
    private Indexed<Map.Entry<K, V>> myIndexedEntryProxy;
    private Indexed<V> myIndexedValueProxy;

    public OrderedMap() {
        this(0, null);
    }

    public OrderedMap(int capacity) {
        this(capacity, null);
    }

    public OrderedMap(CollectionHost<K> host) {
        this(0, host);
    }

    public OrderedMap(int capacity, CollectionHost<K> host) {
        this.valueList = new ArrayList(capacity);
        this.host = host;
        this.myIndexedEntryProxy = null;
        this.myIndexedValueProxy = null;
        this.keySet = new OrderedSet(capacity, new CollectionHost<K>(){

            @Override
            public void adding(int index, K k, Object v) {
                OrderedMap.this.adding(index, k, v);
            }

            @Override
            public Object removing(int index, K k) {
                return OrderedMap.this.removing(index, k);
            }

            @Override
            public void clearing() {
                OrderedMap.this.clearing();
            }

            @Override
            public void addingNulls(int index) {
                OrderedMap.this.addingNull(index);
            }

            @Override
            public boolean skipHostUpdate() {
                return OrderedMap.this.inUpdate;
            }

            @Override
            public int getIteratorModificationCount() {
                return OrderedMap.this.getModificationCount();
            }
        });
    }

    public Indexed<Map.Entry<K, V>> getIndexedEntryProxy() {
        if (this.myIndexedEntryProxy != null) {
            return this.myIndexedEntryProxy;
        }
        this.myIndexedEntryProxy = new Indexed<Map.Entry<K, V>>(){

            @Override
            public Map.Entry<K, V> get(int index) {
                return OrderedMap.this.getEntry(index);
            }

            @Override
            public void set(int index, Map.Entry<K, V> item) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAt(int index) {
                OrderedMap.this.keySet.removeIndexHosted(index);
            }

            @Override
            public int size() {
                return OrderedMap.this.size();
            }

            @Override
            public int modificationCount() {
                return OrderedMap.this.getModificationCount();
            }
        };
        return this.myIndexedEntryProxy;
    }

    public Indexed<V> getIndexedValueProxy() {
        if (this.myIndexedValueProxy != null) {
            return this.myIndexedValueProxy;
        }
        this.myIndexedValueProxy = new Indexed<V>(){

            @Override
            public V get(int index) {
                return OrderedMap.this.getValue(index);
            }

            @Override
            public void set(int index, V item) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void removeAt(int index) {
                OrderedMap.this.keySet.removeIndexHosted(index);
            }

            @Override
            public int size() {
                return OrderedMap.this.size();
            }

            @Override
            public int modificationCount() {
                return OrderedMap.this.getModificationCount();
            }
        };
        return this.myIndexedValueProxy;
    }

    private Map.Entry<K, V> getEntry(int index) {
        return new MapEntry<K, V>(this.keySet.getValue(index), this.valueList.get(index));
    }

    public int getModificationCount() {
        return this.keySet.getModificationCount();
    }

    void adding(int index, K k, Object v) {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.adding(index, k, v);
        }
        this.valueList.add(v);
    }

    void addingNull(int index) {
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.addingNulls(index);
        }
        this.addNulls(index);
    }

    Object removing(int index, K k) {
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.removing(index, k);
        }
        return this.valueList.get(index);
    }

    void clearing() {
        if (this.host != null && !this.host.skipHostUpdate()) {
            this.host.clearing();
        }
        this.valueList.clear();
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.keySet.contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        int index = this.valueList.indexOf(o);
        return this.keySet.isValidIndex(index);
    }

    public void addNull() {
        this.addNulls(this.valueList.size());
    }

    public void addNulls(int index) {
        if (index < this.valueList.size()) {
            throw new IllegalArgumentException("addNulls(" + index + ") called when valueList size is " + this.valueList.size());
        }
        while (this.valueList.size() <= index) {
            this.valueList.add(null);
        }
    }

    @Override
    public V get(Object o) {
        int index = this.keySet.indexOf(o);
        return index == -1 ? null : (V)this.valueList.get(index);
    }

    @Override
    public V put(K k, V v) {
        int index = this.keySet.indexOf(k);
        if (index == -1) {
            this.keySet.add(k, v);
            return null;
        }
        V old = this.valueList.get(index);
        this.valueList.set(index, v);
        return old;
    }

    public V computeIfMissing(K k, Function<? super K, ? extends V> runnableValue) {
        int index = this.keySet.indexOf(k);
        if (index == -1) {
            V v = runnableValue.apply(k);
            this.keySet.add(k, v);
            return v;
        }
        return this.valueList.get(index);
    }

    @Override
    public V remove(Object o) {
        return (V)this.keySet.removeHosted(o);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void addAll(Collection<? extends Map.Entry<? extends K, ? extends V>> entries) {
        for (Map.Entry<K, V> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keySet.clear();
    }

    @Override
    public OrderedSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (!this.keySet.isSparse()) {
            return this.valueList;
        }
        ArrayList<V> values = new ArrayList<V>(this.keySet.size());
        ReversibleIterator<Integer> iterator = this.keySet.indexIterator();
        while (iterator.hasNext()) {
            values.add(this.valueList.get((Integer)iterator.next()));
        }
        return values;
    }

    public K getKey(int index) {
        if (!this.keySet.isValidIndex(index)) {
            return null;
        }
        return this.keySet.getValueList().get(index);
    }

    public V getValue(int index) {
        if (!this.keySet.isValidIndex(index)) {
            return null;
        }
        return this.valueList.get(index);
    }

    @Override
    public OrderedSet<Map.Entry<K, V>> entrySet() {
        this.inUpdate = true;
        OrderedSet<Map.Entry<K, V>> values = new OrderedSet<Map.Entry<K, V>>(this.keySet.size(), new EntryCollectionHost());
        ReversibleIndexedIterator<Map.Entry<K, V>> iterator = this.entryIterator();
        while (iterator.hasNext()) {
            values.add((Map.Entry<K, V>)iterator.next());
        }
        this.inUpdate = false;
        return values;
    }

    public List<Map.Entry<K, V>> entries() {
        ArrayList<Map.Entry<K, V>> values = new ArrayList<Map.Entry<K, V>>();
        ReversibleIndexedIterator<Map.Entry<K, V>> iterator = this.entryIterator();
        while (iterator.hasNext()) {
            values.add((Map.Entry<K, V>)iterator.next());
        }
        return values;
    }

    public List<K> keys() {
        return this.keySet.values();
    }

    public ReversibleIndexedIterator<V> valueIterator() {
        return new IndexedIterator(this.getIndexedValueProxy(), this.keySet.indexIterator());
    }

    public ReversibleIndexedIterator<V> reversedValueIterator() {
        return new IndexedIterator(this.getIndexedValueProxy(), this.keySet.reversedIndexIterator());
    }

    public ReversibleIndexedIterator<K> keyIterator() {
        return this.keySet.iterator();
    }

    public ReversibleIndexedIterator<K> reversedKeyIterator() {
        return this.keySet.reversedIterator();
    }

    public ReversibleIndexedIterator<Map.Entry<K, V>> entryIterator() {
        return new IndexedIterator(this.getIndexedEntryProxy(), this.keySet.indexIterator());
    }

    public ReversibleIndexedIterator<Map.Entry<K, V>> reversedEntryIterator() {
        return new IndexedIterator(this.getIndexedEntryProxy(), this.keySet.reversedIndexIterator());
    }

    public ReversibleIndexedIterator<Map.Entry<K, V>> reversedIterator() {
        return this.reversedEntryIterator();
    }

    public ReversibleIterable<V> valueIterable() {
        return new IndexedIterable(this.getIndexedValueProxy(), this.keySet.indexIterable());
    }

    public ReversibleIterable<V> reversedValueIterable() {
        return new IndexedIterable(this.getIndexedValueProxy(), this.keySet.reversedIndexIterable());
    }

    public ReversibleIterable<K> keyIterable() {
        return this.keySet.iterable();
    }

    public ReversibleIterable<K> reversedKeyIterable() {
        return this.keySet.reversedIterable();
    }

    public ReversibleIterable<Map.Entry<K, V>> entryIterable() {
        return new IndexedIterable(this.getIndexedEntryProxy(), this.keySet.indexIterable());
    }

    public ReversibleIterable<Map.Entry<K, V>> reversedEntryIterable() {
        return new IndexedIterable(this.getIndexedEntryProxy(), this.keySet.reversedIndexIterable());
    }

    public ReversibleIterable<Map.Entry<K, V>> reversedIterable() {
        return this.reversedEntryIterable();
    }

    @Override
    public ReversibleIndexedIterator<Map.Entry<K, V>> iterator() {
        return this.entryIterator();
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            consumer.accept((Map.Entry<K, V>)iterator.next());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedMap set = (OrderedMap)o;
        if (this.size() != set.size()) {
            return false;
        }
        return ((OrderedSet)this.entrySet()).equals(set.entrySet());
    }

    @Override
    public int hashCode() {
        int result = this.keySet.hashCode();
        result = 31 * result + this.valueList.hashCode();
        return result;
    }

    private class EntryCollectionHost<KK extends K, VV extends V>
    implements CollectionHost<Map.Entry<KK, VV>> {
        private EntryCollectionHost() {
        }

        @Override
        public void adding(int index, Map.Entry<KK, VV> entry, Object v) {
            assert (v == null);
            OrderedMap.this.keySet.add(entry.getKey(), entry.getValue());
        }

        @Override
        public Object removing(int index, Map.Entry<KK, VV> entry) {
            OrderedMap.this.keySet.removeIndex(index);
            return entry;
        }

        @Override
        public void clearing() {
            OrderedMap.this.keySet.clear();
        }

        @Override
        public void addingNulls(int index) {
            OrderedMap.this.keySet.addNulls(index);
        }

        @Override
        public boolean skipHostUpdate() {
            return OrderedMap.this.inUpdate;
        }

        @Override
        public int getIteratorModificationCount() {
            return OrderedMap.this.getModificationCount();
        }
    }
}

