/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesDelimiter;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.AttributesInlineParserExtension;
import com.vladsch.flexmark.ext.attributes.internal.AttributesOptions;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.parser.LightInlineParserImpl;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.DoNotAttributeDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeTracker;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;

public class AttributesNodePostProcessor
extends NodePostProcessor {
    private final NodeAttributeRepository nodeAttributeRepository;
    private final AttributesOptions myOptions;
    private LightInlineParser myLightInlineParser;
    private AttributesInlineParserExtension myParserExtension;

    public AttributesNodePostProcessor(Document document) {
        this.nodeAttributeRepository = AttributesExtension.NODE_ATTRIBUTES.getFrom(document);
        this.myOptions = new AttributesOptions(document);
    }

    public Node getAttributeOwner(NodeTracker state, AttributesNode attributesNode) {
        Node attributeOwner;
        Node previous = attributesNode.getPreviousAnyNot(BlankLine.class, DoNotAttributeDecorate.class);
        Node next = attributesNode.getNext();
        Node parent = attributesNode.getParent();
        if (previous == null) {
            Node parentPreviousNotBlankLine;
            attributeOwner = parent instanceof Paragraph ? (parent.getParent() instanceof ParagraphItemContainer ? ((parentPreviousNotBlankLine = parent.getPreviousAnyNot(BlankLine.class)) == null ? parent.getParent().getParent() : (attributesNode.getNextAnyNot(AttributesNode.class, BlankLine.class) == null ? parentPreviousNotBlankLine : parent)) : (attributesNode.getNextAnyNot(AttributesNode.class, BlankLine.class) == null ? ((parentPreviousNotBlankLine = parent.getPreviousAnyNot(BlankLine.class)) == null ? parent.getParent() : parentPreviousNotBlankLine) : parent)) : parent;
        } else if (!this.myOptions.assignTextAttributes && (previous instanceof Text || previous instanceof TextBase) || previous.getChars().getEndOffset() < attributesNode.getStartOffset()) {
            if (this.myOptions.useEmptyImplicitAsSpanDelimiter) {
                previous = AttributesNodePostProcessor.matchDelimitedSpans(state, attributesNode, previous);
            }
            attributeOwner = previous instanceof TextBase ? previous : (parent instanceof Paragraph && parent.getParent() instanceof ParagraphItemContainer ? parent.getParent() : parent);
        } else {
            if (this.myOptions.wrapNonAttributeText) {
                Node lastNonAttributesNode = null;
                boolean hadDoNotDecorate = false;
                for (Node first = attributesNode.getPrevious(); first != null && (first instanceof Text || first instanceof DoNotAttributeDecorate); first = first.getPrevious()) {
                    if (first instanceof DoNotAttributeDecorate) {
                        hadDoNotDecorate = true;
                    }
                    lastNonAttributesNode = first;
                }
                if (hadDoNotDecorate) {
                    TextBase textBase = new TextBase();
                    AttributesNodePostProcessor.textBaseWrap(state, lastNonAttributesNode, attributesNode, textBase);
                    previous = textBase;
                }
            }
            if (this.myOptions.useEmptyImplicitAsSpanDelimiter) {
                previous = AttributesNodePostProcessor.matchDelimitedSpans(state, attributesNode, previous);
            }
            if (previous instanceof Text) {
                TextBase textBase = new TextBase(previous.getChars());
                previous.insertBefore(textBase);
                previous.unlink();
                state.nodeRemoved(previous);
                textBase.appendChild(previous);
                state.nodeAddedWithChildren(textBase);
                attributeOwner = textBase;
            } else {
                attributeOwner = previous instanceof AttributesDelimiter ? null : (previous instanceof AttributesNode ? this.getAttributeOwner(state, (AttributesNode)previous) : previous);
            }
        }
        return attributeOwner;
    }

    static Node matchDelimitedSpans(NodeTracker state, AttributesNode attributesNode, Node previous) {
        Node previousNext;
        Node lastNonAttributesNode = null;
        ArrayList<Node> unmatchedAttributes = new ArrayList<Node>();
        for (Node first = attributesNode.getPrevious(); first != null; first = first.getPrevious()) {
            if (first instanceof AttributesDelimiter) {
                if (!unmatchedAttributes.isEmpty()) {
                    Node lastNode = (Node)unmatchedAttributes.remove(unmatchedAttributes.size() - 1);
                    if (lastNode != (lastNonAttributesNode = first.getNext())) {
                        TextBase textBase = new TextBase();
                        AttributesNodePostProcessor.textBaseWrap(state, lastNonAttributesNode, lastNode, textBase);
                        lastNonAttributesNode = textBase;
                        continue;
                    }
                    previous = first;
                    continue;
                }
                TextBase textBase = new TextBase();
                lastNonAttributesNode = first.getNext();
                if (lastNonAttributesNode != attributesNode) {
                    AttributesNodePostProcessor.textBaseWrap(state, lastNonAttributesNode, attributesNode, textBase);
                    previous = textBase;
                    break;
                }
                previous = first;
                break;
            }
            if (first instanceof AttributesNode) {
                unmatchedAttributes.add(first);
                continue;
            }
            lastNonAttributesNode = first;
        }
        if (!unmatchedAttributes.isEmpty() && (previousNext = (previous = (Node)unmatchedAttributes.get(0)).getNext()) != null && previousNext != attributesNode) {
            previous = previousNext;
        }
        return previous;
    }

    static void textBaseWrap(NodeTracker state, Node lastNonAttributesNode, Node lastNode, TextBase textBase) {
        while (lastNonAttributesNode != lastNode) {
            Node nextNode = lastNonAttributesNode.getNext();
            lastNonAttributesNode.unlink();
            state.nodeRemoved(lastNonAttributesNode);
            textBase.appendChild(lastNonAttributesNode);
            lastNonAttributesNode = nextNode;
        }
        textBase.setCharsFromContent();
        lastNode.insertBefore(textBase);
        state.nodeAddedWithDescendants(textBase);
    }

    @Override
    public void process(NodeTracker state, Node node) {
        BasedSequence language;
        FencedCodeBlock fencedCodeBlock;
        BasedSequence info;
        BasedSequence infoTail;
        int pos;
        if (node instanceof AttributesNode) {
            Node attributeOwner;
            Node tmp;
            AttributesNode attributesNode = (AttributesNode)node;
            Node previous = attributesNode.getPrevious();
            Node next = attributesNode.getNext();
            if (previous == null && next != null && !(next instanceof AttributesNode)) {
                if (next.getChars().isBlank()) {
                    tmp = next;
                    next = next.getNext();
                    tmp.unlink();
                    state.nodeRemoved(tmp);
                } else {
                    next.setChars((BasedSequence)next.getChars().trimStart());
                }
            }
            if (next == null && previous != null && !(previous instanceof AttributesNode)) {
                if (previous.getChars().isBlank()) {
                    tmp = previous;
                    previous = previous.getPrevious();
                    tmp.unlink();
                    state.nodeRemoved(tmp);
                } else {
                    previous.setChars((BasedSequence)previous.getChars().trimEnd());
                }
            }
            if ((attributeOwner = this.getAttributeOwner(state, attributesNode)) != null) {
                this.nodeAttributeRepository.put(attributeOwner, attributesNode);
                if (attributeOwner instanceof AnchorRefTarget) {
                    for (Node attributeNode : attributesNode.getReversedChildren()) {
                        if (!(attributeNode instanceof AttributeNode) || !((AttributeNode)attributeNode).isId()) continue;
                        ((AnchorRefTarget)((Object)attributeOwner)).setAnchorRefId(((AttributeNode)attributeNode).getValue().toString());
                        break;
                    }
                }
            }
        }
        if (node instanceof FencedCodeBlock && this.myOptions.fencedCodeInfoAttributes && (pos = (infoTail = (BasedSequence)((BasedSequence)(info = (fencedCodeBlock = (FencedCodeBlock)node).getInfo()).subSequence((language = fencedCodeBlock.getInfoDelimitedByAny(" \t")).length())).trimStart()).indexOf('{')) >= 0) {
            if (this.myLightInlineParser == null) {
                this.myLightInlineParser = new LightInlineParserImpl(node.getDocument());
                this.myParserExtension = new AttributesInlineParserExtension(this.myLightInlineParser);
            }
            this.myLightInlineParser.setInput(infoTail);
            this.myLightInlineParser.setIndex(pos);
            AttributesNode dummyBlock = new AttributesNode();
            this.myLightInlineParser.setBlock(dummyBlock);
            while (true) {
                int startIndex = this.myLightInlineParser.getIndex();
                boolean parsed = this.myParserExtension.parse(this.myLightInlineParser);
                this.myLightInlineParser.spnl();
                int index = this.myLightInlineParser.getIndex() + (this.myLightInlineParser.getIndex() == startIndex ? 1 : 0);
                pos = infoTail.indexOf('{', index);
                if (pos == -1) break;
                if (!parsed || !((BasedSequence)infoTail.subSequence(index, pos)).isBlank()) {
                    dummyBlock.removeChildren();
                }
                this.myLightInlineParser.setIndex(pos);
            }
            if (dummyBlock.hasChildren()) {
                Node firstAttributes = dummyBlock.getFirstChild();
                Node lastAttributes = dummyBlock.getLastChild();
                fencedCodeBlock.setInfo(fencedCodeBlock.getChars().baseSubSequence(info.getStartOffset(), firstAttributes.getStartOffset()));
                fencedCodeBlock.setAttributes(fencedCodeBlock.getChars().baseSubSequence(firstAttributes.getStartOffset(), lastAttributes.getEndOffset()));
                for (Node attributesNode : dummyBlock.getChildren()) {
                    if (this.myLightInlineParser.getIndex() < this.myLightInlineParser.getInput().length()) continue;
                    if (fencedCodeBlock.hasChildren()) {
                        fencedCodeBlock.getLastChild().insertBefore(attributesNode);
                    } else {
                        fencedCodeBlock.appendChild(attributesNode);
                    }
                    this.nodeAttributeRepository.put((Node)fencedCodeBlock, (AttributesNode)attributesNode);
                }
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(AttributesNode.class, FencedCodeBlock.class);
        }

        @Override
        public NodePostProcessor apply(Document document) {
            return new AttributesNodePostProcessor(document);
        }
    }
}

