/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.xwiki.macros.internal;

import com.vladsch.flexmark.ext.xwiki.macros.Macro;
import com.vladsch.flexmark.ext.xwiki.macros.MacroAttribute;
import com.vladsch.flexmark.ext.xwiki.macros.MacroClose;
import com.vladsch.flexmark.ext.xwiki.macros.internal.MacroParsing;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;

public class MacroInlineParser
implements InlineParserExtension {
    private final MacroParsing parsing;
    private List<Macro> openMacros;

    public MacroInlineParser(InlineParser inlineParser) {
        this.parsing = new MacroParsing(inlineParser.getParsing());
        this.openMacros = new ArrayList<Macro>();
    }

    @Override
    public void finalizeDocument(InlineParser inlineParser) {
    }

    @Override
    public void finalizeBlock(InlineParser inlineParser) {
        int j = this.openMacros.size();
        while (j-- > 0) {
            inlineParser.moveNodes(this.openMacros.get(j), inlineParser.getBlock().getLastChild());
        }
        this.openMacros.clear();
    }

    @Override
    public boolean parse(InlineParser inlineParser) {
        if (inlineParser.peek(1) == '{') {
            BasedSequence input = inlineParser.getInput();
            int index = inlineParser.getIndex();
            Matcher matcher = inlineParser.matcher(this.parsing.MACRO_TAG);
            if (matcher != null) {
                BasedSequence macroOpen = (BasedSequence)input.subSequence(matcher.start(), matcher.end());
                if (macroOpen.charAt(2) == '/') {
                    BasedSequence macroName = (BasedSequence)input.subSequence(matcher.start(2), matcher.end(2));
                    int i = this.openMacros.size();
                    while (i-- > 0) {
                        if (!this.openMacros.get(i).getName().equals(macroName)) continue;
                        inlineParser.flushTextNode();
                        int j = this.openMacros.size();
                        while (j-- > i) {
                            inlineParser.moveNodes(this.openMacros.get(j), inlineParser.getBlock().getLastChild());
                        }
                        MacroClose macroClose = new MacroClose((BasedSequence)macroOpen.subSequence(0, 3), macroName, (BasedSequence)macroOpen.endSequence(2));
                        inlineParser.getBlock().appendChild(macroClose);
                        inlineParser.moveNodes(this.openMacros.get(i), macroClose);
                        if (i == 0) {
                            this.openMacros.clear();
                        } else {
                            this.openMacros = this.openMacros.subList(0, i);
                        }
                        return true;
                    }
                } else {
                    BasedSequence attributeText;
                    BasedSequence macroName = (BasedSequence)input.subSequence(matcher.start(1), matcher.end(1));
                    boolean isClosedTag = macroOpen.endCharAt(3) == '/';
                    Macro macro = new Macro((BasedSequence)macroOpen.subSequence(0, 2), macroName, (BasedSequence)macroOpen.endSequence(isClosedTag ? 3 : 2));
                    macro.setCharsFromContent();
                    inlineParser.flushTextNode();
                    inlineParser.getBlock().appendChild(macro);
                    if (!isClosedTag) {
                        this.openMacros.add(macro);
                    }
                    if (!(attributeText = (BasedSequence)macroOpen.baseSubSequence(macroName.getEndOffset(), macro.getClosingMarker().getStartOffset()).trim()).isEmpty()) {
                        macro.setAttributeText(attributeText);
                        Matcher attributeMatcher = this.parsing.MACRO_ATTRIBUTE.matcher(attributeText);
                        while (attributeMatcher.find()) {
                            BasedSequence attributeClose;
                            BasedSequence attributeName = (BasedSequence)attributeText.subSequence(attributeMatcher.start(1), attributeMatcher.end(1));
                            BasedSequence attributeSeparator = attributeMatcher.groupCount() == 1 || attributeMatcher.start(2) == -1 ? BasedSequence.NULL : (BasedSequence)((BasedSequence)attributeText.subSequence(attributeMatcher.end(1), attributeMatcher.start(2))).trim();
                            BasedSequence attributeValue = attributeMatcher.groupCount() == 1 || attributeMatcher.start(2) == -1 ? BasedSequence.NULL : (BasedSequence)attributeText.subSequence(attributeMatcher.start(2), attributeMatcher.end(2));
                            boolean isQuoted = attributeValue.length() >= 2 && (attributeValue.charAt(0) == '\"' && attributeValue.endCharAt(1) == '\"' || attributeValue.charAt(0) == '\'' && attributeValue.endCharAt(1) == '\'');
                            BasedSequence attributeOpen = !isQuoted ? BasedSequence.NULL : (BasedSequence)attributeValue.subSequence(0, 1);
                            BasedSequence basedSequence = attributeClose = !isQuoted ? BasedSequence.NULL : (BasedSequence)attributeValue.endSequence(1, 0);
                            if (isQuoted) {
                                attributeValue = (BasedSequence)attributeValue.midSequence(1, -1);
                            }
                            MacroAttribute attribute = new MacroAttribute(attributeName, attributeSeparator, attributeOpen, attributeValue, attributeClose);
                            macro.appendChild(attribute);
                        }
                    }
                    return true;
                }
                inlineParser.setIndex(index);
            }
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Override
        public Set<Class<? extends InlineParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        @Override
        public CharSequence getCharacters() {
            return "{";
        }

        @Override
        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        @Override
        public InlineParserExtension apply(InlineParser inlineParser) {
            return new MacroInlineParser(inlineParser);
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

