/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.convert.html;

import com.vladsch.flexmark.convert.html.ExtensionConversion;
import com.vladsch.flexmark.convert.html.FlexmarkHtmlParser;
import com.vladsch.flexmark.convert.html.LinkConversion;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import java.util.Map;
import java.util.regex.Pattern;

public class HtmlParserOptions
implements MutableDataSetter {
    public boolean listContentIndent;
    public boolean setextHeadings;
    public boolean outputUnknownTags;
    public boolean typographicQuotes;
    public boolean typographicSmarts;
    public boolean outputAttributesIdAttr;
    public boolean wrapAutoLinks;
    public boolean extractAutoLinks;
    public boolean renderComments;
    public boolean dotOnlyNumericLists;
    public boolean preCodePreserveEmphasis;
    public boolean listsEndOnDoubleBlank;
    public boolean divAsParagraph;
    public boolean brAsParaBreaks;
    public boolean brAsExtraBlankLines;
    public boolean ignoreTableHeadingAfterRows;
    public boolean addTrailingEol;
    public boolean skipInlineStrong;
    public boolean skipInlineEmphasis;
    public boolean skipInlineCode;
    public boolean skipInlineDel;
    public boolean skipInlineIns;
    public boolean skipInlineSub;
    public boolean skipInlineSup;
    public boolean skipHeading1;
    public boolean skipHeading2;
    public boolean skipHeading3;
    public boolean skipHeading4;
    public boolean skipHeading5;
    public boolean skipHeading6;
    public boolean skipAttributes;
    public boolean skipFencedCode;
    public boolean skipLinks;
    public boolean skipCharEscape;
    public ExtensionConversion extInlineStrong;
    public ExtensionConversion extInlineEmphasis;
    public ExtensionConversion extInlineCode;
    public ExtensionConversion extInlineDel;
    public ExtensionConversion extInlineIns;
    public ExtensionConversion extInlineSub;
    public ExtensionConversion extInlineSup;
    public ExtensionConversion extMath;
    public ExtensionConversion extTables;
    public LinkConversion extInlineLink;
    public LinkConversion extInlineImage;
    public char orderedListDelimiter;
    public char unorderedListDelimiter;
    public int definitionMarkerSpaces;
    public int minSetextHeadingMarkerLength;
    public String codeIndent;
    public String eolInTitleAttribute;
    public String nbspText;
    public String thematicBreak;
    public String outputAttributesNamesRegex;
    public Pattern outputAttributesNamesRegexPattern;
    public String outputIdAttributeRegex;
    public Pattern outputIdAttributeRegexPattern;
    public Map<Object, CellAlignment> tableCellAlignmentMap;
    public TableFormatOptions tableOptions;

    HtmlParserOptions() {
        this((DataHolder)null);
    }

    HtmlParserOptions(HtmlParserOptions other) {
        this.listContentIndent = other.listContentIndent;
        this.setextHeadings = other.setextHeadings;
        this.outputUnknownTags = other.outputUnknownTags;
        this.typographicQuotes = other.typographicQuotes;
        this.typographicSmarts = other.typographicSmarts;
        this.outputAttributesIdAttr = other.outputAttributesIdAttr;
        this.wrapAutoLinks = other.wrapAutoLinks;
        this.extractAutoLinks = other.extractAutoLinks;
        this.renderComments = other.renderComments;
        this.dotOnlyNumericLists = other.dotOnlyNumericLists;
        this.preCodePreserveEmphasis = other.preCodePreserveEmphasis;
        this.listsEndOnDoubleBlank = other.listsEndOnDoubleBlank;
        this.divAsParagraph = other.divAsParagraph;
        this.brAsParaBreaks = other.brAsParaBreaks;
        this.brAsExtraBlankLines = other.brAsExtraBlankLines;
        this.ignoreTableHeadingAfterRows = other.ignoreTableHeadingAfterRows;
        this.addTrailingEol = other.addTrailingEol;
        this.skipInlineStrong = other.skipInlineStrong;
        this.skipInlineEmphasis = other.skipInlineEmphasis;
        this.skipInlineCode = other.skipInlineCode;
        this.skipInlineDel = other.skipInlineDel;
        this.skipInlineIns = other.skipInlineIns;
        this.skipInlineSub = other.skipInlineSub;
        this.skipInlineSup = other.skipInlineSup;
        this.skipHeading1 = other.skipHeading1;
        this.skipHeading2 = other.skipHeading2;
        this.skipHeading3 = other.skipHeading3;
        this.skipHeading4 = other.skipHeading4;
        this.skipHeading5 = other.skipHeading5;
        this.skipHeading6 = other.skipHeading6;
        this.skipAttributes = other.skipAttributes;
        this.skipFencedCode = other.skipFencedCode;
        this.skipLinks = other.skipLinks;
        this.skipCharEscape = other.skipCharEscape;
        this.extInlineStrong = other.extInlineStrong;
        this.extInlineEmphasis = other.extInlineEmphasis;
        this.extInlineCode = other.extInlineCode;
        this.extInlineDel = other.extInlineDel;
        this.extInlineIns = other.extInlineIns;
        this.extInlineSub = other.extInlineSub;
        this.extInlineSup = other.extInlineSup;
        this.orderedListDelimiter = other.orderedListDelimiter;
        this.unorderedListDelimiter = other.unorderedListDelimiter;
        this.definitionMarkerSpaces = other.definitionMarkerSpaces;
        this.minSetextHeadingMarkerLength = other.minSetextHeadingMarkerLength;
        this.codeIndent = other.codeIndent;
        this.eolInTitleAttribute = other.eolInTitleAttribute;
        this.nbspText = other.nbspText;
        this.thematicBreak = other.thematicBreak;
        this.outputAttributesNamesRegex = other.outputAttributesNamesRegex;
        this.outputAttributesNamesRegexPattern = other.outputAttributesNamesRegexPattern;
        this.tableCellAlignmentMap = other.tableCellAlignmentMap;
        this.tableOptions = other.tableOptions;
        this.outputIdAttributeRegex = other.outputIdAttributeRegex;
        this.outputIdAttributeRegexPattern = other.outputIdAttributeRegexPattern;
        this.extMath = other.extMath;
        this.extTables = other.extTables;
        this.extInlineLink = other.extInlineLink;
        this.extInlineImage = other.extInlineImage;
    }

    HtmlParserOptions(DataHolder options) {
        this.listContentIndent = FlexmarkHtmlParser.LIST_CONTENT_INDENT.getFrom(options);
        this.setextHeadings = FlexmarkHtmlParser.SETEXT_HEADINGS.getFrom(options);
        this.outputUnknownTags = FlexmarkHtmlParser.OUTPUT_UNKNOWN_TAGS.getFrom(options);
        this.typographicQuotes = FlexmarkHtmlParser.TYPOGRAPHIC_QUOTES.getFrom(options);
        this.typographicSmarts = FlexmarkHtmlParser.TYPOGRAPHIC_SMARTS.getFrom(options);
        this.outputAttributesIdAttr = FlexmarkHtmlParser.OUTPUT_ATTRIBUTES_ID.getFrom(options);
        this.wrapAutoLinks = FlexmarkHtmlParser.WRAP_AUTO_LINKS.getFrom(options);
        this.extractAutoLinks = FlexmarkHtmlParser.EXTRACT_AUTO_LINKS.getFrom(options);
        this.renderComments = FlexmarkHtmlParser.RENDER_COMMENTS.getFrom(options);
        this.dotOnlyNumericLists = FlexmarkHtmlParser.DOT_ONLY_NUMERIC_LISTS.getFrom(options);
        this.preCodePreserveEmphasis = FlexmarkHtmlParser.PRE_CODE_PRESERVE_EMPHASIS.getFrom(options);
        this.listsEndOnDoubleBlank = FlexmarkHtmlParser.LISTS_END_ON_DOUBLE_BLANK.getFrom(options);
        this.divAsParagraph = FlexmarkHtmlParser.DIV_AS_PARAGRAPH.getFrom(options);
        this.brAsParaBreaks = FlexmarkHtmlParser.BR_AS_PARA_BREAKS.getFrom(options);
        this.brAsExtraBlankLines = FlexmarkHtmlParser.BR_AS_EXTRA_BLANK_LINES.getFrom(options);
        this.ignoreTableHeadingAfterRows = FlexmarkHtmlParser.IGNORE_TABLE_HEADING_AFTER_ROWS.getFrom(options);
        this.addTrailingEol = FlexmarkHtmlParser.ADD_TRAILING_EOL.getFrom(options);
        this.skipInlineStrong = FlexmarkHtmlParser.SKIP_INLINE_STRONG.getFrom(options);
        this.skipInlineEmphasis = FlexmarkHtmlParser.SKIP_INLINE_EMPHASIS.getFrom(options);
        this.skipInlineCode = FlexmarkHtmlParser.SKIP_INLINE_CODE.getFrom(options);
        this.skipInlineDel = FlexmarkHtmlParser.SKIP_INLINE_DEL.getFrom(options);
        this.skipInlineIns = FlexmarkHtmlParser.SKIP_INLINE_INS.getFrom(options);
        this.skipInlineSub = FlexmarkHtmlParser.SKIP_INLINE_SUB.getFrom(options);
        this.skipInlineSup = FlexmarkHtmlParser.SKIP_INLINE_SUP.getFrom(options);
        this.skipHeading1 = FlexmarkHtmlParser.SKIP_HEADING_1.getFrom(options);
        this.skipHeading2 = FlexmarkHtmlParser.SKIP_HEADING_2.getFrom(options);
        this.skipHeading3 = FlexmarkHtmlParser.SKIP_HEADING_3.getFrom(options);
        this.skipHeading4 = FlexmarkHtmlParser.SKIP_HEADING_4.getFrom(options);
        this.skipHeading5 = FlexmarkHtmlParser.SKIP_HEADING_5.getFrom(options);
        this.skipHeading6 = FlexmarkHtmlParser.SKIP_HEADING_6.getFrom(options);
        this.skipAttributes = FlexmarkHtmlParser.SKIP_ATTRIBUTES.getFrom(options);
        this.skipFencedCode = FlexmarkHtmlParser.SKIP_FENCED_CODE.getFrom(options);
        this.skipLinks = FlexmarkHtmlParser.SKIP_LINKS.getFrom(options);
        this.skipCharEscape = FlexmarkHtmlParser.SKIP_CHAR_ESCAPE.getFrom(options);
        this.extInlineStrong = FlexmarkHtmlParser.EXT_INLINE_STRONG.getFrom(options);
        this.extInlineEmphasis = FlexmarkHtmlParser.EXT_INLINE_EMPHASIS.getFrom(options);
        this.extInlineCode = FlexmarkHtmlParser.EXT_INLINE_CODE.getFrom(options);
        this.extInlineDel = FlexmarkHtmlParser.EXT_INLINE_DEL.getFrom(options);
        this.extInlineIns = FlexmarkHtmlParser.EXT_INLINE_INS.getFrom(options);
        this.extInlineSub = FlexmarkHtmlParser.EXT_INLINE_SUB.getFrom(options);
        this.extInlineSup = FlexmarkHtmlParser.EXT_INLINE_SUP.getFrom(options);
        this.extMath = FlexmarkHtmlParser.EXT_MATH.getFrom(options);
        this.extTables = FlexmarkHtmlParser.EXT_TABLES.getFrom(options);
        this.extInlineLink = FlexmarkHtmlParser.EXT_INLINE_LINK.getFrom(options);
        this.extInlineImage = FlexmarkHtmlParser.EXT_INLINE_IMAGE.getFrom(options);
        this.orderedListDelimiter = FlexmarkHtmlParser.ORDERED_LIST_DELIMITER.getFrom(options).charValue();
        this.unorderedListDelimiter = FlexmarkHtmlParser.UNORDERED_LIST_DELIMITER.getFrom(options).charValue();
        this.definitionMarkerSpaces = FlexmarkHtmlParser.DEFINITION_MARKER_SPACES.getFrom(options);
        this.minSetextHeadingMarkerLength = Utils.minLimit(FlexmarkHtmlParser.MIN_SETEXT_HEADING_MARKER_LENGTH.getFrom(options), 3);
        this.codeIndent = FlexmarkHtmlParser.CODE_INDENT.getFrom(options);
        this.eolInTitleAttribute = FlexmarkHtmlParser.EOL_IN_TITLE_ATTRIBUTE.getFrom(options);
        this.nbspText = FlexmarkHtmlParser.NBSP_TEXT.getFrom(options);
        this.thematicBreak = FlexmarkHtmlParser.THEMATIC_BREAK.getFrom(options);
        this.outputAttributesNamesRegex = FlexmarkHtmlParser.OUTPUT_ATTRIBUTES_NAMES_REGEX.getFrom(options);
        this.outputAttributesNamesRegexPattern = Pattern.compile(this.outputAttributesNamesRegex);
        this.outputIdAttributeRegex = FlexmarkHtmlParser.OUTPUT_ID_ATTRIBUTE_REGEX.getFrom(options);
        this.outputIdAttributeRegexPattern = Pattern.compile(this.outputIdAttributeRegex);
        this.tableCellAlignmentMap = FlexmarkHtmlParser.TABLE_CELL_ALIGNMENT_MAP.getFrom(options);
        this.tableOptions = new TableFormatOptions(options);
    }

    @Override
    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.set(FlexmarkHtmlParser.LIST_CONTENT_INDENT, this.listContentIndent);
        dataHolder.set(FlexmarkHtmlParser.SETEXT_HEADINGS, this.setextHeadings);
        dataHolder.set(FlexmarkHtmlParser.OUTPUT_UNKNOWN_TAGS, this.outputUnknownTags);
        dataHolder.set(FlexmarkHtmlParser.TYPOGRAPHIC_QUOTES, this.typographicQuotes);
        dataHolder.set(FlexmarkHtmlParser.TYPOGRAPHIC_SMARTS, this.typographicSmarts);
        dataHolder.set(FlexmarkHtmlParser.OUTPUT_ATTRIBUTES_ID, this.outputAttributesIdAttr);
        dataHolder.set(FlexmarkHtmlParser.WRAP_AUTO_LINKS, this.wrapAutoLinks);
        dataHolder.set(FlexmarkHtmlParser.EXTRACT_AUTO_LINKS, this.extractAutoLinks);
        dataHolder.set(FlexmarkHtmlParser.RENDER_COMMENTS, this.renderComments);
        dataHolder.set(FlexmarkHtmlParser.DOT_ONLY_NUMERIC_LISTS, this.dotOnlyNumericLists);
        dataHolder.set(FlexmarkHtmlParser.PRE_CODE_PRESERVE_EMPHASIS, this.preCodePreserveEmphasis);
        dataHolder.set(FlexmarkHtmlParser.LISTS_END_ON_DOUBLE_BLANK, this.listsEndOnDoubleBlank);
        dataHolder.set(FlexmarkHtmlParser.DIV_AS_PARAGRAPH, this.divAsParagraph);
        dataHolder.set(FlexmarkHtmlParser.BR_AS_PARA_BREAKS, this.brAsParaBreaks);
        dataHolder.set(FlexmarkHtmlParser.BR_AS_EXTRA_BLANK_LINES, this.brAsExtraBlankLines);
        dataHolder.set(FlexmarkHtmlParser.IGNORE_TABLE_HEADING_AFTER_ROWS, this.ignoreTableHeadingAfterRows);
        dataHolder.set(FlexmarkHtmlParser.ADD_TRAILING_EOL, this.addTrailingEol);
        dataHolder.set(FlexmarkHtmlParser.SKIP_INLINE_STRONG, this.skipInlineStrong);
        dataHolder.set(FlexmarkHtmlParser.SKIP_INLINE_EMPHASIS, this.skipInlineEmphasis);
        dataHolder.set(FlexmarkHtmlParser.SKIP_INLINE_CODE, this.skipInlineCode);
        dataHolder.set(FlexmarkHtmlParser.SKIP_INLINE_DEL, this.skipInlineDel);
        dataHolder.set(FlexmarkHtmlParser.SKIP_INLINE_INS, this.skipInlineIns);
        dataHolder.set(FlexmarkHtmlParser.SKIP_INLINE_SUB, this.skipInlineSub);
        dataHolder.set(FlexmarkHtmlParser.SKIP_INLINE_SUP, this.skipInlineSup);
        dataHolder.set(FlexmarkHtmlParser.SKIP_HEADING_1, this.skipHeading1);
        dataHolder.set(FlexmarkHtmlParser.SKIP_HEADING_2, this.skipHeading2);
        dataHolder.set(FlexmarkHtmlParser.SKIP_HEADING_3, this.skipHeading3);
        dataHolder.set(FlexmarkHtmlParser.SKIP_HEADING_4, this.skipHeading4);
        dataHolder.set(FlexmarkHtmlParser.SKIP_HEADING_5, this.skipHeading5);
        dataHolder.set(FlexmarkHtmlParser.SKIP_HEADING_6, this.skipHeading6);
        dataHolder.set(FlexmarkHtmlParser.SKIP_ATTRIBUTES, this.skipAttributes);
        dataHolder.set(FlexmarkHtmlParser.SKIP_FENCED_CODE, this.skipFencedCode);
        dataHolder.set(FlexmarkHtmlParser.SKIP_LINKS, this.skipLinks);
        dataHolder.set(FlexmarkHtmlParser.SKIP_CHAR_ESCAPE, this.skipCharEscape);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_STRONG, this.extInlineStrong);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_EMPHASIS, this.extInlineEmphasis);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_CODE, this.extInlineCode);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_DEL, this.extInlineDel);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_INS, this.extInlineIns);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_SUB, this.extInlineSub);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_SUP, this.extInlineSup);
        dataHolder.set(FlexmarkHtmlParser.ORDERED_LIST_DELIMITER, Character.valueOf(this.orderedListDelimiter));
        dataHolder.set(FlexmarkHtmlParser.UNORDERED_LIST_DELIMITER, Character.valueOf(this.unorderedListDelimiter));
        dataHolder.set(FlexmarkHtmlParser.DEFINITION_MARKER_SPACES, this.definitionMarkerSpaces);
        dataHolder.set(FlexmarkHtmlParser.MIN_SETEXT_HEADING_MARKER_LENGTH, this.minSetextHeadingMarkerLength);
        dataHolder.set(FlexmarkHtmlParser.CODE_INDENT, this.codeIndent);
        dataHolder.set(FlexmarkHtmlParser.EOL_IN_TITLE_ATTRIBUTE, this.eolInTitleAttribute);
        dataHolder.set(FlexmarkHtmlParser.NBSP_TEXT, this.nbspText);
        dataHolder.set(FlexmarkHtmlParser.THEMATIC_BREAK, this.thematicBreak);
        dataHolder.set(FlexmarkHtmlParser.OUTPUT_ATTRIBUTES_NAMES_REGEX, this.outputAttributesNamesRegex);
        dataHolder.set(FlexmarkHtmlParser.TABLE_CELL_ALIGNMENT_MAP, this.tableCellAlignmentMap);
        dataHolder.set(FlexmarkHtmlParser.OUTPUT_ID_ATTRIBUTE_REGEX, this.outputIdAttributeRegex);
        dataHolder.set(FlexmarkHtmlParser.EXT_MATH, this.extMath);
        dataHolder.set(FlexmarkHtmlParser.EXT_TABLES, this.extTables);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_LINK, this.extInlineLink);
        dataHolder.set(FlexmarkHtmlParser.EXT_INLINE_IMAGE, this.extInlineImage);
        dataHolder.setFrom(this.tableOptions);
        return dataHolder;
    }
}

