/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumeratedReferenceOptions;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessor;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.ReferencePreProcessorFactory;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnumeratedReferenceParagraphPreProcessor
implements ParagraphPreProcessor {
    static String ENUM_REF_ID = "(?:[^0-9].*)?";
    static Pattern ENUM_REF_DEF_PARAGRAPH_PATTERN = Pattern.compile("\\s{0,3}(\\[[\\@]\\s*(" + ENUM_REF_ID + ")\\s*\\]:)\\s+(.*\n)");
    private final EnumeratedReferenceOptions options;
    private final EnumeratedReferenceRepository enumeratedReferences;

    private EnumeratedReferenceParagraphPreProcessor(DataHolder options) {
        this.options = new EnumeratedReferenceOptions(options);
        this.enumeratedReferences = EnumeratedReferenceExtension.ENUMERATED_REFERENCES.getFrom(options);
    }

    @Override
    public int preProcessBlock(Paragraph block, ParserState state) {
        BasedSequence trySequence = block.getChars();
        Matcher matcher = ENUM_REF_DEF_PARAGRAPH_PATTERN.matcher(trySequence);
        int lastFound = 0;
        while (matcher.find() && matcher.start() == lastFound) {
            lastFound = matcher.end();
            int openingStart = matcher.start(1);
            int openingEnd = matcher.end(1);
            int textEnd = lastFound;
            BasedSequence openingMarker = trySequence.subSequence(openingStart, openingStart + 2);
            BasedSequence text = trySequence.subSequence(openingStart + 2, openingEnd - 2).trim();
            BasedSequence closingMarker = trySequence.subSequence(openingEnd - 2, openingEnd);
            EnumeratedReferenceBlock enumeratedReferenceBlock = new EnumeratedReferenceBlock();
            enumeratedReferenceBlock.setOpeningMarker(openingMarker);
            enumeratedReferenceBlock.setText(text);
            enumeratedReferenceBlock.setClosingMarker(closingMarker);
            BasedSequence enumeratedReference = trySequence.subSequence(matcher.start(3), matcher.end(3));
            enumeratedReferenceBlock.setEnumeratedReference(enumeratedReference);
            Paragraph paragraph = new Paragraph(enumeratedReference);
            enumeratedReferenceBlock.appendChild(paragraph);
            enumeratedReferenceBlock.setCharsFromContent();
            block.insertBefore(enumeratedReferenceBlock);
            state.blockAdded(enumeratedReferenceBlock);
            this.enumeratedReferences.put(enumeratedReferenceBlock.getText().toString(), enumeratedReferenceBlock);
        }
        return lastFound;
    }

    public static ParagraphPreProcessorFactory Factory() {
        return new ParagraphPreProcessorFactory(){

            @Override
            public boolean affectsGlobalScope() {
                return true;
            }

            @Override
            public Set<Class<? extends ParagraphPreProcessorFactory>> getAfterDependents() {
                return null;
            }

            @Override
            public Set<Class<? extends ParagraphPreProcessorFactory>> getBeforeDependents() {
                HashSet<Class<? extends ParagraphPreProcessorFactory>> set = new HashSet<Class<? extends ParagraphPreProcessorFactory>>();
                set.add(ReferencePreProcessorFactory.class);
                return set;
            }

            @Override
            public ParagraphPreProcessor create(ParserState state) {
                return new EnumeratedReferenceParagraphPreProcessor(state.getProperties());
            }
        };
    }
}

