/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.enumerated.reference.internal;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class EnumeratedReferenceNodePostProcessor
extends NodePostProcessor {
    private final EnumeratedReferences enumeratedReferences;
    private final HtmlIdGenerator headerIdGenerator;

    public EnumeratedReferenceNodePostProcessor(Document document) {
        this.enumeratedReferences = EnumeratedReferenceExtension.ENUMERATED_REFERENCE_ORDINALS.getFrom(document);
        this.headerIdGenerator = new HeaderIdGenerator.Factory().create();
        this.headerIdGenerator.generateIds(document);
    }

    @Override
    public void process(NodeTracker state, Node node) {
        block2: {
            block3: {
                if (!(node instanceof AttributesNode)) break block3;
                AttributesNode attributesNode = (AttributesNode)node;
                for (Node attributeNode : attributesNode.getChildren()) {
                    if (!(attributeNode instanceof AttributeNode) || !((AttributeNode)attributeNode).isId()) continue;
                    String text = ((AttributeNode)attributeNode).getValue().toString();
                    this.enumeratedReferences.add(text);
                    break block2;
                }
                break block2;
            }
            if (!(node instanceof Heading)) break block2;
            for (Node child : node.getChildren()) {
                BasedSequence text;
                String type;
                if (!(child instanceof EnumeratedReferenceText) || !(type = EnumeratedReferenceRepository.getType((text = ((EnumeratedReferenceText)child).getText()).toString())).isEmpty() && !text.equals(type + ":")) continue;
                String id = (type.isEmpty() ? text : type) + ":" + this.headerIdGenerator.getId(node);
                this.enumeratedReferences.add(id);
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(AttributesNode.class, Heading.class);
        }

        @Override
        public NodePostProcessor create(Document document) {
            return new EnumeratedReferenceNodePostProcessor(document);
        }
    }
}

