/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserTracker;
import com.vladsch.flexmark.util.BlockTracker;
import com.vladsch.flexmark.util.Paired;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.ClassificationBag;
import com.vladsch.flexmark.util.collection.CollectionHost;
import com.vladsch.flexmark.util.collection.OrderedMultiMap;
import com.vladsch.flexmark.util.collection.OrderedSet;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import com.vladsch.flexmark.util.mappers.NodeClassifier;

public class ClassifyingBlockTracker
implements BlockTracker,
BlockParserTracker {
    protected final ClassificationBag<Class<?>, Node> nodeClassifier = new ClassificationBag(NodeClassifier.INSTANCE);
    protected final OrderedMultiMap<BlockParser, Block> allBlockParsersMap = new OrderedMultiMap<BlockParser, Block>(new CollectionHost<Paired<BlockParser, Block>>(){

        @Override
        public void adding(int index, Paired<BlockParser, Block> paired, Object v) {
            Block block = paired.getSecond();
            if (block != null) {
                ClassifyingBlockTracker.this.nodeClassifier.add(block);
            }
        }

        @Override
        public Object removing(int index, Paired<BlockParser, Block> paired) {
            Block block = paired.getSecond();
            if (block != null) {
                ClassifyingBlockTracker.this.nodeClassifier.remove(block);
            }
            return paired;
        }

        @Override
        public void clearing() {
            ClassifyingBlockTracker.this.nodeClassifier.clear();
        }

        @Override
        public void addingNulls(int index) {
        }

        @Override
        public boolean skipHostUpdate() {
            return false;
        }

        @Override
        public int getIteratorModificationCount() {
            return ClassifyingBlockTracker.this.allBlockParsersMap.getModificationCount();
        }
    });

    public OrderedSet<BlockParser> allBlockParsers() {
        return this.allBlockParsersMap.keySet();
    }

    public OrderedSet<Block> allBlocks() {
        return this.allBlockParsersMap.valueSet();
    }

    public Block getValue(BlockParser parser) {
        return this.allBlockParsersMap.getKeyValue(parser);
    }

    public BlockParser getKey(Block parser) {
        return this.allBlockParsersMap.getValueKey(parser);
    }

    public boolean containsKey(BlockParser parser) {
        return this.allBlockParsersMap.containsKey(parser);
    }

    public boolean containsValue(Block parser) {
        return this.allBlockParsersMap.containsValue(parser);
    }

    public ClassificationBag<Class<?>, Node> getNodeClassifier() {
        return this.nodeClassifier;
    }

    @Override
    public void blockParserAdded(BlockParser blockParser) {
        this.allBlockParsersMap.putKeyValue(blockParser, blockParser.getBlock());
    }

    @Override
    public void blockParserRemoved(BlockParser blockParser) {
        this.allBlockParsersMap.removeKey(blockParser);
    }

    private void validateLinked(Node node) {
        if (node.getNext() == null && node.getParent() == null) {
            throw new IllegalStateException("Added block " + node + " is not linked into the AST");
        }
    }

    @Override
    public void blockAdded(Block node) {
        this.validateLinked(node);
        this.allBlockParsersMap.putValueKey(node, null);
    }

    @Override
    public void blockAddedWithChildren(Block node) {
        this.validateLinked(node);
        this.allBlockParsersMap.putValueKey(node, null);
        this.addBlocks(node.getChildren());
    }

    @Override
    public void blockAddedWithDescendants(Block node) {
        this.validateLinked(node);
        this.allBlockParsersMap.putValueKey(node, null);
        this.addBlocks(node.getDescendants());
    }

    private void addBlocks(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            if (!(child instanceof Block)) continue;
            this.allBlockParsersMap.putValueKey((Block)child, null);
        }
    }

    private void validateUnlinked(Node node) {
        if (node.getNext() != null || node.getParent() != null) {
            throw new IllegalStateException("Removed block " + node + " is still linked in the AST");
        }
    }

    @Override
    public void blockRemoved(Block node) {
        this.validateUnlinked(node);
        this.allBlockParsersMap.removeValue(node);
    }

    @Override
    public void blockRemovedWithChildren(Block node) {
        this.validateUnlinked(node);
        this.allBlockParsersMap.removeValue(node);
        this.removeBlocks(node.getChildren());
    }

    @Override
    public void blockRemovedWithDescendants(Block node) {
        this.validateUnlinked(node);
        this.allBlockParsersMap.removeValue(node);
        this.removeBlocks(node.getDescendants());
    }

    private void removeBlocks(ReversiblePeekingIterable<Node> nodes) {
        for (Node child : nodes) {
            if (!(child instanceof Block)) continue;
            this.allBlockParsersMap.removeValue(child);
        }
    }
}

