/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.toc;

import com.vladsch.flexmark.util.ast.CustomBlock;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public abstract class TocBlockBase
extends CustomBlock {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence tocKeyword = BasedSequence.NULL;
    protected BasedSequence style = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;

    @Override
    public void getAstExtra(StringBuilder out) {
        TocBlockBase.segmentSpan(out, this.openingMarker, "openingMarker");
        TocBlockBase.segmentSpan(out, this.tocKeyword, "tocKeyword");
        TocBlockBase.segmentSpan(out, this.style, "style");
        TocBlockBase.segmentSpan(out, this.closingMarker, "closingMarker");
    }

    @Override
    public BasedSequence[] getSegments() {
        BasedSequence[] nodeSegments = new BasedSequence[]{this.openingMarker, this.tocKeyword, this.style, this.closingMarker};
        if (this.lineSegments.size() == 0) {
            return nodeSegments;
        }
        BasedSequence[] allSegments = new BasedSequence[this.lineSegments.size() + nodeSegments.length];
        this.lineSegments.toArray(allSegments);
        System.arraycopy(allSegments, 0, allSegments, nodeSegments.length, this.lineSegments.size());
        return allSegments;
    }

    public TocBlockBase(BasedSequence chars) {
        this(chars, false);
    }

    public TocBlockBase(BasedSequence chars, boolean closingSimToc) {
        this(chars, null, closingSimToc);
    }

    public TocBlockBase(BasedSequence chars, BasedSequence styleChars) {
        this(chars, styleChars, false);
    }

    public TocBlockBase(BasedSequence chars, BasedSequence styleChars, boolean closingSimToc) {
        super(chars);
        this.openingMarker = chars.subSequence(0, 1);
        this.tocKeyword = chars.subSequence(1, 4);
        if (styleChars != null) {
            this.style = styleChars;
        }
        int closingPos = chars.indexOf(']', 4);
        if (closingSimToc && (closingPos == -1 || closingPos + 1 >= chars.length() || chars.charAt(closingPos + 1) != ':')) {
            throw new IllegalStateException("Invalid TOC block sequence");
        }
        this.closingMarker = chars.subSequence(closingPos, closingPos + (closingSimToc ? 2 : 1));
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public BasedSequence getTocKeyword() {
        return this.tocKeyword;
    }

    public BasedSequence getStyle() {
        return this.style;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }
}

