/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables;

import com.vladsch.flexmark.ast.CustomNode;
import com.vladsch.flexmark.ast.DelimitedNode;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ast.util.TextNodeConverter;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class TableCell
extends CustomNode
implements DelimitedNode {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    private boolean header;
    private Alignment alignment;
    private int span = 1;

    public void trimWhiteSpace() {
        Node next;
        Node child = this.getFirstChild();
        while (child != null && child instanceof WhiteSpace) {
            next = child.getNext();
            child.unlink();
            child = next;
        }
        child = this.getLastChild();
        while (child != null && child instanceof WhiteSpace) {
            next = child.getPrevious();
            child.unlink();
            child = next;
        }
    }

    public void mergeWhiteSpace() {
        Text text;
        boolean hadWhitespace = false;
        Node child = this.getFirstChild();
        while (child != null && child instanceof WhiteSpace) {
            Node next = child.getNext();
            text = new Text(child.getChars());
            child.insertBefore(text);
            child.unlink();
            child = next;
            hadWhitespace = true;
        }
        child = this.getLastChild();
        while (child != null && child instanceof WhiteSpace) {
            Node previous = child.getPrevious();
            text = new Text(child.getChars());
            child.insertBefore(text);
            child.unlink();
            child = previous;
            hadWhitespace = true;
        }
        if (hadWhitespace) {
            TextNodeConverter.mergeTextNodes(this);
        }
    }

    @Override
    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    @Override
    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    @Override
    public BasedSequence getText() {
        return this.text;
    }

    @Override
    public void setText(BasedSequence text) {
        this.text = text;
    }

    @Override
    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    @Override
    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public int getSpan() {
        return this.span;
    }

    public void setSpan(int span) {
        this.span = span;
    }

    @Override
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.text, this.closingMarker};
    }

    @Override
    public void getAstExtra(StringBuilder out) {
        if (this.alignment != null) {
            out.append(" ").append((Object)this.alignment);
        }
        if (this.header) {
            out.append(" header");
        }
        if (this.span > 1) {
            out.append(" span");
        }
        TableCell.delimitedSegmentSpanChars(out, this.openingMarker, this.text, this.closingMarker, "text");
    }

    public TableCell() {
    }

    public TableCell(BasedSequence chars) {
        super(chars);
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;


        public CellAlignment cellAlignment() {
            switch (this) {
                case CENTER: {
                    return CellAlignment.CENTER;
                }
                case LEFT: {
                    return CellAlignment.LEFT;
                }
                case RIGHT: {
                    return CellAlignment.RIGHT;
                }
            }
            return CellAlignment.NONE;
        }
    }
}

