/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.AttributesOptions;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;

public class AttributesNodePostProcessor
extends NodePostProcessor {
    private final NodeAttributeRepository nodeAttributeRepository;
    private final AttributesOptions myOptions;

    public AttributesNodePostProcessor(Document document) {
        this.nodeAttributeRepository = AttributesExtension.NODE_ATTRIBUTES.getFrom(document);
        this.myOptions = new AttributesOptions(document);
    }

    public Node getAttributeOwner(NodeTracker state, AttributesNode attributesNode) {
        Node attributeOwner;
        Node previous = attributesNode.getPrevious();
        Node next = attributesNode.getNext();
        Node parent = attributesNode.getParent();
        if (previous == null) {
            attributeOwner = parent instanceof Paragraph ? (parent.getParent() instanceof ParagraphItemContainer ? (parent.getPrevious() == null ? parent.getParent().getParent() : (attributesNode.getNextAnyNot(AttributesNode.class) == null ? parent.getPrevious() : parent)) : (attributesNode.getNextAnyNot(AttributesNode.class) == null ? (parent.getPrevious() == null ? parent.getParent() : parent.getPrevious()) : parent)) : parent;
        } else if (!this.myOptions.assignTextAttributes && (previous instanceof Text || previous instanceof TextBase) || previous.getChars().getEndOffset() < attributesNode.getStartOffset()) {
            attributeOwner = parent instanceof Paragraph && parent.getParent() instanceof ParagraphItemContainer ? parent.getParent() : parent;
        } else if (previous instanceof Text) {
            TextBase textBase = new TextBase(previous.getChars());
            previous.insertBefore(textBase);
            previous.unlink();
            state.nodeRemoved(previous);
            textBase.appendChild(previous);
            state.nodeAddedWithChildren(textBase);
            attributeOwner = textBase;
        } else {
            attributeOwner = previous instanceof AttributesNode ? this.getAttributeOwner(state, (AttributesNode)previous) : previous;
        }
        return attributeOwner;
    }

    @Override
    public void process(NodeTracker state, Node node) {
        if (node instanceof AttributesNode) {
            Node tmp;
            AttributesNode attributesNode = (AttributesNode)node;
            Node previous = attributesNode.getPrevious();
            Node next = attributesNode.getNext();
            if (previous == null && next != null && !(next instanceof AttributesNode)) {
                if (next.getChars().isBlank()) {
                    tmp = next;
                    next = next.getNext();
                    tmp.unlink();
                    state.nodeRemoved(tmp);
                } else {
                    next.setChars(next.getChars().trimStart());
                }
            }
            if (next == null && previous != null && !(previous instanceof AttributesNode)) {
                if (previous.getChars().isBlank()) {
                    tmp = previous;
                    previous = previous.getPrevious();
                    tmp.unlink();
                    state.nodeRemoved(tmp);
                } else {
                    previous.setChars(previous.getChars().trimEnd());
                }
            }
            Node attributeOwner = this.getAttributeOwner(state, attributesNode);
            this.nodeAttributeRepository.put(attributeOwner, attributesNode);
            if (attributeOwner instanceof AnchorRefTarget) {
                for (Node attributeNode : attributesNode.getReversedChildren()) {
                    if (!(attributeNode instanceof AttributeNode) || !((AttributeNode)attributeNode).isId()) continue;
                    ((AnchorRefTarget)((Object)attributeOwner)).setAnchorRefId(((AttributeNode)attributeNode).getValue().toString());
                    break;
                }
            }
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodes(AttributesNode.class);
        }

        @Override
        public NodePostProcessor create(Document document) {
            return new AttributesNodePostProcessor(document);
        }
    }
}

