/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.formatter.TranslationHandler;
import com.vladsch.flexmark.formatter.TranslationPlaceholderGenerator;
import com.vladsch.flexmark.formatter.internal.FormatterOptions;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGeneratorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TranslationHandlerImpl
implements TranslationHandler {
    final FormatterOptions myFormatterOptions;
    final HashMap<String, String> myNonTranslatingTexts;
    final HashMap<String, String> myTranslatingTexts;
    final HashMap<String, String> myTranslatedTexts;
    final ArrayList<String> myTranslatingPlaceholders;
    final ArrayList<String> myTranslatingSpans;
    final ArrayList<String> myNonTranslatingSpans;
    final ArrayList<String> myTranslatedSpans;
    final HtmlIdGeneratorFactory myIdGeneratorFactory;
    final Pattern myPlaceHolderMarkerPattern;
    final MutableDataSet myTranslationStore;
    final HashMap<String, Integer> myOriginalRefTargets;
    final HashMap<Integer, String> myTranslatedRefTargets;
    final HashMap<String, String> myOriginalAnchors;
    final HashMap<String, String> myTranslatedAnchors;
    private int myPlaceholderId = 0;
    private int myAnchorId = 0;
    private int myTranslatingSpanId = 0;
    private int myNonTranslatingSpanId = 0;
    private RenderPurpose myRenderPurpose;
    private MarkdownWriter myWriter;
    private HtmlIdGenerator myIdGenerator;
    private TranslationPlaceholderGenerator myPlaceholderGenerator;

    public TranslationHandlerImpl(DataHolder options, FormatterOptions formatterOptions, HtmlIdGeneratorFactory idGeneratorFactory) {
        this.myFormatterOptions = formatterOptions;
        this.myIdGeneratorFactory = idGeneratorFactory;
        this.myNonTranslatingTexts = new HashMap();
        this.myTranslatingTexts = new HashMap();
        this.myTranslatedTexts = new HashMap();
        this.myOriginalAnchors = new HashMap();
        this.myTranslatedAnchors = new HashMap();
        this.myTranslatedRefTargets = new HashMap();
        this.myOriginalRefTargets = new HashMap();
        this.myTranslatingSpans = new ArrayList();
        this.myTranslatedSpans = new ArrayList();
        this.myTranslatingPlaceholders = new ArrayList();
        this.myNonTranslatingSpans = new ArrayList();
        this.myPlaceHolderMarkerPattern = Pattern.compile(formatterOptions.translationExcludePattern);
        this.myTranslationStore = new MutableDataSet();
    }

    public MutableDataSet getTranslationStore() {
        return this.myTranslationStore;
    }

    @Override
    public void beginRendering(Document node, NodeFormatterContext context, MarkdownWriter appendable) {
        this.myWriter = appendable;
        this.myIdGenerator = this.myIdGeneratorFactory.create();
        this.myIdGenerator.generateIds(node);
    }

    static boolean isBlank(CharSequence csq) {
        int iMax = csq.length();
        for (int i = 0; i < iMax; ++i) {
            if (Character.isWhitespace(csq.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getTranslatingTexts() {
        this.myTranslatingPlaceholders.clear();
        this.myTranslatingPlaceholders.ensureCapacity(this.myTranslatedSpans.size() + this.myTranslatedTexts.size());
        ArrayList<String> translatingSnippets = new ArrayList<String>(this.myTranslatedSpans.size() + this.myTranslatedTexts.size());
        HashMap<String, Integer> repeatedTranslatingIndices = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : this.myTranslatingTexts.entrySet()) {
            if (TranslationHandlerImpl.isBlank(entry.getValue()) || this.myPlaceHolderMarkerPattern.matcher(entry.getValue()).matches() || repeatedTranslatingIndices.containsKey(entry.getValue())) continue;
            repeatedTranslatingIndices.put(entry.getValue(), translatingSnippets.size());
            translatingSnippets.add(entry.getValue());
            this.myTranslatingPlaceholders.add(entry.getKey());
        }
        for (CharSequence charSequence : this.myTranslatingSpans) {
            if (TranslationHandlerImpl.isBlank(charSequence) || this.myPlaceHolderMarkerPattern.matcher(charSequence).matches()) continue;
            translatingSnippets.add(charSequence.toString());
        }
        return translatingSnippets;
    }

    @Override
    public void setTranslatedTexts(List<CharSequence> translatedTexts) {
        this.myTranslatedTexts.clear();
        this.myTranslatedTexts.putAll(this.myTranslatingTexts);
        this.myTranslatedSpans.clear();
        this.myTranslatedSpans.ensureCapacity(this.myTranslatingSpans.size());
        int i = 0;
        int iMax = translatedTexts.size();
        int placeholderSize = this.myTranslatingPlaceholders.size();
        HashMap<String, Integer> repeatedTranslatingIndices = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : this.myTranslatingTexts.entrySet()) {
            if (TranslationHandlerImpl.isBlank(entry.getValue()) || this.myPlaceHolderMarkerPattern.matcher(entry.getValue()).matches()) continue;
            Integer index = (Integer)repeatedTranslatingIndices.get(entry.getValue());
            if (index == null) {
                if (i >= placeholderSize) break;
                repeatedTranslatingIndices.put(entry.getValue(), i);
                this.myTranslatedTexts.put(entry.getKey(), translatedTexts.get(i).toString());
                ++i;
                continue;
            }
            this.myTranslatedTexts.put(entry.getKey(), translatedTexts.get(index).toString());
        }
        for (CharSequence charSequence : this.myTranslatingSpans) {
            if (!TranslationHandlerImpl.isBlank(charSequence) && !this.myPlaceHolderMarkerPattern.matcher(charSequence).matches()) {
                this.myTranslatedSpans.add(translatedTexts.get(i).toString());
                ++i;
                continue;
            }
            this.myTranslatedSpans.add(charSequence.toString());
        }
    }

    @Override
    public void setRenderPurpose(RenderPurpose renderPurpose) {
        this.myAnchorId = 0;
        this.myTranslatingSpanId = 0;
        this.myPlaceholderId = 0;
        this.myRenderPurpose = renderPurpose;
        this.myNonTranslatingSpanId = 0;
    }

    @Override
    public RenderPurpose getRenderPurpose() {
        return this.myRenderPurpose;
    }

    @Override
    public boolean isTransformingText() {
        return this.myRenderPurpose != RenderPurpose.FORMAT;
    }

    @Override
    public CharSequence transformAnchorRef(CharSequence pageRef, CharSequence anchorRef) {
        switch (this.myRenderPurpose) {
            case TRANSLATION_SPANS: {
                String replacedTextId = String.format(this.myFormatterOptions.translationIdFormat, ++this.myAnchorId);
                this.myNonTranslatingTexts.put(replacedTextId, anchorRef.toString());
                return replacedTextId;
            }
            case TRANSLATED_SPANS: {
                return String.format(this.myFormatterOptions.translationIdFormat, ++this.myAnchorId);
            }
            case TRANSLATED: {
                String placeholderId = String.format(this.myFormatterOptions.translationIdFormat, ++this.myAnchorId);
                String resolvedPageRef = this.myNonTranslatingTexts.get(pageRef.toString());
                if (resolvedPageRef != null && resolvedPageRef.length() == 0) {
                    String translatedRefId;
                    String refId = this.myNonTranslatingTexts.get(placeholderId);
                    if (refId == null) break;
                    Integer spanIndex = this.myOriginalRefTargets.get(refId);
                    if (spanIndex != null && (translatedRefId = this.myTranslatedRefTargets.get(spanIndex)) != null) {
                        return translatedRefId;
                    }
                    return refId;
                }
                String resolvedAnchorRef = this.myNonTranslatingTexts.get(placeholderId);
                if (resolvedAnchorRef == null) break;
                return resolvedAnchorRef;
            }
        }
        return anchorRef;
    }

    @Override
    public void customPlaceholderFormat(TranslationPlaceholderGenerator generator, TranslatingSpanRender render) {
        if (this.myRenderPurpose != RenderPurpose.TRANSLATED_SPANS) {
            TranslationPlaceholderGenerator savedGenerator = this.myPlaceholderGenerator;
            this.myPlaceholderGenerator = generator;
            render.render(this.myWriter.getContext(), this.myWriter);
            this.myPlaceholderGenerator = savedGenerator;
        }
    }

    @Override
    public void translatingSpan(TranslatingSpanRender render) {
        this.translatingRefTargetSpan(null, render);
    }

    private String renderInSubContext(TranslatingSpanRender render, boolean copyToMain) {
        MarkdownWriter writer;
        StringBuilder span = new StringBuilder();
        MarkdownWriter savedMarkdown = this.myWriter;
        NodeFormatterContext subContext = this.myWriter.getContext().getSubContext(span);
        this.myWriter = writer = subContext.getMarkdown();
        render.render(subContext, writer);
        int pendingEOL = writer.getPendingEOL();
        writer.flush(-1);
        String spanText = writer.getText();
        this.myWriter = savedMarkdown;
        if (copyToMain) {
            this.myWriter.append(spanText);
            if (pendingEOL == 1) {
                this.myWriter.line();
            } else {
                this.myWriter.blankLine(pendingEOL - 1);
            }
        }
        return spanText;
    }

    @Override
    public void translatingRefTargetSpan(Node target, TranslatingSpanRender render) {
        switch (this.myRenderPurpose) {
            case TRANSLATION_SPANS: {
                String spanText = this.renderInSubContext(render, true);
                if (target != null) {
                    String id = this.myIdGenerator.getId(target);
                    this.myOriginalRefTargets.put(id, this.myTranslatingSpans.size());
                }
                this.myTranslatingSpans.add(spanText);
                return;
            }
            case TRANSLATED_SPANS: {
                String spanText = this.renderInSubContext(render, false);
                String translated = this.myTranslatedSpans.get(this.myTranslatingSpanId);
                if (target != null) {
                    String id = this.myIdGenerator.getId((CharSequence)translated);
                    this.myTranslatedRefTargets.put(this.myTranslatingSpanId, id);
                }
                ++this.myTranslatingSpanId;
                this.myWriter.append(translated);
                return;
            }
            case TRANSLATED: {
                if (target != null) {
                    String id = this.myIdGenerator.getId(target);
                    this.myTranslatedRefTargets.put(this.myTranslatingSpanId, id);
                }
                ++this.myTranslatingSpanId;
                String spanText = this.renderInSubContext(render, true);
                return;
            }
        }
        render.render(this.myWriter.getContext(), this.myWriter);
    }

    @Override
    public void nonTranslatingSpan(TranslatingSpanRender render) {
        switch (this.myRenderPurpose) {
            case TRANSLATION_SPANS: {
                String spanText = this.renderInSubContext(render, false);
                this.myNonTranslatingSpans.add(spanText);
                ++this.myNonTranslatingSpanId;
                String replacedTextId = this.getPlaceholderId(this.myFormatterOptions.translationIdFormat, this.myNonTranslatingSpanId, null, null, null);
                this.myWriter.append(replacedTextId);
                return;
            }
            case TRANSLATED_SPANS: {
                String spanText = this.renderInSubContext(render, false);
                String translated = this.myNonTranslatingSpans.get(this.myNonTranslatingSpanId);
                ++this.myNonTranslatingSpanId;
                this.myWriter.append(translated);
                return;
            }
            case TRANSLATED: {
                String spanText = this.renderInSubContext(render, true);
                ++this.myNonTranslatingSpanId;
                return;
            }
        }
        render.render(this.myWriter.getContext(), this.myWriter);
    }

    public String getPlaceholderId(String format, int placeholderId, CharSequence prefix, CharSequence suffix, CharSequence suffix2) {
        String replacedTextId;
        String string = replacedTextId = this.myPlaceholderGenerator != null ? this.myPlaceholderGenerator.getPlaceholder(placeholderId) : String.format(format, placeholderId);
        if (prefix == null && suffix == null && suffix2 == null) {
            return replacedTextId;
        }
        return TranslationHandlerImpl.addPrefixSuffix(replacedTextId, prefix, suffix, suffix2);
    }

    public static String addPrefixSuffix(CharSequence placeholderId, CharSequence prefix, CharSequence suffix, CharSequence suffix2) {
        if (prefix == null && suffix == null && suffix2 == null) {
            return placeholderId.toString();
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        sb.append(placeholderId);
        if (suffix != null) {
            sb.append(suffix);
        }
        if (suffix2 != null) {
            sb.append(suffix2);
        }
        return sb.toString();
    }

    @Override
    public CharSequence transformNonTranslating(CharSequence prefix, CharSequence nonTranslatingText, CharSequence suffix, CharSequence suffix2) {
        switch (this.myRenderPurpose) {
            case TRANSLATION_SPANS: {
                CharSequence trimmedEOL;
                if (suffix2 != null) {
                    trimmedEOL = suffix2;
                } else {
                    BasedSequence basedSequence = BasedSequenceImpl.of((CharSequence)nonTranslatingText);
                    trimmedEOL = basedSequence.trimmedEOL();
                }
                String replacedTextId = this.getPlaceholderId(this.myFormatterOptions.translationIdFormat, ++this.myPlaceholderId, prefix, suffix, trimmedEOL);
                this.myNonTranslatingTexts.put(replacedTextId, nonTranslatingText.toString());
                return replacedTextId;
            }
            case TRANSLATED_SPANS: {
                return this.getPlaceholderId(this.myFormatterOptions.translationIdFormat, ++this.myPlaceholderId, prefix, suffix, suffix2);
            }
            case TRANSLATED: {
                if (nonTranslatingText.length() > 0) {
                    String text = this.myNonTranslatingTexts.get(nonTranslatingText.toString());
                    if (text == null) {
                        boolean tmp = false;
                        text = "";
                    }
                    return text;
                }
                return nonTranslatingText;
            }
        }
        return nonTranslatingText;
    }

    @Override
    public CharSequence transformTranslating(CharSequence prefix, CharSequence translatingText, CharSequence suffix, CharSequence suffix2) {
        switch (this.myRenderPurpose) {
            case TRANSLATION_SPANS: {
                String replacedTextId = this.getPlaceholderId(this.myFormatterOptions.translationIdFormat, ++this.myPlaceholderId, prefix, suffix, suffix2);
                this.myTranslatingTexts.put(replacedTextId, translatingText.toString());
                return replacedTextId;
            }
            case TRANSLATED_SPANS: {
                return this.getPlaceholderId(this.myFormatterOptions.translationIdFormat, ++this.myPlaceholderId, prefix, suffix, suffix2);
            }
            case TRANSLATED: {
                CharSequence replacedText = prefix == null && suffix == null && suffix2 == null ? translatingText : TranslationHandlerImpl.addPrefixSuffix(translatingText, prefix, suffix, suffix2);
                CharSequence text = this.myTranslatedTexts.get(replacedText);
                if (text != null && (prefix != null || suffix != null || suffix2 != null)) {
                    return TranslationHandlerImpl.addPrefixSuffix(text, prefix, suffix, suffix2);
                }
                if (text == null) break;
                return text;
            }
        }
        return translatingText;
    }
}

