/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter.internal;

import com.vladsch.flexmark.formatter.internal.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.CodeFenceMarker;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.util.format.options.ListBulletMarker;
import com.vladsch.flexmark.util.format.options.ListNumberedMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.mappers.CharWidthProvider;
import com.vladsch.flexmark.util.options.DataHolder;

public class FormatterOptions {
    public final boolean itemContentIndent;
    public final ParserEmulationProfile emulationProfile;
    public final boolean setextHeaderEqualizeMarker;
    public final int formatFlags;
    public final int maxBlankLines;
    public final int maxTrailingBlankLines;
    public final int minSetextMarkerLength;
    public final DiscretionaryText spaceAfterAtxMarker;
    public final EqualizeTrailingMarker atxHeaderTrailingMarker;
    public final boolean blockQuoteBlankLines;
    public final BlockQuoteMarker blockQuoteMarkers;
    public final String thematicBreak;
    public final boolean indentedCodeMinimizeIndent;
    public final boolean fencedCodeMinimizeIndent;
    public final boolean fencedCodeMatchClosingMarker;
    public final boolean fencedCodeSpaceBeforeInfo;
    public final int fencedCodeMarkerLength;
    public final CodeFenceMarker fencedCodeMarkerType;
    public final boolean listAddBlankLineBefore;
    public final boolean listRenumberItems;
    public final boolean listRemoveEmptyItems;
    public final ListBulletMarker listBulletMarker;
    public final ListNumberedMarker listNumberedMarker;
    public final ListSpacing listSpacing;
    public final ElementPlacement referencePlacement;
    public final ElementPlacementSort referenceSort;
    public final boolean keepImageLinksAtStart;
    public final boolean keepExplicitLinksAtStart;
    public final CharWidthProvider charWidthProvider;

    public FormatterOptions(DataHolder options) {
        this.emulationProfile = (ParserEmulationProfile)Formatter.FORMATTER_EMULATION_PROFILE.getFrom(options);
        this.itemContentIndent = this.emulationProfile.family != ParserEmulationProfile.FIXED_INDENT;
        this.setextHeaderEqualizeMarker = (Boolean)Formatter.SETEXT_HEADER_EQUALIZE_MARKER.getFrom(options);
        this.formatFlags = (Integer)Formatter.FORMAT_FLAGS.getFrom(options);
        this.maxBlankLines = (Integer)Formatter.MAX_BLANK_LINES.getFrom(options);
        this.maxTrailingBlankLines = (Integer)Formatter.MAX_TRAILING_BLANK_LINES.getFrom(options);
        this.spaceAfterAtxMarker = (DiscretionaryText)Formatter.SPACE_AFTER_ATX_MARKER.getFrom(options);
        this.atxHeaderTrailingMarker = (EqualizeTrailingMarker)Formatter.ATX_HEADER_TRAILING_MARKER.getFrom(options);
        this.minSetextMarkerLength = (Integer)Parser.HEADING_SETEXT_MARKER_LENGTH.getFrom(options);
        this.thematicBreak = (String)Formatter.THEMATIC_BREAK.getFrom(options);
        this.blockQuoteBlankLines = (Boolean)Formatter.BLOCK_QUOTE_BLANK_LINES.getFrom(options);
        this.blockQuoteMarkers = (BlockQuoteMarker)Formatter.BLOCK_QUOTE_MARKERS.getFrom(options);
        this.indentedCodeMinimizeIndent = (Boolean)Formatter.INDENTED_CODE_MINIMIZE_INDENT.getFrom(options);
        this.fencedCodeMinimizeIndent = (Boolean)Formatter.FENCED_CODE_MINIMIZE_INDENT.getFrom(options);
        this.fencedCodeMatchClosingMarker = (Boolean)Formatter.FENCED_CODE_MATCH_CLOSING_MARKER.getFrom(options);
        this.fencedCodeSpaceBeforeInfo = (Boolean)Formatter.FENCED_CODE_SPACE_BEFORE_INFO.getFrom(options);
        this.fencedCodeMarkerLength = (Integer)Formatter.FENCED_CODE_MARKER_LENGTH.getFrom(options);
        this.fencedCodeMarkerType = (CodeFenceMarker)Formatter.FENCED_CODE_MARKER_TYPE.getFrom(options);
        this.listAddBlankLineBefore = (Boolean)Formatter.LIST_ADD_BLANK_LINE_BEFORE.getFrom(options);
        this.listRenumberItems = (Boolean)Formatter.LIST_RENUMBER_ITEMS.getFrom(options);
        this.listRemoveEmptyItems = (Boolean)Formatter.LIST_REMOVE_EMPTY_ITEMS.getFrom(options);
        this.listBulletMarker = (ListBulletMarker)Formatter.LIST_BULLET_MARKER.getFrom(options);
        this.listNumberedMarker = (ListNumberedMarker)Formatter.LIST_NUMBERED_MARKER.getFrom(options);
        this.listSpacing = (ListSpacing)Formatter.LIST_SPACING.getFrom(options);
        this.referencePlacement = (ElementPlacement)Formatter.REFERENCE_PLACEMENT.getFrom(options);
        this.referenceSort = (ElementPlacementSort)Formatter.REFERENCE_SORT.getFrom(options);
        this.keepImageLinksAtStart = (Boolean)Formatter.KEEP_IMAGE_LINKS_AT_START.getFrom(options);
        this.keepExplicitLinksAtStart = (Boolean)Formatter.KEEP_EXPLICIT_LINKS_AT_START.getFrom(options);
        this.charWidthProvider = (CharWidthProvider)Formatter.CHAR_WIDTH_PROVIDER.getFrom(options);
    }
}

