/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.front.matter.internal;

import com.vladsch.flexmark.ast.Block;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.ext.front.matter.YamlFrontMatterNode;
import com.vladsch.flexmark.internal.DocumentBlockParser;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YamlFrontMatterBlockParser
extends AbstractBlockParser {
    private static final Pattern REGEX_METADATA = Pattern.compile("^[ ]{0,3}([A-Za-z0-9_-]+):\\s*(.*)");
    private static final Pattern REGEX_METADATA_LIST = Pattern.compile("^[ ]+-\\s*(.*)");
    private static final Pattern REGEX_METADATA_LITERAL = Pattern.compile("^\\s*(.*)");
    private static final Pattern REGEX_BEGIN = Pattern.compile("^-{3}(\\s.*)?");
    private static final Pattern REGEX_END = Pattern.compile("^(-{3}|\\.{3})(\\s.*)?");
    private boolean inYAMLBlock = true;
    private boolean inLiteral = false;
    private String currentKey = null;
    private List<String> currentValues = new ArrayList<String>();
    private YamlFrontMatterBlock block = new YamlFrontMatterBlock();

    public Block getBlock() {
        return this.block;
    }

    public void addLine(ParserState state, BasedSequence line) {
    }

    public void closeBlock(ParserState state) {
        this.block.setCharsFromContent();
    }

    public BlockContinue tryContinue(ParserState state) {
        BasedSequence line = state.getLine();
        if (this.inYAMLBlock) {
            if (REGEX_END.matcher((CharSequence)line).matches()) {
                if (this.currentKey != null) {
                    this.block.appendChild((Node)new YamlFrontMatterNode(this.currentKey, this.currentValues));
                }
                return BlockContinue.finished();
            }
            Matcher matcher = REGEX_METADATA.matcher((CharSequence)line);
            if (matcher.matches()) {
                if (this.currentKey != null) {
                    this.block.appendChild((Node)new YamlFrontMatterNode(this.currentKey, this.currentValues));
                }
                this.inLiteral = false;
                this.currentKey = matcher.group(1);
                this.currentValues = new ArrayList<String>();
                if ("|".equals(matcher.group(2))) {
                    this.inLiteral = true;
                } else if (!"".equals(matcher.group(2))) {
                    this.currentValues.add(matcher.group(2));
                }
                return BlockContinue.atIndex((int)state.getIndex());
            }
            if (this.inLiteral) {
                matcher = REGEX_METADATA_LITERAL.matcher((CharSequence)line);
                if (matcher.matches()) {
                    if (this.currentValues.size() == 1) {
                        this.currentValues.set(0, this.currentValues.get(0) + "\n" + matcher.group(1).trim());
                    } else {
                        this.currentValues.add(matcher.group(1).trim());
                    }
                }
            } else {
                matcher = REGEX_METADATA_LIST.matcher((CharSequence)line);
                if (matcher.matches()) {
                    this.currentValues.add(matcher.group(1));
                }
            }
            return BlockContinue.atIndex((int)state.getIndex());
        }
        if (REGEX_BEGIN.matcher((CharSequence)line).matches()) {
            this.inYAMLBlock = true;
            return BlockContinue.atIndex((int)state.getIndex());
        }
        return BlockContinue.none();
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private BlockFactory(DataHolder options) {
            super(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BasedSequence line = state.getLine();
            BlockParser parentParser = matchedBlockParser.getMatchedBlockParser();
            if (parentParser instanceof DocumentBlockParser && parentParser.getBlock().getFirstChild() == null && REGEX_BEGIN.matcher((CharSequence)line).matches()) {
                return BlockStart.of((BlockParser[])new BlockParser[]{new YamlFrontMatterBlockParser()}).atIndex(state.getNextNonSpaceIndex());
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

