/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink;

import com.vladsch.flexmark.ast.CustomNode;
import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class WikiNode
extends CustomNode
implements DoNotDecorate {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence link = BasedSequence.NULL;
    protected BasedSequence pageRef = BasedSequence.NULL;
    protected BasedSequence anchorMarker = BasedSequence.NULL;
    protected BasedSequence anchorRef = BasedSequence.NULL;
    protected BasedSequence textSeparatorMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence closingMarker = BasedSequence.NULL;
    protected final boolean linkIsFirst;

    public BasedSequence[] getSegments() {
        if (this.linkIsFirst) {
            return new BasedSequence[]{this.openingMarker, this.link, this.pageRef, this.anchorMarker, this.anchorRef, this.textSeparatorMarker, this.text, this.closingMarker};
        }
        return new BasedSequence[]{this.openingMarker, this.text, this.textSeparatorMarker, this.link, this.pageRef, this.anchorMarker, this.anchorRef, this.closingMarker};
    }

    public void getAstExtra(StringBuilder out) {
        if (this.linkIsFirst) {
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (String)"linkOpen");
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.text, (String)"text");
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.textSeparatorMarker, (String)"textSep");
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.link, (String)"link");
            if (this.pageRef.isNotNull()) {
                WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.pageRef, (String)"pageRef");
            }
            if (this.anchorMarker.isNotNull()) {
                WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorMarker, (String)"anchorMarker");
            }
            if (this.anchorRef.isNotNull()) {
                WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorRef, (String)"anchorRef");
            }
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.closingMarker, (String)"linkClose");
        } else {
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (String)"linkOpen");
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.link, (String)"link");
            if (this.pageRef.isNotNull()) {
                WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.pageRef, (String)"pageRef");
            }
            if (this.anchorMarker.isNotNull()) {
                WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorMarker, (String)"anchorMarker");
            }
            if (this.anchorRef.isNotNull()) {
                WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.anchorRef, (String)"anchorRef");
            }
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.textSeparatorMarker, (String)"textSep");
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.text, (String)"text");
            WikiNode.segmentSpanChars((StringBuilder)out, (BasedSequence)this.closingMarker, (String)"linkClose");
        }
    }

    public boolean isLinkIsFirst() {
        return this.linkIsFirst;
    }

    public WikiNode(boolean linkIsFirst) {
        this.linkIsFirst = linkIsFirst;
    }

    public WikiNode(BasedSequence chars, boolean linkIsFirst) {
        super(chars);
        this.linkIsFirst = linkIsFirst;
        this.setLinkChars(chars);
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getPageRef() {
        return this.pageRef;
    }

    public void setPageRef(BasedSequence pageRef) {
        this.pageRef = pageRef;
    }

    public BasedSequence getTextSeparatorMarker() {
        return this.textSeparatorMarker;
    }

    public void setTextSeparatorMarker(BasedSequence textSeparatorMarker) {
        this.textSeparatorMarker = textSeparatorMarker;
    }

    public BasedSequence getText() {
        return this.text;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public BasedSequence getAnchorMarker() {
        return this.anchorMarker;
    }

    public void setAnchorMarker(BasedSequence anchorMarker) {
        this.anchorMarker = anchorMarker;
    }

    public BasedSequence getAnchorRef() {
        return this.anchorRef;
    }

    public void setAnchorRef(BasedSequence anchorRef) {
        this.anchorRef = anchorRef;
    }

    public BasedSequence getLink() {
        return this.link;
    }

    public void setLink(BasedSequence link) {
        this.link = link;
        if (this instanceof WikiImage) {
            this.pageRef = link;
        } else {
            int pos = link.indexOf('#');
            if (pos < 0) {
                this.pageRef = link;
            } else {
                this.pageRef = link.subSequence(0, pos);
                this.anchorMarker = link.subSequence(pos, pos + 1);
                this.anchorRef = link.subSequence(pos + 1);
            }
        }
    }

    public void setLinkChars(BasedSequence linkChars) {
        BasedSequence link;
        int pos;
        int length = linkChars.length();
        int start = this instanceof WikiImage ? 3 : 2;
        this.openingMarker = linkChars.subSequence(0, start);
        this.closingMarker = linkChars.subSequence(length - 2, length);
        int n = pos = this.linkIsFirst ? linkChars.lastIndexOf('|') : linkChars.indexOf('|');
        if (pos < 0) {
            link = linkChars.subSequence(start, length - 2);
        } else {
            this.textSeparatorMarker = linkChars.subSequence(pos, pos + 1);
            if (this.linkIsFirst) {
                link = linkChars.subSequence(start, pos);
                this.text = linkChars.subSequence(pos + 1, length - 2);
            } else {
                this.text = linkChars.subSequence(start, pos);
                link = linkChars.subSequence(pos + 1, length - 2);
            }
        }
        this.setLink(link);
    }
}

