/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.internal.TableParserOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TableNodeRenderer
implements NodeRenderer {
    private final TableParserOptions options;

    public TableNodeRenderer(DataHolder options) {
        this.options = new TableParserOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(TableBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<TableBlock>(){

            public void render(TableBlock node, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableHead.class, (CustomNodeRenderer)new CustomNodeRenderer<TableHead>(){

            public void render(TableHead node, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableSeparator.class, (CustomNodeRenderer)new CustomNodeRenderer<TableSeparator>(){

            public void render(TableSeparator node, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableBody.class, (CustomNodeRenderer)new CustomNodeRenderer<TableBody>(){

            public void render(TableBody node, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableRow.class, (CustomNodeRenderer)new CustomNodeRenderer<TableRow>(){

            public void render(TableRow node, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(TableCell.class, (CustomNodeRenderer)new CustomNodeRenderer<TableCell>(){

            public void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
                TableNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(final TableBlock node, final NodeRendererContext context, HtmlWriter html) {
        if (!this.options.className.isEmpty()) {
            html.attr("class", this.options.className);
        }
        html.srcPosWithEOL(node.getChars()).withAttr().tagIndent("table", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)node);
            }
        });
    }

    private void render(final TableHead node, final NodeRendererContext context, HtmlWriter html) {
        html.withAttr().withCondLine().tagIndent("thead", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)node);
            }
        });
    }

    private void render(TableSeparator tableSeparator, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(final TableBody node, final NodeRendererContext context, HtmlWriter html) {
        html.withAttr().withCondLine().tagIndent("tbody", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)node);
            }
        });
    }

    private void render(final TableRow node, final NodeRendererContext context, HtmlWriter html) {
        html.srcPos(node.getChars()).withAttr().tagLine("tr", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)node);
            }
        });
    }

    private void render(TableCell node, NodeRendererContext context, HtmlWriter html) {
        String tag;
        String string = tag = node.isHeader() ? "th" : "td";
        if (node.getAlignment() != null) {
            html.attr("align", TableNodeRenderer.getAlignValue(node.getAlignment()));
        }
        if (this.options.columnSpans && node.getSpan() > 1) {
            html.attr("colspan", String.valueOf(node.getSpan()));
        }
        html.srcPos(node.getText()).withAttr().tag(tag);
        context.renderChildren((Node)node);
        html.tag("/" + tag);
    }

    private static String getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case CENTER: {
                return "center";
            }
            case RIGHT: {
                return "right";
            }
        }
        throw new IllegalStateException("Unknown alignment: " + (Object)((Object)alignment));
    }
}

