/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.spec.example.internal;

import com.vladsch.flexmark.ext.spec.example.SpecExampleAst;
import com.vladsch.flexmark.ext.spec.example.SpecExampleBlock;
import com.vladsch.flexmark.ext.spec.example.SpecExampleHtml;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOption;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleOptionsList;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSeparator;
import com.vladsch.flexmark.ext.spec.example.SpecExampleSource;
import com.vladsch.flexmark.ext.spec.example.internal.SpecExampleOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.DelimitedBuilder;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SpecExampleNodeRenderer
implements NodeRenderer {
    private static String fromChars = " +/<>";
    private static String toChars = "-----";
    private final SpecExampleOptions options;

    public SpecExampleNodeRenderer(DataHolder options) {
        this.options = new SpecExampleOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(SpecExampleBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleBlock>(){

            public void render(SpecExampleBlock node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleOptionsList.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleOptionsList>(){

            public void render(SpecExampleOptionsList node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleOption.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleOption>(){

            public void render(SpecExampleOption node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleOptionSeparator.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleOptionSeparator>(){

            public void render(SpecExampleOptionSeparator node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleSeparator.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleSeparator>(){

            public void render(SpecExampleSeparator node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleSource.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleSource>(){

            public void render(SpecExampleSource node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleHtml.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleHtml>(){

            public void render(SpecExampleHtml node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler(SpecExampleAst.class, (CustomNodeRenderer)new CustomNodeRenderer<SpecExampleAst>(){

            public void render(SpecExampleAst node, NodeRendererContext context, HtmlWriter html) {
                SpecExampleNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(SpecExampleOptionsList node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SpecExampleOption node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SpecExampleOptionSeparator node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(SpecExampleSeparator node, NodeRendererContext context, HtmlWriter html) {
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                break;
            }
            case SECTIONS: {
                break;
            }
        }
    }

    private void render(SpecExampleSource node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence text = node.getChars();
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.tag((CharSequence)"dt")).text((CharSequence)"Source")).tag((CharSequence)"/dt")).line();
                html.tag((CharSequence)"dd");
                this.render(text, "markdown", context, html);
                ((HtmlWriter)html.tag((CharSequence)"/dd")).line();
                break;
            }
            case SECTIONS: {
                if (text.isEmpty()) break;
                html.tagVoidLine((CharSequence)"hr");
                this.render(text, "markdown", context, html);
                break;
            }
        }
    }

    private void render(SpecExampleHtml node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence text = node.getChars();
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.tag((CharSequence)"dt")).text((CharSequence)"Html")).tag((CharSequence)"/dt")).line();
                html.tag((CharSequence)"dd");
                this.render(text, "html", context, html);
                ((HtmlWriter)html.tag((CharSequence)"/dd")).line();
                if (!this.options.renderHtml) break;
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.tag((CharSequence)"dt")).text((CharSequence)"Rendered Html")).tag((CharSequence)"/dt")).line();
                html.tag((CharSequence)"dd");
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw((CharSequence)this.options.renderedHtmlPrefix)).rawIndentedPre((CharSequence)text.normalizeEOL())).raw((CharSequence)this.options.renderedHtmlSuffix)).line();
                ((HtmlWriter)html.tag((CharSequence)"/dd")).line();
                break;
            }
            case SECTIONS: {
                if (text.isEmpty()) break;
                html.tagVoidLine((CharSequence)"hr");
                this.render(text, "html", context, html);
                if (!this.options.renderHtml) break;
                html.tagVoidLine((CharSequence)"hr");
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw((CharSequence)this.options.renderedHtmlPrefix)).rawIndentedPre((CharSequence)text.normalizeEOL())).raw((CharSequence)this.options.renderedHtmlSuffix)).line();
                break;
            }
        }
    }

    private void render(SpecExampleAst node, NodeRendererContext context, HtmlWriter html) {
        BasedSequence text = node.getChars();
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.tag((CharSequence)"dt")).text((CharSequence)"AST")).tag((CharSequence)"/dt")).line();
                html.tag((CharSequence)"dd");
                this.render(text, "text", context, html);
                ((HtmlWriter)html.tag((CharSequence)"/dd")).line();
                break;
            }
            case SECTIONS: {
                if (text.isEmpty()) break;
                html.tagVoidLine((CharSequence)"hr");
                this.render(text, "text", context, html);
                break;
            }
        }
    }

    private void render(SpecExampleBlock node, NodeRendererContext context, HtmlWriter html) {
        switch (this.options.renderAs) {
            case DEFINITION_LIST: {
                html.tagVoidLine((CharSequence)"hr");
                ((HtmlWriter)html.tag((CharSequence)"dl")).indent();
                ((HtmlWriter)html.tag((CharSequence)"dt")).text((CharSequence)"example");
                if (node.getSection().isNotNull() || node.getNumberSeparator().isNotNull() || node.getNumber().isNotNull()) {
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.text((CharSequence)" ")).text((CharSequence)node.getSection().toString())).text((CharSequence)": ")).text((CharSequence)node.getNumber().toString());
                }
                if (node.getOptionsKeyword().isNotNull() || node.getOptionsOpeningMarker().isNotNull() || node.getOptions().isNotNull() || node.getOptionsClosingMarker().isNotNull()) {
                    String optionsText = "";
                    BasedSequence trimmed = (BasedSequence)node.getOptions().trim((CharSequence)" \t\r\n\u00a0");
                    if (!trimmed.isEmpty()) {
                        Object[] optionsList = (BasedSequence[])trimmed.split(',', 0, 6);
                        DelimitedBuilder out = new DelimitedBuilder(", ");
                        optionsText = out.appendAll(optionsList).getAndClear();
                    }
                    ((HtmlWriter)((HtmlWriter)html.text((CharSequence)" options(")).text((CharSequence)optionsText)).text((CharSequence)")");
                }
                ((HtmlWriter)html.tag((CharSequence)"/dt")).line();
                context.renderChildren((Node)node);
                ((HtmlWriter)((HtmlWriter)html.unIndent()).tag((CharSequence)"/dl")).line();
                break;
            }
            case SECTIONS: {
                html.tagVoidLine((CharSequence)"hr");
                if (node.getSection().isNotNull() || node.getNumberSeparator().isNotNull() || node.getNumber().isNotNull()) {
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.tag((CharSequence)"h5")).text((CharSequence)node.getSection().toString())).text((CharSequence)": ")).text((CharSequence)node.getNumber().toString())).tag((CharSequence)"/h5")).line();
                }
                context.renderChildren((Node)node);
                break;
            }
            default: {
                this.render(node.getContentChars(), "text", context, html);
            }
        }
    }

    private void render(BasedSequence contentChars, String language, NodeRendererContext context, HtmlWriter html) {
        String text = contentChars.normalizeEOL();
        if (!text.isEmpty()) {
            if (!language.isEmpty()) {
                html.attr((CharSequence)"class", (CharSequence)(context.getHtmlOptions().languageClassPrefix + language));
            }
            html.line();
            ((HtmlWriter)html.tag((CharSequence)"pre")).openPre();
            html.srcPos(contentChars).withAttr().tag((CharSequence)"code");
            html.text((CharSequence)text);
            html.tag((CharSequence)"/code");
            ((HtmlWriter)html.tag((CharSequence)"/pre")).closePre();
            html.line();
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer apply(DataHolder options) {
            return new SpecExampleNodeRenderer(options);
        }
    }
}

