/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.users.internal;

import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.gfm.users.GfmUser;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Pattern;

public class GfmUsersInlineParserExtension
implements InlineParserExtension {
    public static final Pattern GITHUB_USER = Pattern.compile("^(@)([a-z\\d](?:[a-z\\d]|-(?=[a-z\\d])){0,38})(?=[ \\t]+|\\n|$)", 2);

    public GfmUsersInlineParserExtension(InlineParser inlineParser) {
    }

    public void finalizeDocument(InlineParser inlineParser) {
    }

    public void finalizeBlock(InlineParser inlineParser) {
    }

    public boolean parse(InlineParser inlineParser) {
        BasedSequence[] matches = inlineParser.matchWithGroups(GITHUB_USER);
        if (matches != null) {
            BasedSequence input = inlineParser.getInput();
            inlineParser.flushTextNode();
            BasedSequence openMarker = matches[1];
            BasedSequence text = matches[2];
            GfmUser gitHubIssue = new GfmUser(openMarker, text);
            inlineParser.getBlock().appendChild((Node)gitHubIssue);
            return true;
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        public Set<Class<? extends InlineParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        public CharSequence getCharacters() {
            return "@";
        }

        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        public InlineParserExtension create(InlineParser inlineParser) {
            return new GfmUsersInlineParserExtension(inlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

