/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.EnumSet;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

public class AutolinkNodePostProcessor
extends NodePostProcessor {
    private LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.EMAIL)).build();

    public AutolinkNodePostProcessor(Document document) {
    }

    public void process(NodeTracker state, Node node) {
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape((BasedSequence)original, (ReplacedTextMapper)textMapper);
        Iterable links = this.linkExtractor.extractLinks((CharSequence)literal);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        for (LinkSpan link : links) {
            MailLink linkNode;
            BasedSequence linkText = literal.subSequence(link.getBeginIndex(), link.getEndIndex());
            int startOffset = textMapper.originalOffset(link.getBeginIndex());
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore((Node)textBase);
                state.nodeAdded((Node)textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            Text contentNode = new Text(linkText);
            if (link.getType() == LinkType.EMAIL) {
                linkNode = new MailLink();
                linkNode.setText(linkText);
            } else {
                linkNode = new AutoLink();
                ((AutoLink)linkNode).setText(linkText);
            }
            linkNode.setCharsFromContent();
            linkNode.appendChild((Node)contentNode);
            textBase.appendChild((Node)linkNode);
            state.nodeAddedWithChildren((Node)linkNode);
            lastEscaped = textMapper.originalOffset(link.getEndIndex());
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild((Node)node1);
                state.nodeAdded((Node)node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, new Class[]{DoNotDecorate.class});
        }

        public NodePostProcessor create(Document document) {
            return new AutolinkNodePostProcessor(document);
        }
    }
}

