/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.parser.block.DocumentPostProcessor;
import com.vladsch.flexmark.parser.block.DocumentPostProcessorFactory;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.EnumSet;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

public class AutolinkPostProcessor
extends DocumentPostProcessor {
    private LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.EMAIL)).build();
    private final NodeVisitor myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Text.class, (Visitor)new Visitor<Text>(){

        public void visit(Text text) {
            AutolinkPostProcessor.this.visit(text);
        }
    })});

    public AutolinkPostProcessor(Document document) {
    }

    public Document processDocument(Document document) {
        this.myVisitor.visit((Node)document);
        return document;
    }

    private void visit(Text text) {
        if (!text.isOrDescendantOfType(new Class[]{DoNotDecorate.class})) {
            this.processTextNode(text);
        }
    }

    private void processTextNode(Text node) {
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape((BasedSequence)original, (ReplacedTextMapper)textMapper);
        Iterable links = this.linkExtractor.extractLinks((CharSequence)literal);
        Text lastNode = node;
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = null;
        for (LinkSpan link : links) {
            MailLink linkNode;
            BasedSequence linkText = literal.subSequence(link.getBeginIndex(), link.getEndIndex());
            int index = textMapper.originalOffset(link.getBeginIndex());
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore((Node)textBase);
                textBase.appendChild((Node)node);
            }
            if (index != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, index);
                Text node1 = new Text(escapedChars);
                lastNode.insertAfter((Node)node1);
                lastNode = node1;
            }
            Text contentNode = new Text(linkText);
            if (link.getType() == LinkType.EMAIL) {
                linkNode = new MailLink();
                linkNode.setText(linkText);
            } else {
                linkNode = new AutoLink();
                ((AutoLink)linkNode).setText(linkText);
            }
            linkNode.setCharsFromContent();
            linkNode.appendChild((Node)contentNode);
            lastNode.insertAfter((Node)linkNode);
            lastNode = linkNode;
            lastEscaped = textMapper.originalOffset(link.getEndIndex());
        }
        if (lastEscaped != original.length()) {
            BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
            Text node1 = new Text(escapedChars);
            lastNode.insertAfter((Node)node1);
        }
        node.unlink();
    }

    public static class Factory
    extends DocumentPostProcessorFactory {
        public DocumentPostProcessor create(Document document) {
            return new AutolinkPostProcessor(document);
        }
    }
}

