/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionCollectingVisitor;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class AdmonitionNodeRenderer
implements PhasedNodeRenderer {
    private final AdmonitionOptions options;

    public AdmonitionNodeRenderer(DataHolder options) {
        this.options = new AdmonitionOptions(options);
    }

    public Set<RenderingPhase> getRenderingPhases() {
        LinkedHashSet<RenderingPhase> phaseSet = new LinkedHashSet<RenderingPhase>();
        phaseSet.add(RenderingPhase.BODY_TOP);
        return phaseSet;
    }

    public void renderDocument(NodeRendererContext context, HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP) {
            HashSet<String> resolvedQualifiers = new HashSet<String>();
            Set<String> referencedQualifiers = new AdmonitionCollectingVisitor().collectAndGetQualifiers((Node)document);
            for (String qualifier : referencedQualifiers) {
                String resolvedQualifier = this.options.qualifierTypeMap.get(qualifier);
                if (resolvedQualifier == null) {
                    resolvedQualifier = this.options.unresolvedQualifier;
                }
                resolvedQualifiers.add(resolvedQualifier);
            }
            if (!resolvedQualifiers.isEmpty()) {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.line()).raw((CharSequence)"<svg xmlns=http://www.w3.org/2000/svg class=\"adm-hidden\">")).indent()).line();
                for (String info : resolvedQualifiers) {
                    String svgContent = this.options.typeSvgMap.get(info);
                    if (svgContent == null || svgContent.isEmpty()) continue;
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"<symbol id=\"adm-")).raw((CharSequence)info)).raw((CharSequence)"\">")).indent()).line()).raw((CharSequence)"<svg enable-background=\"new 0 0 24 24\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\">")).raw((CharSequence)svgContent)).line()).unIndent()).raw((CharSequence)"</symbol>")).line();
                }
                ((HtmlWriter)((HtmlWriter)html.unIndent()).raw((CharSequence)"</svg>")).line();
            }
        }
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(AdmonitionBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<AdmonitionBlock>(){

            public void render(AdmonitionBlock node, NodeRendererContext context, HtmlWriter html) {
                AdmonitionNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(AdmonitionBlock node, NodeRendererContext context, HtmlWriter html) {
        String title;
        String info = node.getInfo().toString().toLowerCase();
        String type = this.options.qualifierTypeMap.get(info);
        if (type == null) {
            type = this.options.unresolvedQualifier;
        }
        if (node.getTitle().isNull()) {
            title = this.options.qualifierTitleMap.get(info);
            if (title == null) {
                title = info.substring(0, 1).toUpperCase() + info.substring(1);
            }
        } else {
            title = node.getTitle().toString();
        }
        String openClose = node.getOpeningMarker().equals("???") ? " adm-collapsed" : (node.getOpeningMarker().equals("???+") ? "adm-open" : null);
        Attributes attributes = new Attributes();
        attributes.addValue((CharSequence)"class", (CharSequence)"adm-block");
        attributes.addValue((CharSequence)"class", (CharSequence)("adm-" + type));
        if (title.isEmpty()) {
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).attr(attributes)).withAttr().tag((CharSequence)"div", false).line()).raw((CharSequence)"<div class=\"adm-body\">")).indent()).line();
            context.renderChildren((Node)node);
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.unIndent()).raw((CharSequence)"</div>")).line()).closeTag((CharSequence)"div")).line();
        } else {
            if (openClose != null) {
                attributes.addValue((CharSequence)"class", (CharSequence)openClose);
            }
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).attr(attributes)).withAttr().tag((CharSequence)"div", false).line()).raw((CharSequence)"<div class=\"adm-heading\">")).line()).raw((CharSequence)"<svg class=\"adm-icon\"><use xlink:href=\"#adm-")).raw((CharSequence)type)).raw((CharSequence)"\" /></svg><span>")).text((CharSequence)title)).raw((CharSequence)"</span>")).line()).raw((CharSequence)"</div>")).line()).raw((CharSequence)"<div class=\"adm-body\">")).indent()).line();
            context.renderChildren((Node)node);
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.unIndent()).raw((CharSequence)"</div>")).line()).raw((CharSequence)"</div>")).line()).closeTag((CharSequence)"div")).line();
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new AdmonitionNodeRenderer(options);
        }
    }
}

