/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.NodeRepository;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationNodeFormatter;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationNodePostProcessor;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationNodeRenderer;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationParagraphPreProcessor;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.formatter.internal.Formatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.PostProcessorFactory;
import com.vladsch.flexmark.util.KeepType;
import com.vladsch.flexmark.util.collection.DataValueFactory;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.DataKey;
import com.vladsch.flexmark.util.options.MutableDataHolder;

public class AbbreviationExtension
implements Parser.ParserExtension,
HtmlRenderer.HtmlRendererExtension,
Parser.ReferenceHoldingExtension,
Formatter.FormatterExtension {
    public static final DataKey<AbbreviationRepository> ABBREVIATIONS = new DataKey("ABBREVIATIONS", (DataValueFactory)new DataValueFactory<AbbreviationRepository>(){

        public AbbreviationRepository create(DataHolder options) {
            return new AbbreviationRepository(options);
        }
    });
    public static final DataKey<KeepType> ABBREVIATIONS_KEEP = new DataKey("ABBREVIATIONS_KEEP", (Object)KeepType.FIRST);
    public static final DataKey<Boolean> USE_LINKS = new DataKey("USE_LINKS", (Object)false);
    public static final DataKey<ElementPlacement> ABBREVIATIONS_PLACEMENT = new DataKey("ABBREVIATIONS_PLACEMENT", (Object)ElementPlacement.AS_IS);
    public static final DataKey<ElementPlacementSort> ABBREVIATIONS_SORT = new DataKey("ABBREVIATIONS_SORT", (Object)ElementPlacementSort.AS_IS);

    public static Extension create() {
        return new AbbreviationExtension();
    }

    public void extend(Formatter.Builder builder) {
        builder.nodeFormatterFactory((NodeFormatterFactory)new AbbreviationNodeFormatter.Factory());
    }

    public void rendererOptions(MutableDataHolder options) {
    }

    public void parserOptions(MutableDataHolder options) {
    }

    public boolean transferReferences(MutableDataHolder document, DataHolder included) {
        if (document.contains(ABBREVIATIONS) && included.contains(ABBREVIATIONS)) {
            return Parser.transferReferences((NodeRepository)((NodeRepository)ABBREVIATIONS.getFrom((DataHolder)document)), (NodeRepository)((NodeRepository)ABBREVIATIONS.getFrom(included)), (ABBREVIATIONS_KEEP.getFrom((DataHolder)document) == KeepType.FIRST ? 1 : 0) != 0);
        }
        return false;
    }

    public void extend(Parser.Builder parserBuilder) {
        parserBuilder.paragraphPreProcessorFactory(AbbreviationParagraphPreProcessor.Factory());
        parserBuilder.postProcessorFactory((PostProcessorFactory)new AbbreviationNodePostProcessor.Factory());
    }

    public void extend(HtmlRenderer.Builder rendererBuilder, String rendererType) {
        switch (rendererType) {
            case "HTML": {
                rendererBuilder.nodeRendererFactory((NodeRendererFactory)new AbbreviationNodeRenderer.Factory());
                break;
            }
        }
    }
}

