/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineBase;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.docx.converter.DocxRenderer;
import com.vladsch.flexmark.docx.converter.DocxRendererContext;
import com.vladsch.flexmark.docx.converter.DocxRendererOptions;
import com.vladsch.flexmark.docx.converter.DocxRendererPhase;
import com.vladsch.flexmark.docx.converter.NodeDocxRendererHandler;
import com.vladsch.flexmark.docx.converter.PhasedNodeDocxRenderer;
import com.vladsch.flexmark.docx.converter.util.AttributeBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.AttributeFormat;
import com.vladsch.flexmark.docx.converter.util.AttributeRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.BinaryPartAbstractImage;
import com.vladsch.flexmark.docx.converter.util.BlockFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.BoldRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ContentContainer;
import com.vladsch.flexmark.docx.converter.util.FootnoteBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.FootnoteRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.HeadingBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.IsolatingBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ItalicRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ListItemBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ParaContainer;
import com.vladsch.flexmark.docx.converter.util.QuotedFormatProvider;
import com.vladsch.flexmark.docx.converter.util.RunContainer;
import com.vladsch.flexmark.docx.converter.util.RunFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.SourceCodeRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.StrikethroughRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.SubscriptRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.SuperscriptRunFormatProvider;
import com.vladsch.flexmark.docx.converter.util.UnderlineRunFormatProvider;
import com.vladsch.flexmark.ext.aside.AsideBlock;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.emoji.Emoji;
import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.emoji.EmojiImageType;
import com.vladsch.flexmark.ext.emoji.EmojiShortcutType;
import com.vladsch.flexmark.ext.emoji.internal.EmojiOptions;
import com.vladsch.flexmark.ext.emoji.internal.EmojiResolvedShortcut;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedOrdinalRenderer;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceBlock;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceExtension;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceLink;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRendering;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceRepository;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferenceText;
import com.vladsch.flexmark.ext.enumerated.reference.EnumeratedReferences;
import com.vladsch.flexmark.ext.enumerated.reference.internal.EnumRefTextCollectingVisitor;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.ext.gitlab.GitLabBlockQuote;
import com.vladsch.flexmark.ext.gitlab.GitLabDel;
import com.vladsch.flexmark.ext.gitlab.GitLabIns;
import com.vladsch.flexmark.ext.ins.Ins;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTag;
import com.vladsch.flexmark.ext.jekyll.tag.JekyllTagBlock;
import com.vladsch.flexmark.ext.macros.MacroDefinitionBlock;
import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.superscript.Superscript;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.toc.SimTocBlock;
import com.vladsch.flexmark.ext.toc.TocBlock;
import com.vladsch.flexmark.ext.toc.TocBlockBase;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.HeaderIdGenerator;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedContent;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NonRenderingInline;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableScopedDataSet;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.misc.ImageUtils;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.sharedtypes.STOnOff;
import org.docx4j.toc.TocException;
import org.docx4j.toc.TocGenerator;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.CTFFCheckBox;
import org.docx4j.wml.CTFFDDList;
import org.docx4j.wml.CTFFData;
import org.docx4j.wml.CTFFHelpText;
import org.docx4j.wml.CTFFName;
import org.docx4j.wml.CTFFStatusText;
import org.docx4j.wml.CTFFTextInput;
import org.docx4j.wml.CTFFTextType;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.CTSignedHpsMeasure;
import org.docx4j.wml.CTTblCellMar;
import org.docx4j.wml.CTTblLook;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STFFTextType;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.STInfoTextType;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.jetbrains.annotations.NotNull;

public class CoreNodeDocxRenderer
implements PhasedNodeDocxRenderer {
    public static final DataKey<Integer> LIST_ITEM_NUMBER = new DataKey("LIST_ITEM_NUMBER", (Object)0);
    public static final NullableDataKey<ListSpacing> LIST_ITEM_SPACING = new NullableDataKey("LIST_ITEM_SPACING");
    public static final HashSet<DocxRendererPhase> RENDERING_PHASES = new HashSet<DocxRendererPhase>(Arrays.asList(DocxRendererPhase.COLLECT, DocxRendererPhase.DOCUMENT_TOP, DocxRendererPhase.DOCUMENT_BOTTOM));
    public static final String INPUT_TYPE_DROPDOWN = "dropdown";
    public static final String INPUT_TYPE_CHECKBOX = "checkbox";
    public static final String INPUT_TYPE_TEXT = "text";
    public static final String INPUT_CLASS_TEXT = "text";
    public static final String INPUT_CLASS_DROPDOWN = "dropdown";
    public static final String INPUT_CLASS_CHECKBOX = "checkbox";
    protected final ReferenceRepository referenceRepository;
    DocxRendererOptions options;
    final EmojiOptions emojiOptions;
    private final ListOptions listOptions;
    protected boolean recheckUndefinedReferences;
    protected boolean repositoryNodesDone;
    protected final boolean linebreakOnInlineHtmlBr;
    protected final boolean tableCaptionToParagraph;
    protected final boolean tableCaptionBeforeTable;
    protected final int tablePreferredWidthPct;
    protected final int tableLeftIndent;
    protected final String tableStyle;
    private int imageId;
    private final HashMap<Node, BigInteger> footnoteIDs;
    private TocBlockBase lastTocBlock;
    private long[] numberedLists = new long[128];
    private long[] bulletLists = new long[128];
    private EnumeratedReferences enumeratedOrdinals;
    Runnable ordinalRunnable;
    private final HtmlIdGenerator headerIdGenerator;
    private final HashMap<String, Integer> formControlCounts = new HashMap();
    private final FootnoteRepository footnoteRepository;
    private Tbl myTbl;
    private Tr myTr;

    private void ensureNumberedListLength(int level) {
        if (this.numberedLists.length < level) {
            long[] newList = new long[(level / 128 + 1) * 128];
            System.arraycopy(this.numberedLists, 0, newList, 0, this.numberedLists.length);
            this.numberedLists = newList;
        }
    }

    private void ensureBulletListLength(int level) {
        if (this.bulletLists.length < level) {
            long[] newList = new long[(level / 128 + 1) * 128];
            System.arraycopy(this.bulletLists, 0, newList, 0, this.bulletLists.length);
            this.bulletLists = newList;
        }
    }

    public CoreNodeDocxRenderer(DataHolder options) {
        this.referenceRepository = this.getRepository(options);
        this.recheckUndefinedReferences = (Boolean)DocxRenderer.RECHECK_UNDEFINED_REFERENCES.get(options);
        this.linebreakOnInlineHtmlBr = (Boolean)DocxRenderer.LINEBREAK_ON_INLINE_HTML_BR.get(options);
        this.tableCaptionToParagraph = (Boolean)DocxRenderer.TABLE_CAPTION_TO_PARAGRAPH.get(options);
        this.tableCaptionBeforeTable = (Boolean)DocxRenderer.TABLE_CAPTION_BEFORE_TABLE.get(options);
        this.tablePreferredWidthPct = (Integer)DocxRenderer.TABLE_PREFERRED_WIDTH_PCT.get(options);
        this.tableLeftIndent = (Integer)DocxRenderer.TABLE_LEFT_INDENT.get(options);
        this.tableStyle = (String)DocxRenderer.TABLE_STYLE.get(options);
        this.repositoryNodesDone = false;
        this.footnoteRepository = (FootnoteRepository)FootnoteExtension.FOOTNOTES.get(options);
        this.footnoteRepository.resolveFootnoteOrdinals();
        this.options = new DocxRendererOptions(options);
        this.listOptions = ListOptions.get((DataHolder)options);
        this.footnoteIDs = new HashMap();
        this.lastTocBlock = null;
        this.ordinalRunnable = null;
        MutableScopedDataSet options1 = new MutableScopedDataSet(options);
        options1.set(EmojiExtension.ROOT_IMAGE_PATH, (Object)((String)DocxRenderer.DOC_EMOJI_ROOT_IMAGE_PATH.get(options)));
        this.emojiOptions = new EmojiOptions((DataHolder)options1);
        this.headerIdGenerator = new HeaderIdGenerator.Factory().create();
        this.imageId = 100000;
    }

    @Override
    public Set<DocxRendererPhase> getFormattingPhases() {
        return RENDERING_PHASES;
    }

    @Override
    public void renderDocument(DocxRendererContext docx, Document document, DocxRendererPhase phase) {
        switch (phase) {
            case COLLECT: {
                this.options = docx.getDocxRendererOptions();
                this.headerIdGenerator.generateIds(document);
                break;
            }
            case DOCUMENT_TOP: {
                this.enumeratedOrdinals = (EnumeratedReferences)EnumeratedReferenceExtension.ENUMERATED_REFERENCE_ORDINALS.get((DataHolder)document);
                FootnoteRepository.resolveFootnotes((Document)document);
                break;
            }
            case DOCUMENT_BOTTOM: {
                if (!this.options.tocGenerate && this.lastTocBlock == null) break;
                TocGenerator tocGenerator = null;
                try {
                    tocGenerator = new TocGenerator(docx.getPackage());
                    tocGenerator.setStartingIdForNewBookmarks(docx.getBookmarkIdAtomic());
                    tocGenerator.generateToc(0, this.options.tocInstruction, true);
                }
                catch (TocException e) {
                    if (tocGenerator != null && e.getMessage().contains("use updateToc instead")) {
                        try {
                            tocGenerator.updateToc(true);
                        }
                        catch (TocException e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Override
    public Set<Class<?>> getBookmarkWrapsChildrenClasses() {
        return null;
    }

    public ReferenceRepository getRepository(DataHolder options) {
        return (ReferenceRepository)Parser.REFERENCES.get(options);
    }

    @Override
    public Set<NodeDocxRendererHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeDocxRendererHandler<Node>(Node.class, this::render), new NodeDocxRendererHandler<AsideBlock>(AsideBlock.class, this::render), new NodeDocxRendererHandler<AttributeNode>(AttributeNode.class, this::render), new NodeDocxRendererHandler<AttributesNode>(AttributesNode.class, this::render), new NodeDocxRendererHandler<AutoLink>(AutoLink.class, this::render), new NodeDocxRendererHandler<BlankLine>(BlankLine.class, this::render), new NodeDocxRendererHandler<BlockQuote>(BlockQuote.class, this::render), new NodeDocxRendererHandler<BulletList>(BulletList.class, this::render), new NodeDocxRendererHandler<BulletListItem>(BulletListItem.class, this::render), new NodeDocxRendererHandler<Code>(Code.class, this::render), new NodeDocxRendererHandler<Document>(Document.class, this::render), new NodeDocxRendererHandler<Emoji>(Emoji.class, this::render), new NodeDocxRendererHandler<Emphasis>(Emphasis.class, this::render), new NodeDocxRendererHandler<EnumeratedReferenceBlock>(EnumeratedReferenceBlock.class, this::render), new NodeDocxRendererHandler<EnumeratedReferenceLink>(EnumeratedReferenceLink.class, this::render), new NodeDocxRendererHandler<EnumeratedReferenceText>(EnumeratedReferenceText.class, this::render), new NodeDocxRendererHandler<FencedCodeBlock>(FencedCodeBlock.class, this::render), new NodeDocxRendererHandler<Footnote>(Footnote.class, this::render), new NodeDocxRendererHandler<FootnoteBlock>(FootnoteBlock.class, this::render), new NodeDocxRendererHandler<GitLabBlockQuote>(GitLabBlockQuote.class, this::render), new NodeDocxRendererHandler<GitLabDel>(GitLabDel.class, this::render), new NodeDocxRendererHandler<GitLabIns>(GitLabIns.class, this::render), new NodeDocxRendererHandler<HardLineBreak>(HardLineBreak.class, this::render), new NodeDocxRendererHandler<Heading>(Heading.class, this::render), new NodeDocxRendererHandler<HtmlBlock>(HtmlBlock.class, this::render), new NodeDocxRendererHandler<HtmlCommentBlock>(HtmlCommentBlock.class, this::render), new NodeDocxRendererHandler<HtmlEntity>(HtmlEntity.class, this::render), new NodeDocxRendererHandler<HtmlInline>(HtmlInline.class, this::render), new NodeDocxRendererHandler<HtmlInlineComment>(HtmlInlineComment.class, this::render), new NodeDocxRendererHandler<HtmlInnerBlock>(HtmlInnerBlock.class, this::render), new NodeDocxRendererHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, this::render), new NodeDocxRendererHandler<Image>(Image.class, this::render), new NodeDocxRendererHandler<ImageRef>(ImageRef.class, this::render), new NodeDocxRendererHandler<IndentedCodeBlock>(IndentedCodeBlock.class, this::render), new NodeDocxRendererHandler<Ins>(Ins.class, this::render), new NodeDocxRendererHandler<JekyllTag>(JekyllTag.class, this::render), new NodeDocxRendererHandler<JekyllTagBlock>(JekyllTagBlock.class, this::render), new NodeDocxRendererHandler<Link>(Link.class, this::render), new NodeDocxRendererHandler<LinkRef>(LinkRef.class, this::render), new NodeDocxRendererHandler<MacroDefinitionBlock>(MacroDefinitionBlock.class, this::render), new NodeDocxRendererHandler<MacroReference>(MacroReference.class, this::render), new NodeDocxRendererHandler<MailLink>(MailLink.class, this::render), new NodeDocxRendererHandler<OrderedList>(OrderedList.class, this::render), new NodeDocxRendererHandler<OrderedListItem>(OrderedListItem.class, this::render), new NodeDocxRendererHandler<Paragraph>(Paragraph.class, this::render), new NodeDocxRendererHandler<Reference>(Reference.class, this::render), new NodeDocxRendererHandler<SimTocBlock>(SimTocBlock.class, this::render), new NodeDocxRendererHandler<SoftLineBreak>(SoftLineBreak.class, this::render), new NodeDocxRendererHandler<Strikethrough>(Strikethrough.class, this::render), new NodeDocxRendererHandler<StrongEmphasis>(StrongEmphasis.class, this::render), new NodeDocxRendererHandler<StrongEmphasis>(StrongEmphasis.class, this::render), new NodeDocxRendererHandler<Subscript>(Subscript.class, this::render), new NodeDocxRendererHandler<Superscript>(Superscript.class, this::render), new NodeDocxRendererHandler<TableBlock>(TableBlock.class, this::render), new NodeDocxRendererHandler<TableBody>(TableBody.class, this::render), new NodeDocxRendererHandler<TableCaption>(TableCaption.class, this::render), new NodeDocxRendererHandler<TableCell>(TableCell.class, this::render), new NodeDocxRendererHandler<TableHead>(TableHead.class, this::render), new NodeDocxRendererHandler<TableRow>(TableRow.class, this::render), new NodeDocxRendererHandler<TableSeparator>(TableSeparator.class, this::render), new NodeDocxRendererHandler<Text>(Text.class, this::render), new NodeDocxRendererHandler<TextBase>(TextBase.class, this::render), new NodeDocxRendererHandler<ThematicBreak>(ThematicBreak.class, this::render), new NodeDocxRendererHandler<TocBlock>(TocBlock.class, this::render)));
    }

    private void render(Node node, DocxRendererContext docx) {
        BasedSequence chars = node.getChars();
        MainDocumentPart mdp = docx.getDocxDocument();
        if (node instanceof Block) {
            docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().LOOSE_PARAGRAPH_STYLE));
            docx.createP();
            docx.renderChildren(node);
        } else {
            docx.addTextCreateR(chars.unescape());
        }
    }

    private void render(BlankLine node, DocxRendererContext docx) {
    }

    private void render(Document node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private boolean hasRenderingAttribute(Node node) {
        boolean pageBreak = false;
        for (Node child : node.getChildren()) {
            if (!(child instanceof AttributesNode)) continue;
            AttributesNode attributesNode = (AttributesNode)child;
            for (Node attribute : attributesNode.getChildren()) {
                AttributeNode attributeNode;
                if (!(attribute instanceof AttributeNode) || !(attributeNode = (AttributeNode)attribute).isClass()) continue;
                switch (attributeNode.getValue().toString()) {
                    case "pagebreak": 
                    case "tab": {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void render(Paragraph node, DocxRendererContext docx) {
        if (node.getParent() instanceof EnumeratedReferenceBlock) {
            this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
            docx.renderChildren((Node)node);
        } else if (!(node.getParent() instanceof ParagraphItemContainer) || !((ParagraphItemContainer)node.getParent()).isItemParagraph(node)) {
            if (node.getParent() instanceof BlockQuote || node.getParent() instanceof AsideBlock) {
                this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, true);
                docx.renderChildren((Node)node);
            } else if (node.getFirstChildAnyNot(new Class[]{NonRenderingInline.class}) != null || this.hasRenderingAttribute((Node)node)) {
                docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().LOOSE_PARAGRAPH_STYLE));
                this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, true);
                docx.renderChildren((Node)node);
            }
        } else {
            this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, !(node.getParent() instanceof FootnoteBlock));
            docx.renderChildren((Node)node);
        }
    }

    private void render(Text node, DocxRendererContext docx) {
        this.addRunAttributeFormatting((Node)node, docx);
        docx.addTextCreateR(node.getChars().unescape());
    }

    private void render(TextBase node, DocxRendererContext docx) {
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void addRunAttributeFormatting(Node node, DocxRendererContext docx) {
        Pair<String, AttributeFormat> format = this.getAttributeFormat(node, AttributablePart.NODE, docx);
        this.addRunAttributeFormatting((AttributeFormat)format.getSecond(), docx);
    }

    private void addRunAttributeFormatting(AttributeFormat attributeFormat, DocxRendererContext docx) {
        if (attributeFormat != null) {
            docx.setRunFormatProvider(new AttributeRunFormatProvider<Node>(docx, attributeFormat));
        }
    }

    void addBlockAttributeFormatting(Node node, AttributablePart part, DocxRendererContext docx, boolean createP) {
        Pair<String, AttributeFormat> format = this.getAttributeFormat(node, AttributablePart.NODE, docx);
        if (format.getSecond() != null) {
            if (createP) {
                docx.setBlockFormatProvider(new AttributeBlockFormatProvider<Node>(docx, (AttributeFormat)format.getSecond()));
            }
            docx.setRunFormatProvider(new AttributeRunFormatProvider<Node>(docx, (AttributeFormat)format.getSecond()));
        }
        if (createP) {
            docx.createP((String)format.getFirst());
        }
    }

    Pair<String, AttributeFormat> getAttributeFormat(Node node, AttributablePart part, DocxRendererContext docx) {
        String[] classNames;
        MutableAttributes attributes = docx.extendRenderingNodeAttributes(node, AttributablePart.NODE, null);
        Attribute classAttribute = attributes.get((CharSequence)"class");
        String className = null;
        if (!(classAttribute == null || classAttribute.getValue().trim().isEmpty() || (classNames = classAttribute.getValue().trim().split(" "))[0].equals("pagebreak") || classNames[0].equals("tab"))) {
            className = classNames[0];
        }
        AttributeFormat attributeFormat = this.getAttributeFormat((Attributes)attributes, docx);
        return Pair.of(className, (Object)attributeFormat);
    }

    AttributeFormat getAttributeFormat(Attributes attributes, DocxRendererContext docx) {
        String fontFamily = null;
        String fontSize = null;
        String fontWeight = null;
        String fontStyle = null;
        String textColor = null;
        String fillColor = null;
        AttributeFormat attributeFormat = null;
        Attribute style = attributes.get((CharSequence)"style");
        if (style != null && !style.getValue().trim().isEmpty()) {
            String[] styleValues;
            String value = style.getValue().trim();
            block16: for (String styleValue : styleValues = value.split(";")) {
                String attrValue;
                String[] attrParts = styleValue.trim().split(":", 2);
                String attrKey = attrParts[0].trim();
                String string = attrValue = attrParts.length > 1 ? attrParts[1].trim() : null;
                if (attrKey.isEmpty() || attrValue == null || attrValue.isEmpty()) continue;
                switch (attrKey) {
                    case "color": {
                        textColor = attrValue;
                        continue block16;
                    }
                    case "background-color": {
                        fillColor = attrValue;
                        continue block16;
                    }
                    case "font-family": {
                        fontFamily = attrValue;
                        continue block16;
                    }
                    case "font-size": {
                        fontSize = attrValue;
                        continue block16;
                    }
                    case "font-weight": {
                        fontWeight = attrValue;
                        continue block16;
                    }
                    case "font-style": {
                        fontStyle = attrValue;
                        continue block16;
                    }
                }
            }
            attributeFormat = new AttributeFormat(fontFamily, fontSize, fontWeight, fontStyle, textColor, fillColor);
            if (attributeFormat.isEmpty()) {
                attributeFormat = null;
            }
        }
        return attributeFormat;
    }

    private void render(Emphasis node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new ItalicRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(StrongEmphasis node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new BoldRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(Subscript node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new SubscriptRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(Superscript node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new SuperscriptRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(Strikethrough node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new StrikethroughRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(GitLabDel node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new StrikethroughRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(Ins node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new UnderlineRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(GitLabIns node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new UnderlineRunFormatProvider<Node>(docx, this.options.noCharacterStyles));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(Code node, DocxRendererContext docx) {
        docx.setRunFormatProvider(new SourceCodeRunFormatProvider<Node>(docx, this.options.noCharacterStyles, this.options.codeHighlightShading));
        this.addRunAttributeFormatting((Node)node, docx);
        docx.renderChildren((Node)node);
    }

    private void render(Heading node, DocxRendererContext docx) {
        docx.setBlockFormatProvider(new HeadingBlockFormatProvider<Node>(docx, node.getLevel() - 1));
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderChildren((Node)node);
    }

    private void render(BlockQuote node, DocxRendererContext docx) {
        int level = node.countDirectAncestorsOfType(null, new Class[]{BlockQuote.class}) + 1;
        docx.setBlockFormatProvider(new QuotedFormatProvider<Node>(docx, level, docx.getRenderingOptions().BLOCK_QUOTE_STYLE));
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderChildren((Node)node);
    }

    private void render(GitLabBlockQuote node, DocxRendererContext docx) {
        int level = node.countDirectAncestorsOfType(null, new Class[]{BlockQuote.class}) + 1;
        docx.setBlockFormatProvider(new QuotedFormatProvider<Node>(docx, level, docx.getRenderingOptions().BLOCK_QUOTE_STYLE));
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderChildren((Node)node);
    }

    private void render(AsideBlock node, DocxRendererContext docx) {
        int level = node.countDirectAncestorsOfType(null, new Class[]{BlockQuote.class}) + 1;
        docx.setBlockFormatProvider(new QuotedFormatProvider<Node>(docx, level, docx.getRenderingOptions().ASIDE_BLOCK_STYLE));
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderChildren((Node)node);
    }

    private void render(ThematicBreak node, DocxRendererContext docx) {
        docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().HORIZONTAL_LINE_STYLE));
        docx.createP();
        docx.createR();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(MacroReference node, DocxRendererContext docx) {
        MacroDefinitionBlock macroDefinitionBlock = node.getReferenceNode(docx.getDocument());
        if (macroDefinitionBlock != null) {
            if (macroDefinitionBlock.hasChildren() && !macroDefinitionBlock.isInExpansion()) {
                try {
                    macroDefinitionBlock.setInExpansion(true);
                    Node child = macroDefinitionBlock.getFirstChild();
                    if (child instanceof Paragraph && child == macroDefinitionBlock.getLastChild()) {
                        docx.renderChildren(child);
                    }
                    docx.renderChildren((Node)macroDefinitionBlock);
                }
                finally {
                    macroDefinitionBlock.setInExpansion(false);
                }
            }
        } else {
            docx.addTextCreateR(node.getChars().unescape());
        }
    }

    private void render(MacroDefinitionBlock node, DocxRendererContext docx) {
    }

    private void render(FencedCodeBlock node, DocxRendererContext docx) {
        List lines = node.getContentLines();
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderFencedCodeLines(lines);
    }

    private void render(IndentedCodeBlock node, DocxRendererContext docx) {
        List lines = node.getContentLines();
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderFencedCodeLines(lines);
    }

    public void renderList(ListBlock node, DocxRendererContext docx) {
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderChildren((Node)node);
    }

    private void render(BulletList node, DocxRendererContext docx) {
        this.renderList((ListBlock)node, docx);
    }

    private void render(OrderedList node, DocxRendererContext docx) {
        this.renderList((ListBlock)node, docx);
    }

    private void render(BulletListItem node, DocxRendererContext docx) {
        this.renderListItem((ListItem)node, docx);
    }

    private void render(OrderedListItem node, DocxRendererContext docx) {
        this.renderListItem((ListItem)node, docx);
    }

    private void renderListItem(ListItem node, DocxRendererContext docx) {
        PPrBase.NumPr numPr;
        int nesting = node.countDirectAncestorsOfType(ListItem.class, new Class[]{BulletList.class, OrderedList.class});
        DocxRendererOptions options = docx.getDocxRendererOptions();
        String listSpacingStyle = this.listOptions.isTightListItem(node) ? options.TIGHT_PARAGRAPH_STYLE : options.LOOSE_PARAGRAPH_STYLE;
        boolean wantNumbered = node instanceof OrderedListItem;
        String listParagraphStyleId = wantNumbered ? options.PARAGRAPH_NUMBERED_LIST_STYLE : options.PARAGRAPH_BULLET_LIST_STYLE;
        Style listParagraphStyle = docx.getHelper().getStyle(listParagraphStyleId);
        if (listParagraphStyle == null) {
            listParagraphStyleId = listSpacingStyle;
        }
        long numId = wantNumbered ? 3 : 2;
        int listLevel = nesting - 1;
        String listStyleId = wantNumbered ? options.NUMBERED_LIST_STYLE : options.BULLET_LIST_STYLE;
        Style listStyle = docx.getHelper().getStyle(listStyleId);
        if (listStyle != null && (numPr = listStyle.getPPr().getNumPr()) != null) {
            numId = numPr.getNumId().getVal().longValue();
        }
        int newNum = 1;
        NumberingDefinitionsPart ndp = docx.getDocxDocument().getNumberingDefinitionsPart();
        long idNum = numId;
        if (node.getParent() instanceof OrderedList) {
            if (node == node.getParent().getFirstChild()) {
                newNum = this.listOptions.isOrderedListManualStart() ? ((OrderedList)node.getParent()).getStartNumber() : 1;
                idNum = ndp.restart(numId, (long)listLevel, (long)newNum);
                this.ensureNumberedListLength(listLevel);
                this.numberedLists[listLevel] = idNum;
            } else {
                idNum = this.numberedLists[listLevel];
            }
        } else if (node.getParent() instanceof BulletList) {
            if (node == node.getParent().getFirstChild()) {
                this.ensureBulletListLength(listLevel);
                this.bulletLists[listLevel] = idNum;
            } else {
                idNum = this.bulletLists[listLevel];
            }
        }
        docx.setBlockFormatProvider(new ListItemBlockFormatProvider<Node>(docx, listParagraphStyleId, listSpacingStyle, idNum, listLevel, ListItem.class, ListBlock.class));
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        docx.renderChildren((Node)node);
    }

    private void render(SoftLineBreak node, DocxRendererContext docx) {
        docx.addTextCreateR(" ");
    }

    private void render(HardLineBreak node, DocxRendererContext docx) {
        docx.addLineBreak();
    }

    private void render(HtmlBlock node, DocxRendererContext docx) {
        if (node.hasChildren()) {
            docx.renderChildren((Node)node);
        } else {
            this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlBlocks, true);
        }
    }

    private void render(HtmlCommentBlock node, DocxRendererContext docx) {
        this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlCommentBlocks, true);
    }

    private void render(HtmlInnerBlock node, DocxRendererContext docx) {
        this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlBlocks, true);
    }

    private void render(HtmlInnerBlockComment node, DocxRendererContext docx) {
        this.renderHtmlBlock((HtmlBlockBase)node, docx, docx.getDocxRendererOptions().suppressHtmlCommentBlocks, true);
    }

    public void renderHtmlBlock(HtmlBlockBase node, DocxRendererContext docx, boolean suppress, boolean escape) {
        if (this.linebreakOnInlineHtmlBr && node.getChars().unescape().trim().matches("<br\\s*/?>")) {
            docx.createP();
        } else {
            if (suppress) {
                return;
            }
            if (escape) {
                String normalizeEOL = node.getChars().normalizeEOL();
                if (node instanceof HtmlBlock && normalizeEOL.length() > 0 && normalizeEOL.charAt(normalizeEOL.length() - 1) == '\n') {
                    normalizeEOL = normalizeEOL.substring(0, normalizeEOL.length() - 1);
                }
                docx.renderFencedCodeLines(node.getContentLines());
            } else {
                try {
                    docx.getDocxDocument().addAltChunk(AltChunkType.Html, node.getChars().toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (Docx4JException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void render(HtmlInline node, DocxRendererContext docx) {
        this.renderInlineHtml((HtmlInlineBase)node, docx, docx.getDocxRendererOptions().suppressInlineHtml, true);
    }

    private void render(HtmlInlineComment node, DocxRendererContext docx) {
        this.renderInlineHtml((HtmlInlineBase)node, docx, docx.getDocxRendererOptions().suppressInlineHtmlComments, true);
    }

    public void renderInlineHtml(HtmlInlineBase node, DocxRendererContext docx, boolean suppress, boolean escape) {
        if (this.linebreakOnInlineHtmlBr && node.getChars().unescape().matches("<br\\s*/?>")) {
            docx.addLineBreak();
        } else {
            if (suppress) {
                return;
            }
            if (escape) {
                docx.contextFramed(() -> {
                    docx.setRunFormatProvider(new SourceCodeRunFormatProvider<Node>(docx, this.options.noCharacterStyles, this.options.codeHighlightShading));
                    docx.addTextCreateR(node.getChars().normalizeEOL());
                });
            } else {
                try {
                    docx.getDocxDocument().addAltChunk(AltChunkType.Html, node.getChars().toString().getBytes());
                }
                catch (Docx4JException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void render(Reference node, DocxRendererContext docx) {
    }

    private void render(HtmlEntity node, DocxRendererContext docx) {
        docx.addTextCreateR(node.getChars().unescape());
    }

    private void renderURL(BasedSequence urlSource, DocxRendererContext docx, String linkUrl, String linkText) {
        this.renderURL(urlSource, docx, linkUrl, null, new UrlRenderer(docx, linkText, linkUrl));
    }

    private void renderURL(BasedSequence urlSrc, DocxRendererContext docx, String linkUrl, Attributes attributes, Runnable runnable) {
        P p = docx.getP();
        String linkTitle = attributes != null && attributes.contains((CharSequence)"title") ? attributes.getValue((CharSequence)"title") : "";
        P.Hyperlink hyperlink = docx.getFactory().createPHyperlink();
        JAXBElement wrappedHyperlink = docx.getFactory().createPHyperlink(hyperlink);
        p.getContent().add(wrappedHyperlink);
        String highlightMissing = "";
        String linkTooltipText = linkTitle;
        String linkUrlText = linkUrl;
        String useLinkUrl = linkUrl;
        if (useLinkUrl.startsWith("<")) {
            useLinkUrl = useLinkUrl.substring(1);
        }
        if (useLinkUrl.endsWith(">")) {
            useLinkUrl = useLinkUrl.substring(0, useLinkUrl.length() - 1);
        }
        if (useLinkUrl.startsWith("#")) {
            String nodeId = useLinkUrl.substring(1);
            if (docx.getNodeFromId(nodeId) == null) {
                highlightMissing = docx.getRenderingOptions().localHyperlinkMissingHighlight;
                linkTooltipText = String.format(docx.getRenderingOptions().localHyperlinkMissingFormat, nodeId);
                if (docx.getDocxRendererOptions().errorsToStdErr) {
                    Pair atIndex = urlSrc.baseLineColumnAtStart();
                    String sourceFile = docx.getDocxRendererOptions().errorSourceFile;
                    sourceFile = sourceFile.isEmpty() ? "on line " : String.format("in %s:", sourceFile);
                    System.err.println(String.format(Locale.US, "    WARN: Invalid anchor target '%s' %s%d:%d", nodeId, sourceFile, (Integer)atIndex.getFirst() + 1, (Integer)atIndex.getSecond() + 2));
                }
            }
            String anchor = docx.getValidBookmarkName(nodeId) + this.options.localHyperlinkSuffix;
            hyperlink.setAnchor(anchor);
            linkUrlText = String.format("#%s", anchor);
        } else {
            Relationship rel = docx.getHyperlinkRelationship(useLinkUrl);
            hyperlink.setId(rel.getId());
        }
        if (linkTooltipText != null && !linkTooltipText.isEmpty()) {
            hyperlink.setTooltip(linkTooltipText);
        }
        docx.setRunFormatProvider(new RunFormatProviderBase<Node>(docx, docx.getDocxRendererOptions().HYPERLINK_STYLE, this.options.noCharacterStyles, highlightMissing));
        docx.setRunContainer(new UrlRunContainer(hyperlink));
        if (linkTitle != null && !linkTitle.isEmpty()) {
            R r = docx.getFactory().createR();
            hyperlink.getContent().add(r);
            FldChar fldchar = docx.getFactory().createFldChar();
            JAXBElement fldcharWrapped = docx.getFactory().createRFldChar(fldchar);
            r.getContent().add(fldcharWrapped);
            fldchar.setFldCharType(STFldCharType.BEGIN);
            R r2 = docx.getFactory().createR();
            hyperlink.getContent().add(r2);
            org.docx4j.wml.Text text = docx.getFactory().createText();
            JAXBElement textWrapped = docx.getFactory().createRInstrText(text);
            r2.getContent().add(textWrapped);
            text.setValue(String.format(" HYPERLINK \"%s\" \\o \"%s\" ", linkUrlText, linkTitle));
            text.setSpace("preserve");
            R r3 = docx.getFactory().createR();
            hyperlink.getContent().add(r3);
            FldChar fldchar2 = docx.getFactory().createFldChar();
            JAXBElement fldcharWrapped2 = docx.getFactory().createRFldChar(fldchar2);
            r3.getContent().add(fldcharWrapped2);
            fldchar2.setFldCharType(STFldCharType.SEPARATE);
        }
        runnable.run();
        if (linkTitle != null && !linkTitle.isEmpty()) {
            R r3 = docx.getFactory().createR();
            hyperlink.getContent().add(r3);
            FldChar fldchar2 = docx.getFactory().createFldChar();
            JAXBElement fldcharWrapped2 = docx.getFactory().createRFldChar(fldchar2);
            r3.getContent().add(fldcharWrapped2);
            fldchar2.setFldCharType(STFldCharType.END);
        }
    }

    private void render(AutoLink node, DocxRendererContext docx) {
        String url = node.getText().unescape();
        this.addRunAttributeFormatting((Node)node, docx);
        this.renderURL(node.getChars(), docx, url, url);
    }

    private void render(MailLink node, DocxRendererContext docx) {
        this.addRunAttributeFormatting((Node)node, docx);
        String text = node.getText().unescape();
        this.renderURL(node.getChars(), docx, "mailto:" + text, text);
    }

    private void render(Link node, DocxRendererContext docx) {
        ResolvedLink resolvedLink = docx.resolveLink(LinkType.LINK, node.getUrl().unescape(), null, null);
        MutableAttributes attributes = resolvedLink.getNonNullAttributes().toMutable();
        if (node.getTitle().isNotNull()) {
            attributes.replaceValue((CharSequence)"title", (CharSequence)node.getTitle().unescape());
        } else {
            attributes.remove((CharSequence)"title");
        }
        attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, (Attributes)attributes);
        this.addRunAttributeFormatting((Node)node, docx);
        this.renderURL(node.getUrl(), docx, resolvedLink.getUrl(), (Attributes)attributes, new ChildRenderer(docx, (Node)node));
    }

    private void renderInputField(LinkRef node, DocxRendererContext docx) {
        String docxFieldType;
        String defaultFieldName;
        MutableAttributes attributes = docx.extendRenderingNodeAttributes((Node)node, AttributablePart.NODE, null);
        String inputType = "text";
        if (attributes.contains((CharSequence)"class")) {
            Attribute classAttr = attributes.get((CharSequence)"class");
            if (!classAttr.containsValue((CharSequence)"text")) {
                if (classAttr.containsValue((CharSequence)"dropdown")) {
                    inputType = "dropdown";
                } else if (classAttr.containsValue((CharSequence)"checkbox")) {
                    inputType = "checkbox";
                }
            } else {
                inputType = "text";
            }
        }
        int fieldCount = this.formControlCounts.computeIfAbsent(inputType, k -> 0);
        this.formControlCounts.put(inputType, ++fieldCount);
        block7 : switch (inputType) {
            case "checkbox": {
                defaultFieldName = "Check";
                break;
            }
            case "dropdown": {
                defaultFieldName = "Dropdown";
                break;
            }
            default: {
                defaultFieldName = "Text";
                String type = attributes.getValue((CharSequence)"type").trim();
                if (type.isEmpty()) break;
                switch (type) {
                    case "date": {
                        defaultFieldName = "Date";
                        break block7;
                    }
                    case "number": {
                        defaultFieldName = "Number";
                        break block7;
                    }
                    case "current-date": {
                        defaultFieldName = "CurrentDate";
                        break block7;
                    }
                    case "current-time": {
                        defaultFieldName = "CurrentTime";
                    }
                }
            }
        }
        ObjectFactory factory = docx.getFactory();
        FldChar fldChar = docx.addFldCharCreateR(STFldCharType.BEGIN);
        CTFFData ffData = factory.createCTFFData();
        fldChar.setFfData(ffData);
        String fieldName = "";
        if (attributes.contains((CharSequence)"name")) {
            fieldName = attributes.getValue((CharSequence)"name").trim();
        }
        if (fieldName.isEmpty()) {
            fieldName = String.format("%s%d", defaultFieldName, fieldCount);
        }
        CTFFName ffName = factory.createCTFFName();
        ffName.setVal(fieldName);
        ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataName(ffName));
        ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataEnabled(new BooleanDefaultTrue()));
        ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataCalcOnExit(docx.getBooleanDefaultTrue(false)));
        String fieldHelp = attributes.getValue((CharSequence)"help");
        if (!fieldHelp.trim().isEmpty()) {
            CTFFHelpText ffHelpText = factory.createCTFFHelpText();
            CTFFStatusText ctffStatusText = factory.createCTFFStatusText();
            ffHelpText.setVal(fieldHelp);
            ffHelpText.setType(STInfoTextType.TEXT);
            ctffStatusText.setType(STInfoTextType.TEXT);
            ctffStatusText.setVal(fieldHelp);
            ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataHelpText(ffHelpText));
            ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataStatusText(ctffStatusText));
        }
        Runnable extraContent = null;
        switch (inputType) {
            case "checkbox": {
                docxFieldType = "FORMCHECKBOX";
                CTFFCheckBox checkBox = factory.createCTFFCheckBox();
                checkBox.setDefault(docx.getBooleanDefaultTrue(attributes.contains((CharSequence)"checked")));
                checkBox.setSizeAuto(factory.createBooleanDefaultTrue());
                ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataCheckBox(checkBox));
                break;
            }
            case "dropdown": {
                String dropDownDefaultValue;
                docxFieldType = "FORMDROPDOWN";
                CTFFDDList ddList = factory.createCTFFDDList();
                BasedSequence[] options = (BasedSequence[])((BasedSequence)BasedSequence.of((CharSequence)attributes.getValue((CharSequence)"options")).trim()).split((CharSequence)"|", 0, 2);
                if (options.length > 0) {
                    for (BasedSequence option : options) {
                        if (((BasedSequence)option.trim()).isEmpty()) continue;
                        CTFFDDList.ListEntry listEntry = factory.createCTFFDDListListEntry();
                        listEntry.setVal(option.toString());
                        ddList.getListEntry().add(listEntry);
                    }
                }
                if (!(dropDownDefaultValue = attributes.getValue((CharSequence)"default").trim()).isEmpty()) {
                    int i;
                    int iMax = options.length;
                    long defaultIndex = -1L;
                    for (i = 0; i < iMax; ++i) {
                        if (!options[i].equals(dropDownDefaultValue)) continue;
                        defaultIndex = i;
                        break;
                    }
                    if (defaultIndex == -1L) {
                        for (i = 0; i < iMax; ++i) {
                            if (!((BasedSequence)options[i].toLowerCase()).equals(dropDownDefaultValue.toLowerCase())) continue;
                            defaultIndex = i;
                            break;
                        }
                    }
                    if (defaultIndex == -1L) {
                        try {
                            defaultIndex = Long.parseLong(dropDownDefaultValue);
                            if (defaultIndex > 0L) {
                                --defaultIndex;
                            }
                        }
                        catch (NumberFormatException i2) {
                            // empty catch block
                        }
                    }
                    if (defaultIndex >= 0L && defaultIndex < (long)options.length) {
                        BigInteger maxVal = BigInteger.valueOf(defaultIndex);
                        CTFFDDList.Default defaultVal = factory.createCTFFDDListDefault();
                        defaultVal.setVal(maxVal);
                        ddList.setDefault(defaultVal);
                    }
                }
                ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataDdList(ddList));
                break;
            }
            default: {
                Runnable extraExtraContent;
                String useFormat;
                docxFieldType = "FORMTEXT";
                CTFFTextInput textInput = factory.createCTFFTextInput();
                String textDefaultValue = attributes.getValue((CharSequence)"default").trim();
                String maxLength = attributes.getValue((CharSequence)"max-length").trim();
                if (!maxLength.isEmpty()) {
                    long maxLen = -1L;
                    try {
                        maxLen = Long.parseLong(maxLength);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (maxLen > 0L) {
                        BigInteger maxVal = BigInteger.valueOf(maxLen);
                        CTFFTextInput.MaxLength maxLengthValue = factory.createCTFFTextInputMaxLength();
                        maxLengthValue.setVal(maxVal);
                        textInput.setMaxLength(maxLengthValue);
                    }
                }
                String type = attributes.getValue((CharSequence)"type").trim();
                String format = attributes.getValue((CharSequence)"format").trim();
                String typeDefaultValue = null;
                if (!format.isEmpty()) {
                    if (type.equals("regular")) {
                        switch (format.toLowerCase()) {
                            case "upper": 
                            case "uppercase": 
                            case "upper-case": 
                            case "upper case": {
                                useFormat = "UPPERCASE";
                                break;
                            }
                            case "lower": 
                            case "lowercase": 
                            case "lower-case": 
                            case "lower case": {
                                useFormat = "LOWERCASE";
                                break;
                            }
                            case "first": 
                            case "firstcap": 
                            case "firstcaps": 
                            case "firstcapital": 
                            case "first-cap": 
                            case "first-caps": 
                            case "first-capital": 
                            case "first cap": 
                            case "first caps": 
                            case "first capital": {
                                useFormat = "FIRST CAPITAL";
                                break;
                            }
                            case "title": 
                            case "titlecase": 
                            case "title-case": 
                            case "title case": {
                                useFormat = "TITLE CASE";
                                break;
                            }
                            default: {
                                useFormat = "";
                                break;
                            }
                        }
                    } else {
                        useFormat = format;
                    }
                    if (!useFormat.isEmpty()) {
                        CTFFTextInput.Format tiFormat = factory.createCTFFTextInputFormat();
                        tiFormat.setVal(format);
                        textInput.setFormat(tiFormat);
                    }
                } else {
                    useFormat = "";
                }
                STFFTextType stffTextType = null;
                switch (type) {
                    case "date": {
                        stffTextType = STFFTextType.DATE;
                        extraExtraContent = null;
                        typeDefaultValue = this.getCurrentDate(useFormat.isEmpty() ? "yyyy/M/d" : useFormat);
                        break;
                    }
                    case "number": {
                        stffTextType = STFFTextType.NUMBER;
                        typeDefaultValue = "0";
                        extraExtraContent = null;
                        break;
                    }
                    case "current-date": {
                        String currentDate;
                        stffTextType = STFFTextType.CURRENT_TIME;
                        typeDefaultValue = currentDate = this.getCurrentDate(useFormat);
                        extraExtraContent = () -> {
                            docx.addFldCharCreateR(STFldCharType.BEGIN);
                            docx.addInstrTextCreateR(String.format(" DATE \\@ \"%s\" ", useFormat));
                            docx.addFldCharCreateR(STFldCharType.SEPARATE);
                            docx.addInstrTextCreateR(currentDate, true);
                            docx.addFldCharCreateR(STFldCharType.END);
                        };
                        break;
                    }
                    case "current-time": {
                        String currentTime;
                        stffTextType = STFFTextType.CURRENT_DATE;
                        typeDefaultValue = currentTime = this.getCurrentTime(useFormat);
                        extraExtraContent = () -> {
                            docx.addFldCharCreateR(STFldCharType.BEGIN);
                            docx.addInstrTextCreateR(String.format(" TIME \\@ \"%s\" ", useFormat));
                            docx.addFldCharCreateR(STFldCharType.SEPARATE);
                            docx.addInstrTextCreateR(currentTime, true);
                            docx.addFldCharCreateR(STFldCharType.END);
                        };
                        break;
                    }
                    default: {
                        stffTextType = STFFTextType.REGULAR;
                        extraExtraContent = null;
                    }
                }
                if (textDefaultValue.isEmpty() && typeDefaultValue != null) {
                    textDefaultValue = typeDefaultValue;
                }
                CTFFTextInput.Default defaultVal = factory.createCTFFTextInputDefault();
                defaultVal.setVal(textDefaultValue);
                textInput.setDefault(defaultVal);
                String finalTextDefaultValue = textDefaultValue;
                extraContent = () -> {
                    if (extraExtraContent != null) {
                        extraExtraContent.run();
                    }
                    docx.addFldCharCreateR(STFldCharType.SEPARATE);
                    docx.addTextCreateR(finalTextDefaultValue, true);
                };
                CTFFTextType tiType = factory.createCTFFTextType();
                tiType.setVal(stffTextType);
                textInput.setType(tiType);
                ffData.getNameOrEnabledOrCalcOnExit().add(factory.createCTFFDataTextInput(textInput));
            }
        }
        docx.addInstrTextCreateR(String.format(" %s ", docxFieldType));
        if (extraContent != null) {
            extraContent.run();
        }
        docx.addFldCharCreateR(STFldCharType.END);
    }

    @NotNull
    String getCurrentTime(String useFormat) {
        Date date = this.options.runningTests ? Date.from(Instant.ofEpochSecond(1000230400L)) : new Date();
        String currentTime = "";
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(useFormat);
            currentTime = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentTime;
    }

    @NotNull
    String getCurrentDate(String useFormat) {
        Date date = this.options.runningTests ? Date.from(Instant.ofEpochSecond(1000230400L)) : new Date();
        String currentDate = "";
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(useFormat);
            currentDate = dateFormat.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentDate;
    }

    private void render(LinkRef node, DocxRendererContext docx) {
        ResolvedLink resolvedLink = null;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        BasedSequence urlSrc = node.getReference();
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            urlSrc = reference.getUrl();
            String url = urlSrc.unescape();
            resolvedLink = docx.resolveLink(LinkType.LINK, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink = resolvedLink.withTitle((CharSequence)reference.getTitle().unescape());
            }
        } else {
            String normalizeRef = node.getReference().unescape();
            resolvedLink = docx.resolveLink(LinkType.LINK_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN) {
                resolvedLink = null;
            }
        }
        this.addRunAttributeFormatting((Node)node, docx);
        if (resolvedLink == null) {
            assert (!node.isDefined());
            if (!this.options.formControls.isEmpty() && node.getReference().equals(this.options.formControls)) {
                this.renderInputField(node, docx);
            } else if (!node.hasChildren()) {
                docx.addTextCreateR(node.getChars().unescape());
            } else {
                docx.addTextCreateR(node.getChars().prefixOf(node.getChildChars()).unescape());
                docx.renderChildren((Node)node);
                docx.addTextCreateR(node.getChars().suffixOf(node.getChildChars()).unescape());
            }
        } else {
            Attributes attributes = resolvedLink.getNonNullAttributes();
            if (reference != null) {
                attributes = docx.extendRenderingNodeAttributes((Node)reference, AttributablePart.NODE, attributes);
            }
            attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, attributes);
            this.renderURL(urlSrc, docx, resolvedLink.getUrl(), attributes, new ChildRenderer(docx, (Node)node));
        }
    }

    private long getSizeInfo(Attributes attributes, String name, double pageDimension, double scale) {
        double value = -1.0;
        if (scale == 0.0) {
            scale = 1.0;
        }
        if (attributes.contains((CharSequence)name)) {
            String attributeValue = attributes.getValue((CharSequence)name).trim();
            boolean relative = false;
            if (attributeValue.endsWith("%")) {
                attributeValue = attributeValue.substring(0, attributeValue.length() - 1);
                relative = true;
            }
            try {
                if (attributeValue.endsWith("cm")) {
                    value = Double.parseDouble(attributeValue.substring(0, attributeValue.length() - 2).trim());
                    value *= 566.9291338582677 * scale;
                } else if (attributeValue.endsWith("in")) {
                    value = Double.parseDouble(attributeValue.substring(0, attributeValue.length() - 2).trim());
                    value *= 1440.0 * scale;
                } else {
                    value = Double.parseDouble(attributeValue);
                    value *= 20.0 * scale;
                }
            }
            catch (Throwable ignored) {
                value = -1.0;
            }
            if (relative) {
                value *= pageDimension;
            }
        }
        long longValue = -1L;
        try {
            longValue = (long)value;
        }
        catch (Throwable ignored) {
            longValue = -1L;
        }
        return longValue;
    }

    public R newImage(DocxRendererContext docx, BufferedImage image, String filenameHint, Attributes attributes, int id1, int id2, double scale) {
        try {
            BinaryPartAbstractImage imagePart = null;
            byte[] imageBytes = ImageUtils.getImageBytes((BufferedImage)image);
            imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)docx.getPackage(), docx.getContainerPart(), imageBytes);
            Inline inline = null;
            Anchor anchor = null;
            String altText = attributes.contains((CharSequence)"alt") ? attributes.getValue((CharSequence)"alt") : "";
            List sections = docx.getPackage().getDocumentModel().getSections();
            PageDimensions page = ((SectionWrapper)sections.get(sections.size() - 1)).getPageDimensions();
            double writableWidthTwips = page.getWritableWidthTwips();
            long cx = this.getSizeInfo(attributes, "width", page.getWritableWidthTwips(), scale);
            long cy = this.getSizeInfo(attributes, "height", page.getWritableHeightTwips(), scale);
            if (cy == -1L && cx != -1L) {
                cy = (long)((double)image.getHeight() * ((double)cx / ((double)image.getWidth() * 1.0)));
            } else if (cx == -1L && cy != -1L) {
                cx = (long)((double)image.getWidth() * ((double)cy / ((double)image.getHeight() * 1.0)));
            }
            long longMaxWidth = this.getSizeInfo(attributes, "max-width", page.getWritableWidthTwips(), 0.0);
            int maxWidth = longMaxWidth > 0L && longMaxWidth <= Integer.MAX_VALUE ? (int)longMaxWidth : -1;
            long longMaxheight = this.getSizeInfo(attributes, "max-height", page.getWritableHeightTwips(), 0.0);
            int maxheight = longMaxheight > 0L && longMaxheight <= Integer.MAX_VALUE ? (int)longMaxheight : -1;
            long hOffset = 0L;
            long vOffset = 0L;
            if (attributes.contains((CharSequence)"align")) {
                switch (attributes.get((CharSequence)"align").getValue()) {
                    case "left": {
                        hOffset = Long.MIN_VALUE;
                        break;
                    }
                    case "right": {
                        hOffset = Long.MAX_VALUE;
                        break;
                    }
                    case "center": {
                        hOffset = 0x3FFFFFFFFFFFFFFFL;
                        break;
                    }
                }
            }
            if (cx > 0L && cy > 0L) {
                cx = UnitsOfMeasurement.twipToEMU((double)cx);
                cy = UnitsOfMeasurement.twipToEMU((double)cy);
                if (hOffset != 0L) {
                    anchor = imagePart.createImageAnchor(filenameHint, altText, id1, id2, cx, cy, false, hOffset, vOffset);
                } else {
                    inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cx, cy, false);
                }
            } else if (cx > 0L) {
                if (hOffset != 0L) {
                    anchor = imagePart.createImageAnchor(filenameHint, altText, id1, id2, cx, false, hOffset, vOffset);
                } else {
                    inline = imagePart.createImageInline(filenameHint, altText, id1, id2, cx, false);
                }
            } else if (maxWidth > 0 || maxheight > 0) {
                if (hOffset != 0L) {
                    anchor = imagePart.createImageAnchor(filenameHint, altText, id1, id2, false, maxWidth, maxheight, hOffset, vOffset);
                } else {
                    inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false, maxWidth, maxheight);
                }
            } else if (hOffset != 0L) {
                anchor = imagePart.createImageAnchor(filenameHint, altText, id1, id2, false, hOffset, vOffset);
            } else {
                inline = imagePart.createImageInline(filenameHint, altText, id1, id2, false);
            }
            R run = docx.createR();
            Drawing drawing = docx.getFactory().createDrawing();
            run.getContent().add(drawing);
            drawing.getAnchorOrInline().add(inline != null ? inline : anchor);
            return run;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void render(Image node, DocxRendererContext docx) {
        String altText = new TextCollectingVisitor().collectAndGetText((Node)node);
        ResolvedLink resolvedLink = docx.resolveLink(LinkType.IMAGE, node.getUrl().unescape(), null, null);
        MutableAttributes attributes = resolvedLink.getNonNullAttributes().toMutable();
        if (!node.getUrlContent().isEmpty()) {
            String content = Escaping.percentEncodeUrl((CharSequence)node.getUrlContent()).replace("+", "%2B").replace("%3D", "=").replace("%26", "&amp;");
            resolvedLink = resolvedLink.withUrl((CharSequence)(resolvedLink.getUrl() + content));
        }
        if (!altText.isEmpty()) {
            attributes.replaceValue((CharSequence)"alt", (CharSequence)altText);
        }
        attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, (Attributes)attributes);
        this.renderImage(docx, resolvedLink, attributes, 1.0);
    }

    private void render(Emoji node, DocxRendererContext docx) {
        EmojiResolvedShortcut shortcut = EmojiResolvedShortcut.getEmojiText((Emoji)node, (EmojiShortcutType)this.emojiOptions.useShortcutType, (EmojiImageType)this.emojiOptions.useImageType, (String)this.emojiOptions.rootImagePath);
        if (shortcut.emoji == null || shortcut.emojiText == null) {
            docx.addTextCreateR(":");
            docx.renderChildren((Node)node);
            docx.addTextCreateR(":");
        } else if (shortcut.isUnicode) {
            docx.addTextCreateR(shortcut.emojiText);
        } else {
            long adj;
            R r;
            ResolvedLink resolvedLink = docx.resolveLink(LinkType.IMAGE, shortcut.emojiText, null, null);
            MutableAttributes attributes = resolvedLink.getNonNullAttributes().toMutable();
            if (shortcut.alt != null) {
                attributes.replaceValue((CharSequence)"alt", (CharSequence)shortcut.alt);
            }
            RPr rPr = docx.getFactory().createRPr();
            RPr paraRPr = docx.getFactory().createRPr();
            PPr pPr = docx.getFactory().createPPr();
            docx.getBlockFormatProvider().getPPr(pPr);
            docx.getBlockFormatProvider().getParaRPr(paraRPr);
            paraRPr = docx.getHelper().getExplicitRPr((RPrAbstract)paraRPr, pPr);
            docx.getRunFormatProvider().getRPr(rPr);
            rPr = docx.getHelper().getExplicitRPr(rPr);
            StyleUtil.apply((RPr)rPr, (RPr)paraRPr);
            StyleUtil.apply((RPr)paraRPr, (RPr)rPr);
            HpsMeasure sz = rPr.getSz();
            long l = -1L;
            if (sz != null) {
                l = sz.getVal().longValue();
                attributes.replaceValue((CharSequence)"height", (CharSequence)String.valueOf(Math.round((double)l / 2.0 * this.options.docEmojiImageVertSize)));
                attributes.replaceValue((CharSequence)"width", (CharSequence)String.valueOf(Math.round((double)l / 2.0 * this.options.docEmojiImageVertSize)));
            } else if (!this.emojiOptions.attrImageSize.isEmpty()) {
                attributes.replaceValue((CharSequence)"height", (CharSequence)this.emojiOptions.attrImageSize);
                attributes.replaceValue((CharSequence)"width", (CharSequence)this.emojiOptions.attrImageSize);
                l = this.getSizeInfo((Attributes)attributes, "width", 100.0, 1.0);
                l /= 20L;
            }
            if (!this.emojiOptions.attrAlign.isEmpty()) {
                attributes.replaceValue((CharSequence)"align", (CharSequence)this.emojiOptions.attrAlign);
            }
            if ((r = this.renderImage(docx, resolvedLink, attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, (Attributes)attributes), 1.0)) != null && (adj = Math.round((double)l * this.options.docEmojiImageVertOffset)) < 0L) {
                RPr rPr1 = r.getRPr();
                if (rPr1 == null) {
                    rPr1 = docx.getFactory().createRPr();
                    r.setRPr(rPr1);
                }
                CTSignedHpsMeasure hpsMeasure = docx.getFactory().createCTSignedHpsMeasure();
                rPr1.setPosition(hpsMeasure);
                hpsMeasure.setVal(BigInteger.valueOf(adj));
            }
        }
    }

    private void render(ImageRef node, DocxRendererContext docx) {
        ResolvedLink resolvedLink;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            String url = reference.getUrl().unescape();
            resolvedLink = docx.resolveLink(LinkType.IMAGE, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink = resolvedLink.withTitle((CharSequence)reference.getTitle().unescape());
            }
        } else {
            String normalizeRef = this.referenceRepository.normalizeKey((CharSequence)node.getReference());
            resolvedLink = docx.resolveLink(LinkType.IMAGE_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN) {
                resolvedLink = null;
            }
        }
        if (resolvedLink == null) {
            docx.addTextCreateR(node.getChars().unescape());
            if (this.options.logImageProcessing) {
                System.out.println("render image ref of " + this.referenceRepository.normalizeKey((CharSequence)node.getReference()) + " skipped because it was not defined");
            }
        } else {
            String altText = new TextCollectingVisitor().collectAndGetText((Node)node);
            MutableAttributes attributes = resolvedLink.getNonNullAttributes().toMutable();
            if (!altText.isEmpty()) {
                attributes.replaceValue((CharSequence)"alt", (CharSequence)altText);
            }
            if (reference != null) {
                attributes = docx.extendRenderingNodeAttributes((Node)reference, AttributablePart.NODE, (Attributes)attributes);
            }
            attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, (Attributes)attributes);
            this.addRunAttributeFormatting(this.getAttributeFormat((Attributes)attributes, docx), docx);
            this.renderImage(docx, resolvedLink, attributes, 1.0);
        }
    }

    private R renderImage(DocxRendererContext docx, ResolvedLink resolvedLink, MutableAttributes attributes, double scale) {
        BufferedImage image = null;
        int id1 = this.imageId++;
        int id2 = this.imageId++;
        String filenameHint = String.format(Locale.US, "Image%d", id1);
        String url = resolvedLink.getUrl();
        if (url.startsWith("emoji:")) {
            url = this.getClass().getResource("/emoji/" + url.substring("emoji:".length())).toString();
            resolvedLink = resolvedLink.withUrl((CharSequence)url).withStatus(LinkStatus.VALID);
        }
        if (ImageUtils.isEncodedImage((String)url)) {
            image = ImageUtils.base64Decode((String)url);
        } else {
            ResolvedContent resolvedContent = docx.resolvedContent(resolvedLink);
            if (resolvedContent.getStatus() == LinkStatus.VALID) {
                image = ImageUtils.loadImageFromContent((byte[])resolvedContent.getContent(), (String)resolvedLink.getUrl());
            } else if (url.startsWith("http:") || url.startsWith("https:")) {
                image = ImageUtils.loadImageFromURL((String)url, (boolean)this.options.logImageProcessing);
            }
            if (image == null && this.options.logImageProcessing) {
                System.out.println("loadImageFromURL(" + url + ") returned null");
            }
        }
        if (image != null) {
            int width = image.getWidth();
            if (this.options.maxImageWidth > 0 && this.options.maxImageWidth < width) {
                int cx = this.options.maxImageWidth;
                attributes.replaceValue((CharSequence)"width", (CharSequence)String.valueOf(cx));
            }
            return this.newImage(docx, image, filenameHint, (Attributes)attributes, id1, id2, scale);
        }
        return null;
    }

    private void render(TableBlock node, DocxRendererContext docx) {
        Node caption = node.getFirstChildAny(new Class[]{TableCaption.class});
        if (caption != null && this.tableCaptionBeforeTable) {
            this.renderTableCaption((TableCaption)caption, docx);
        }
        Tbl savedTbl = this.myTbl;
        this.myTbl = docx.getFactory().createTbl();
        JAXBElement tblWrapped = docx.getFactory().createHdrTbl(this.myTbl);
        docx.getContent().add(tblWrapped);
        TblPr tblpr = docx.getFactory().createTblPr();
        this.myTbl.setTblPr(tblpr);
        Jc jc = docx.getFactory().createJc();
        tblpr.setJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        if (!this.tableStyle.isEmpty()) {
            CTTblPrBase.TblStyle tblStyle = docx.getFactory().createCTTblPrBaseTblStyle();
            tblpr.setTblStyle(tblStyle);
            tblStyle.setVal(this.tableStyle);
        }
        TblWidth tblwidth = docx.getFactory().createTblWidth();
        tblpr.setTblW(tblwidth);
        if (this.tablePreferredWidthPct == 0) {
            tblwidth.setType("auto");
            tblwidth.setW(BigInteger.valueOf(0L));
        } else {
            tblwidth.setType("pct");
            tblwidth.setW(BigInteger.valueOf(this.tablePreferredWidthPct * 50));
        }
        int cellMargin = 80;
        PPr pPr = docx.getFactory().createPPr();
        docx.getHelper().ensureInd((PPrBase)pPr);
        PPrBase.Ind ind = pPr.getInd();
        ind.setLeft(null);
        PPr parentPPr = docx.getFactory().createPPr();
        docx.getBlockFormatProvider().getPPr(parentPPr);
        PPr styledPPr = docx.getHelper().getExplicitPPr(parentPPr);
        docx.getHelper().inheritInd(pPr, styledPPr);
        TblWidth tblInd = docx.getFactory().createTblWidth();
        tblpr.setTblInd(tblInd);
        tblInd.setType("dxa");
        BigInteger tableInd = BigInteger.valueOf(this.tableLeftIndent).add(docx.getHelper().safeIndLeft(pPr.getInd()));
        tblInd.setW(tableInd);
        docx.setBlockFormatProvider(new IsolatingBlockFormatProvider<Node>(docx));
        this.addBlockAttributeFormatting((Node)node, AttributablePart.NODE, docx, false);
        if (this.tableStyle.isEmpty()) {
            TblBorders tblborders = docx.getFactory().createTblBorders();
            tblpr.setTblBorders(tblborders);
            CTBorder border = docx.getFactory().createCTBorder();
            tblborders.setLeft(border);
            border.setVal(STBorder.SINGLE);
            border.setSz(BigInteger.valueOf(2L));
            border.setColor("000001");
            border.setSpace(BigInteger.valueOf(0L));
            CTBorder border2 = docx.getFactory().createCTBorder();
            tblborders.setRight(border2);
            border2.setVal(STBorder.SINGLE);
            border2.setSz(BigInteger.valueOf(2L));
            border2.setColor("000001");
            border2.setSpace(BigInteger.valueOf(0L));
            CTBorder border3 = docx.getFactory().createCTBorder();
            tblborders.setTop(border3);
            border3.setVal(STBorder.SINGLE);
            border3.setSz(BigInteger.valueOf(2L));
            border3.setColor("000001");
            border3.setSpace(BigInteger.valueOf(0L));
            CTBorder border4 = docx.getFactory().createCTBorder();
            tblborders.setBottom(border4);
            border4.setVal(STBorder.SINGLE);
            border4.setSz(BigInteger.valueOf(2L));
            border4.setColor("000001");
            border4.setSpace(BigInteger.valueOf(0L));
            CTBorder border5 = docx.getFactory().createCTBorder();
            tblborders.setInsideH(border5);
            border5.setVal(STBorder.SINGLE);
            border5.setSz(BigInteger.valueOf(2L));
            border5.setColor("000001");
            border5.setSpace(BigInteger.valueOf(0L));
            CTBorder border6 = docx.getFactory().createCTBorder();
            tblborders.setInsideV(border6);
            border6.setVal(STBorder.SINGLE);
            border6.setSz(BigInteger.valueOf(2L));
            border6.setColor("000001");
            border6.setSpace(BigInteger.valueOf(0L));
        }
        CTTblCellMar tblcellmar = docx.getFactory().createCTTblCellMar();
        tblpr.setTblCellMar(tblcellmar);
        TblWidth tblwidth3 = docx.getFactory().createTblWidth();
        tblcellmar.setLeft(tblwidth3);
        tblwidth3.setType("dxa");
        tblwidth3.setW(BigInteger.valueOf(80L));
        TblWidth tblwidth4 = docx.getFactory().createTblWidth();
        tblcellmar.setRight(tblwidth4);
        tblwidth4.setType("dxa");
        tblwidth4.setW(BigInteger.valueOf(80L));
        TblWidth tblwidth5 = docx.getFactory().createTblWidth();
        tblcellmar.setTop(tblwidth5);
        tblwidth5.setType("dxa");
        tblwidth5.setW(BigInteger.valueOf(80L));
        TblWidth tblwidth6 = docx.getFactory().createTblWidth();
        tblcellmar.setBottom(tblwidth6);
        tblwidth6.setType("dxa");
        tblwidth6.setW(BigInteger.valueOf(80L));
        CTTblLook tbllook = docx.getFactory().createCTTblLook();
        tblpr.setTblLook(tbllook);
        tbllook.setVal("04a0");
        tbllook.setLastRow(STOnOff.ZERO);
        tbllook.setLastColumn(STOnOff.ZERO);
        tbllook.setNoHBand(STOnOff.ZERO);
        tbllook.setNoVBand(STOnOff.ONE);
        tbllook.setFirstRow(STOnOff.ONE);
        tbllook.setFirstColumn(STOnOff.ONE);
        docx.renderChildren((Node)node);
        this.myTbl = savedTbl;
    }

    private void render(TableHead node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(TableSeparator tableSeparator, DocxRendererContext docx) {
    }

    private void render(TableBody node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(TableRow node, DocxRendererContext docx) {
        Tr savedTr = this.myTr;
        this.myTr = docx.getFactory().createTr();
        this.myTbl.getContent().add(this.myTr);
        TrPr trpr = docx.getFactory().createTrPr();
        this.myTr.setTrPr(trpr);
        if (node.getParent() instanceof TableHead) {
            BooleanDefaultTrue booleandefaulttrue = docx.getFactory().createBooleanDefaultTrue();
            JAXBElement booleandefaulttrueWrapped = docx.getFactory().createCTTrPrBaseTblHeader(booleandefaulttrue);
            trpr.getCnfStyleOrDivIdOrGridBefore().add(booleandefaulttrueWrapped);
        }
        docx.renderChildren((Node)node);
        this.myTr = savedTr;
    }

    private void render(TableCaption node, DocxRendererContext docx) {
        if (!this.tableCaptionBeforeTable) {
            this.renderTableCaption(node, docx);
        }
    }

    private void renderTableCaption(TableCaption node, DocxRendererContext docx) {
        if (this.tableCaptionToParagraph) {
            docx.contextFramed(new TableCaptionRenderer(docx, node));
        }
    }

    private void render(TableCell node, DocxRendererContext docx) {
        String styleName = node.isHeader() ? docx.getDocxRendererOptions().TABLE_HEADING : docx.getDocxRendererOptions().TABLE_CONTENTS;
        Tc tc = docx.getFactory().createTc();
        JAXBElement tcWrapped = docx.getFactory().createTrTc(tc);
        this.myTr.getContent().add(tcWrapped);
        TcPr tcpr = docx.getFactory().createTcPr();
        tc.setTcPr(tcpr);
        Style style = docx.getStyle(styleName);
        if (style != null && style.getPPr() != null && style.getPPr().getShd() != null) {
            CTShd shd = docx.getHelper().getCopy(style.getPPr().getShd(), false);
            tcpr.setShd(shd);
        }
        boolean[] firstP = new boolean[]{true};
        docx.setContentContainer(new TableCellContentContainer(tc, docx, firstP));
        docx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(docx, styleName));
        docx.setParaContainer(new TableCellParaContainer(node, tc, docx, firstP));
        if (node.getSpan() > 1) {
            TcPrInner.GridSpan tcprinnergridspan = docx.getFactory().createTcPrInnerGridSpan();
            tcpr.setGridSpan(tcprinnergridspan);
            tcprinnergridspan.setVal(BigInteger.valueOf(node.getSpan()));
        }
        docx.renderChildren((Node)node);
        if (firstP[0]) {
            docx.createP();
        }
    }

    static JcEnumeration getAlignValue(TableCell.Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return JcEnumeration.LEFT;
            }
            case CENTER: {
                return JcEnumeration.CENTER;
            }
            case RIGHT: {
                return JcEnumeration.RIGHT;
            }
        }
        throw new IllegalStateException("Unknown alignment: " + alignment);
    }

    private void render(FootnoteBlock node, DocxRendererContext docx) {
    }

    private void render(Footnote node, DocxRendererContext docx) {
        FootnoteBlock footnoteBlock = node.getFootnoteBlock();
        if (footnoteBlock == null) {
            docx.addText("[^");
            docx.renderChildren((Node)node);
            docx.addText("]");
        } else {
            try {
                BigInteger footnoteId = this.footnoteIDs.getOrDefault(footnoteBlock, BigInteger.ZERO);
                CTFtnEdn ftnEdn = docx.addFootnote(footnoteId);
                BigInteger ftnEdnId = ftnEdn.getId();
                if (ftnEdnId.compareTo(footnoteId) != 0) {
                    docx.contextFramed(new FootnoteFrame(docx, ftnEdn, footnoteBlock));
                }
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
    }

    private void render(TocBlock node, DocxRendererContext docx) {
        this.lastTocBlock = node;
    }

    private void render(SimTocBlock node, DocxRendererContext docx) {
        this.lastTocBlock = node;
    }

    private void render(EnumeratedReferenceText node, DocxRendererContext docx) {
        Object text = node.getText().toString();
        if (((String)text).isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            Node parent;
            String type = EnumeratedReferenceRepository.getType((String)((String)text).toString());
            if ((type.isEmpty() || ((String)text).equals(type + ":")) && (parent = node.getAncestorOfType(new Class[]{Heading.class})) instanceof Heading) {
                text = (String)(type.isEmpty() ? text : type) + ":" + this.headerIdGenerator.getId(parent);
            }
            this.enumeratedOrdinals.renderReferenceOrdinals((String)text, (EnumeratedOrdinalRenderer)new OrdinalRenderer(this, docx));
        }
    }

    private void render(EnumeratedReferenceLink node, DocxRendererContext docx) {
        String text = node.getText().toString();
        if (text.isEmpty()) {
            if (this.ordinalRunnable != null) {
                this.ordinalRunnable.run();
            }
        } else {
            EnumeratedReferenceRendering[] renderings = this.enumeratedOrdinals.getEnumeratedReferenceOrdinals(text);
            String title = new EnumRefTextCollectingVisitor().collectAndGetText(node.getChars().getBaseSequence(), renderings, null);
            MutableAttributes attributes = new MutableAttributes();
            if (title != null) {
                attributes.replaceValue((CharSequence)"title", (CharSequence)title);
            }
            attributes = docx.extendRenderingNodeAttributes(AttributablePart.NODE, (Attributes)attributes);
            this.renderURL(node.getText(), docx, "#" + text, (Attributes)attributes, () -> EnumeratedReferences.renderReferenceOrdinals((EnumeratedReferenceRendering[])renderings, (EnumeratedOrdinalRenderer)new OrdinalRenderer(this, docx)));
        }
    }

    private void render(EnumeratedReferenceBlock node, DocxRendererContext docx) {
    }

    private void render(AttributesNode node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(AttributeNode node, DocxRendererContext docx) {
        if (node.isClass()) {
            switch (node.getValue().toString()) {
                case "pagebreak": {
                    R r = docx.getR();
                    Br br = docx.getFactory().createBr();
                    br.setType(STBrType.PAGE);
                    r.getContent().add(br);
                    break;
                }
                case "tab": {
                    R r = docx.getR();
                    R.Tab tab = docx.getFactory().createRTab();
                    r.getContent().add(tab);
                    break;
                }
            }
        }
    }

    private void render(JekyllTag node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private void render(JekyllTagBlock node, DocxRendererContext docx) {
        docx.renderChildren((Node)node);
    }

    private static class TableCellParaContainer
    implements ParaContainer {
        private final TableCell myNode;
        private final Tc myTc;
        private final DocxRendererContext myDocx;
        private final boolean[] myFirstP;

        public TableCellParaContainer(TableCell node, Tc tc, DocxRendererContext docx, boolean[] firstP) {
            this.myNode = node;
            this.myTc = tc;
            this.myDocx = docx;
            this.myFirstP = firstP;
        }

        @Override
        public void addP(P p) {
            this.myFirstP[0] = false;
            this.myTc.getContent().add(p);
        }

        @Override
        public P getLastP() {
            List content = this.myTc.getContent();
            if (this.myFirstP[0] && (content == null || content.size() == 0)) {
                P p = this.myDocx.createP();
                PPr ppr = p.getPPr();
                if (this.myNode.getAlignment() != null) {
                    JcEnumeration alignValue = CoreNodeDocxRenderer.getAlignValue(this.myNode.getAlignment());
                    Jc jc3 = this.myDocx.getFactory().createJc();
                    ppr.setJc(jc3);
                    jc3.setVal(alignValue);
                }
                this.myFirstP[0] = false;
            }
            if (content == null || content.size() == 0) {
                return null;
            }
            Object o = content.get(content.size() - 1);
            return o instanceof P ? (P)o : null;
        }
    }

    private static class TableCellContentContainer
    implements ContentContainer {
        private final Tc myTc;
        private final DocxRendererContext myDocx;
        private final Part myContainerPart;
        private final boolean[] myFirstP;

        public TableCellContentContainer(Tc tc, DocxRendererContext docx, boolean[] firstP) {
            this.myTc = tc;
            this.myDocx = docx;
            this.myFirstP = firstP;
            this.myContainerPart = this.myDocx.getContainerPart();
        }

        @Override
        public List<Object> getContent() {
            return this.myTc.getContent();
        }

        @Override
        public RelationshipsPart getRelationshipsPart() {
            return this.myContainerPart.relationships;
        }

        @Override
        public Part getContainerPart() {
            return this.myContainerPart;
        }

        @Override
        public Object getLastContentElement() {
            List content = this.myTc.getContent();
            return content != null && content.size() > 0 ? content.get(content.size() - 1) : null;
        }

        @Override
        public void addContentElement(Object element) {
            this.myTc.getContent().add(element);
            this.myFirstP[0] = false;
        }
    }

    private static class TableCaptionRenderer
    implements Runnable {
        private final DocxRendererContext myDocx;
        private final TableCaption myNode;

        public TableCaptionRenderer(DocxRendererContext docx, TableCaption node) {
            this.myDocx = docx;
            this.myNode = node;
        }

        @Override
        public void run() {
            this.myDocx.setBlockFormatProvider(new BlockFormatProviderBase<Node>(this.myDocx, this.myDocx.getDocxRendererOptions().TABLE_CAPTION));
            this.myDocx.createP();
            this.myDocx.renderChildren((Node)this.myNode);
        }
    }

    private static class FootnoteFrame
    implements Runnable {
        final DocxRendererContext myDocx;
        final CTFtnEdn myFtnEdn;
        private final FootnoteBlock myFootnoteBlock;

        public FootnoteFrame(DocxRendererContext docx, CTFtnEdn ftnEdn, FootnoteBlock footnoteBlock) {
            this.myDocx = docx;
            this.myFtnEdn = ftnEdn;
            this.myFootnoteBlock = footnoteBlock;
        }

        @Override
        public void run() {
            this.myDocx.setBlockFormatProvider(new FootnoteBlockFormatProvider<Node>(this.myDocx));
            this.myDocx.setRunFormatProvider(new FootnoteRunFormatProvider<Node>(this.myDocx));
            this.myDocx.setParaContainer(new ParaContainer(){

                @Override
                public void addP(P p) {
                    myFtnEdn.getContent().add(p);
                }

                @Override
                public P getLastP() {
                    List content = myFtnEdn.getContent();
                    if (content == null || content.size() == 0) {
                        return null;
                    }
                    Object o = content.get(content.size() - 1);
                    return o instanceof P ? (P)o : null;
                }
            });
            this.myDocx.setContentContainer(new ContentContainer(){

                @Override
                public RelationshipsPart getRelationshipsPart() {
                    try {
                        return myDocx.getFootnotesPart().getRelationshipsPart();
                    }
                    catch (Docx4JException e) {
                        e.printStackTrace();
                        return myDocx.getDocxDocument().getRelationshipsPart();
                    }
                }

                @Override
                public Part getContainerPart() {
                    try {
                        return myDocx.getFootnotesPart();
                    }
                    catch (Docx4JException e) {
                        e.printStackTrace();
                        return myDocx.getDocxDocument();
                    }
                }

                @Override
                public List<Object> getContent() {
                    return myFtnEdn.getContent();
                }

                @Override
                public Object getLastContentElement() {
                    List<Object> content = this.getContent();
                    return content != null && content.size() > 0 ? content.get(content.size() - 1) : null;
                }

                @Override
                public void addContentElement(Object element) {
                    this.getContent().add(element);
                }
            });
            this.myDocx.renderChildren((Node)this.myFootnoteBlock);
        }
    }

    private static class ChildRenderer
    implements Runnable {
        private final DocxRendererContext myDocx;
        private final Node myNode;

        public ChildRenderer(DocxRendererContext docx, Node node) {
            this.myDocx = docx;
            this.myNode = node;
        }

        @Override
        public void run() {
            this.myDocx.renderChildren(this.myNode);
        }
    }

    private static class UrlRunContainer
    implements RunContainer {
        private final P.Hyperlink myHyperlink;

        public UrlRunContainer(P.Hyperlink hyperlink) {
            this.myHyperlink = hyperlink;
        }

        @Override
        public void addR(R r) {
            this.myHyperlink.getContent().add(r);
        }

        @Override
        public R getLastR() {
            List content = this.myHyperlink.getContent();
            if (content == null || content.size() == 0) {
                return null;
            }
            Object o = content.get(content.size() - 1);
            return o instanceof R ? (R)o : null;
        }
    }

    private static class UrlRenderer
    implements Runnable {
        private final DocxRendererContext myDocx;
        private final String myLinkText;
        private final String myLinkUrl;

        public UrlRenderer(DocxRendererContext docx, String linkText, String linkUrl) {
            this.myDocx = docx;
            this.myLinkText = linkText;
            this.myLinkUrl = linkUrl;
        }

        @Override
        public void run() {
            this.myDocx.addTextCreateR(this.myLinkText == null ? this.myLinkUrl : this.myLinkText);
        }
    }

    private static class OrdinalRenderer
    implements EnumeratedOrdinalRenderer {
        final CoreNodeDocxRenderer renderer;
        final DocxRendererContext docx;

        public OrdinalRenderer(CoreNodeDocxRenderer renderer, DocxRendererContext docx) {
            this.renderer = renderer;
            this.docx = docx;
        }

        public void startRendering(EnumeratedReferenceRendering[] renderings) {
        }

        public void setEnumOrdinalRunnable(Runnable runnable) {
            this.renderer.ordinalRunnable = runnable;
        }

        public Runnable getEnumOrdinalRunnable() {
            return this.renderer.ordinalRunnable;
        }

        public void render(int referenceOrdinal, EnumeratedReferenceBlock referenceFormat, String defaultText, boolean needSeparator) {
            Runnable compoundRunnable = this.renderer.ordinalRunnable;
            String text = referenceOrdinal + (needSeparator ? "." : "");
            if (referenceFormat != null) {
                this.renderer.ordinalRunnable = () -> {
                    if (compoundRunnable != null) {
                        compoundRunnable.run();
                    }
                    this.docx.addTextCreateR(text);
                };
                this.docx.renderChildren((Node)referenceFormat);
            } else if (compoundRunnable != null) {
                this.docx.addTextCreateR(defaultText + " ");
                compoundRunnable.run();
                this.docx.addTextCreateR(text);
            } else {
                this.docx.addTextCreateR(defaultText + " " + text);
            }
        }

        public void endRendering() {
        }
    }
}

