/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.ColorNameMapper;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import java.math.BigInteger;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.STShd;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeFormat {
    @Nullable
    public final String fontFamily;
    @Nullable
    public final String fontSize;
    @Nullable
    public final Boolean fontBold;
    @Nullable
    public final Boolean fontItalic;
    @Nullable
    public final String textColor;
    @Nullable
    public final String fillColor;

    public AttributeFormat(@Nullable String fontFamily, @Nullable String fontSize, @Nullable String fontWeight, @Nullable String fontStyle, @Nullable String textColor, @Nullable String fillColor) {
        this.fontFamily = this.getValidFontFamily(AttributeFormat.trimEmptyToNull(fontFamily));
        this.fontSize = this.getValidFontSize(AttributeFormat.trimEmptyToNull(fontSize));
        this.fontBold = this.getValidFontBold(AttributeFormat.trimEmptyToNull(fontWeight));
        this.fontItalic = this.getValidFontItalic(AttributeFormat.trimEmptyToNull(fontStyle));
        this.textColor = this.getValidNamedOrHexColor(AttributeFormat.trimEmptyToNull(textColor));
        this.fillColor = this.getValidNamedOrHexColor(AttributeFormat.trimEmptyToNull(fillColor));
    }

    @Nullable
    private static String trimEmptyToNull(@Nullable String textColor) {
        if (textColor == null) {
            return null;
        }
        String trimmed = textColor.trim();
        if (!trimmed.isEmpty()) {
            return trimmed;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.fontFamily == null && this.fontSize == null && this.fontBold == null && this.fontItalic == null && this.textColor == null && this.fillColor == null;
    }

    @Nullable
    String getValidHexColor(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return ColorNameMapper.getValidHexColor(s);
    }

    @Nullable
    String getValidNamedOrHexColor(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return ColorNameMapper.getValidNamedOrHexColor(s);
    }

    @Nullable
    private String getValidFontFamily(@Nullable String fontFamily) {
        return fontFamily == null || fontFamily.isEmpty() ? null : fontFamily;
    }

    @Nullable
    private String getValidFontSize(@Nullable String fontSize) {
        return fontSize == null || fontSize.isEmpty() ? null : fontSize;
    }

    @Nullable
    private Boolean getValidFontBold(@Nullable String s) {
        if (s == null) {
            return null;
        }
        switch (s) {
            case "bolder": 
            case "bold": {
                return true;
            }
            case "lighter": 
            case "normal": {
                return false;
            }
        }
        int weight = SequenceUtils.parseIntOrDefault((String)s, (int)-1);
        if (weight != -1) {
            return weight >= 550;
        }
        return null;
    }

    @Nullable
    private Boolean getValidFontItalic(@Nullable String s) {
        int angle;
        if (s == null) {
            return null;
        }
        switch (s) {
            case "oblique": 
            case "italic": {
                return true;
            }
            case "normal": {
                return false;
            }
        }
        if (s.startsWith("oblique ") && (angle = SequenceUtils.parseIntOrDefault((String)s.substring("oblique ".length()).trim(), (int)-1)) != -1) {
            return angle >= 14;
        }
        return null;
    }

    @NotNull
    public <T> CTShd getShd(@NotNull DocxContext<T> docx) {
        CTShd shd = docx.getFactory().createCTShd();
        shd.setColor("auto");
        shd.setFill(this.fillColor);
        shd.setVal(STShd.CLEAR);
        return shd;
    }

    public <T> void setFormatRPr(@NotNull RPrAbstract rPr, @NotNull DocxContext<T> docx) {
        if (this.textColor != null) {
            Color color = docx.getFactory().createColor();
            rPr.setColor(color);
            color.setVal(ColorNameMapper.getValidHexColorOrDefault(this.textColor, "000000").toUpperCase());
            rPr.setColor(color);
        }
        if (this.fillColor != null) {
            CTShd shd = rPr.getShd();
            if (shd == null) {
                shd = docx.getFactory().createCTShd();
                rPr.setShd(shd);
            }
            shd.setColor("auto");
            shd.setFill(this.fillColor);
            shd.setVal(STShd.CLEAR);
        }
        if (this.fontBold != null) {
            rPr.setBCs(this.fontBold != false ? docx.getFactory().createBooleanDefaultTrue() : null);
            rPr.setB(this.fontBold != false ? docx.getFactory().createBooleanDefaultTrue() : null);
        }
        if (this.fontItalic != null) {
            rPr.setICs(this.fontItalic != false ? docx.getFactory().createBooleanDefaultTrue() : null);
            rPr.setI(this.fontItalic != false ? docx.getFactory().createBooleanDefaultTrue() : null);
        }
        if (this.fontSize != null) {
            float ptSz;
            long sz = 0L;
            if (this.fontSize.endsWith("pt")) {
                ptSz = Float.parseFloat(this.fontSize.substring(0, this.fontSize.length() - 2).trim());
                sz = Math.round((double)ptSz * 2.0);
            } else {
                ptSz = Float.parseFloat(this.fontSize);
                sz = Math.round((double)ptSz * 2.0);
            }
            if (sz != 0L) {
                HpsMeasure hpsMeasure = docx.getFactory().createHpsMeasure();
                hpsMeasure.setVal(BigInteger.valueOf(sz));
                rPr.setSzCs(hpsMeasure);
                rPr.setSz(hpsMeasure);
            } else {
                rPr.setSzCs(null);
                rPr.setSz(null);
            }
        }
    }
}

