/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter;

import com.vladsch.flexmark.docx.converter.DocxRenderer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import java.util.HashMap;
import java.util.List;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;

public class DocxRendererOptions {
    private static final HashMap<String, String> standardStyleNames = new HashMap();
    public final boolean escapeHtmlBlocks;
    public final boolean escapeHtmlCommentBlocks;
    public final boolean escapeInlineHtml;
    public final boolean escapeInlineHtmlComments;
    public final boolean percentEncodeUrls;
    public final boolean suppressHtmlBlocks;
    public final boolean suppressHtmlCommentBlocks;
    public final boolean suppressInlineHtml;
    public final boolean suppressInlineHtmlComments;
    public final boolean tocGenerate;
    public final boolean logImageProcessing;
    public final boolean noCharacterStyles;
    public final boolean prefixWwwLinks;
    public final int maxImageWidth;
    public final String tocInstruction;
    public final String codeHighlightShading;
    public final String localHyperlinkSuffix;
    public final String localHyperlinkMissingHighlight;
    public final String localHyperlinkMissingFormat;
    public final boolean errorsToStdErr;
    public final double docEmojiImageVertOffset;
    public final double docEmojiImageVertSize;
    public final String errorSourceFile;
    public final String formControls;
    public final boolean runningTests;
    public final String ASIDE_BLOCK_STYLE;
    public final String BLOCK_QUOTE_STYLE;
    public final String BOLD_STYLE;
    public final String DEFAULT_STYLE;
    public final String ENDNOTE_ANCHOR_STYLE;
    public final String FOOTER;
    public final String FOOTNOTE_ANCHOR_STYLE;
    public final String FOOTNOTE_STYLE;
    public final String FOOTNOTE_TEXT;
    public final String HEADER;
    public final String HEADING_1;
    public final String HEADING_2;
    public final String HEADING_3;
    public final String HEADING_4;
    public final String HEADING_5;
    public final String HEADING_6;
    public final String HORIZONTAL_LINE_STYLE;
    public final String HYPERLINK_STYLE;
    public final String INLINE_CODE_STYLE;
    public final String INS_STYLE;
    public final String ITALIC_STYLE;
    public final String LOOSE_PARAGRAPH_STYLE;
    public final String PREFORMATTED_TEXT_STYLE;
    public final String STRIKE_THROUGH_STYLE;
    public final String SUBSCRIPT_STYLE;
    public final String SUPERSCRIPT_STYLE;
    public final String TABLE_CAPTION;
    public final String TABLE_CONTENTS;
    public final String TABLE_GRID;
    public final String TABLE_HEADING;
    public final String TIGHT_PARAGRAPH_STYLE;
    public final String BULLET_LIST_STYLE;
    public final String NUMBERED_LIST_STYLE;
    public final String PARAGRAPH_BULLET_LIST_STYLE;
    public final String PARAGRAPH_NUMBERED_LIST_STYLE;
    public final String[] HEADINGS;
    final HashMap<String, String> styleIdToStyleName;
    final HashMap<String, String> nameToStyleStyleId;
    public boolean isResolved;

    public DocxRendererOptions(DataHolder options) {
        this(options, null);
    }

    public DocxRendererOptions(DataHolder options, WordprocessingMLPackage out) {
        if (out == null) {
            this.styleIdToStyleName = null;
            this.nameToStyleStyleId = null;
            this.isResolved = false;
        } else {
            this.styleIdToStyleName = new HashMap();
            this.nameToStyleStyleId = new HashMap();
            this.isResolved = true;
            this.initializeStyleNames(out);
        }
        this.escapeHtmlBlocks = (Boolean)DocxRenderer.ESCAPE_HTML_BLOCKS.get(options);
        this.escapeHtmlCommentBlocks = (Boolean)DocxRenderer.ESCAPE_HTML_COMMENT_BLOCKS.get(options);
        this.escapeInlineHtml = (Boolean)DocxRenderer.ESCAPE_INLINE_HTML.get(options);
        this.escapeInlineHtmlComments = (Boolean)DocxRenderer.ESCAPE_INLINE_HTML_COMMENTS.get(options);
        this.percentEncodeUrls = (Boolean)DocxRenderer.PERCENT_ENCODE_URLS.get(options);
        this.suppressHtmlBlocks = (Boolean)DocxRenderer.SUPPRESS_HTML_BLOCKS.get(options);
        this.suppressHtmlCommentBlocks = (Boolean)DocxRenderer.SUPPRESS_HTML_COMMENT_BLOCKS.get(options);
        this.suppressInlineHtml = (Boolean)DocxRenderer.SUPPRESS_INLINE_HTML.get(options);
        this.suppressInlineHtmlComments = (Boolean)DocxRenderer.SUPPRESS_INLINE_HTML_COMMENTS.get(options);
        this.maxImageWidth = (Integer)DocxRenderer.MAX_IMAGE_WIDTH.get(options);
        this.tocInstruction = (String)DocxRenderer.TOC_INSTRUCTION.get(options);
        this.tocGenerate = (Boolean)DocxRenderer.TOC_GENERATE.get(options);
        this.logImageProcessing = (Boolean)DocxRenderer.LOG_IMAGE_PROCESSING.get(options);
        this.noCharacterStyles = (Boolean)DocxRenderer.NO_CHARACTER_STYLES.get(options);
        this.formControls = ((String)DocxRenderer.FORM_CONTROLS.get(options)).trim();
        this.runningTests = (Boolean)SharedDataKeys.RUNNING_TESTS.get(options);
        this.codeHighlightShading = (String)DocxRenderer.CODE_HIGHLIGHT_SHADING.get(options);
        this.localHyperlinkSuffix = (String)DocxRenderer.LOCAL_HYPERLINK_SUFFIX.get(options);
        this.localHyperlinkMissingHighlight = (String)DocxRenderer.LOCAL_HYPERLINK_MISSING_HIGHLIGHT.get(options);
        this.localHyperlinkMissingFormat = (String)DocxRenderer.LOCAL_HYPERLINK_MISSING_FORMAT.get(options);
        this.errorsToStdErr = (Boolean)DocxRenderer.ERRORS_TO_STDERR.get(options);
        this.docEmojiImageVertOffset = (Double)DocxRenderer.DOC_EMOJI_IMAGE_VERT_OFFSET.get(options);
        this.docEmojiImageVertSize = (Double)DocxRenderer.DOC_EMOJI_IMAGE_VERT_SIZE.get(options);
        this.errorSourceFile = (String)DocxRenderer.ERROR_SOURCE_FILE.get(options);
        this.prefixWwwLinks = (Boolean)DocxRenderer.PREFIX_WWW_LINKS.get(options);
        this.ASIDE_BLOCK_STYLE = this.resolveStyleId((String)DocxRenderer.ASIDE_BLOCK_STYLE.get(options), !this.isResolved);
        this.BLOCK_QUOTE_STYLE = this.resolveStyleId((String)DocxRenderer.BLOCK_QUOTE_STYLE.get(options), !this.isResolved);
        this.BOLD_STYLE = this.resolveStyleId((String)DocxRenderer.BOLD_STYLE.get(options), !this.isResolved);
        this.DEFAULT_STYLE = this.resolveStyleId((String)DocxRenderer.DEFAULT_STYLE.get(options), !this.isResolved);
        this.ENDNOTE_ANCHOR_STYLE = this.resolveStyleId((String)DocxRenderer.ENDNOTE_ANCHOR_STYLE.get(options), !this.isResolved);
        this.FOOTER = this.resolveStyleId((String)DocxRenderer.FOOTER.get(options), !this.isResolved);
        this.FOOTNOTE_ANCHOR_STYLE = this.resolveStyleId((String)DocxRenderer.FOOTNOTE_ANCHOR_STYLE.get(options), !this.isResolved);
        this.FOOTNOTE_STYLE = this.resolveStyleId((String)DocxRenderer.FOOTNOTE_STYLE.get(options), !this.isResolved);
        this.FOOTNOTE_TEXT = this.resolveStyleId((String)DocxRenderer.FOOTNOTE_TEXT.get(options), !this.isResolved);
        this.HEADER = this.resolveStyleId((String)DocxRenderer.HEADER.get(options), !this.isResolved);
        this.HEADING_1 = this.resolveStyleId((String)DocxRenderer.HEADING_1.get(options), !this.isResolved);
        this.HEADING_2 = this.resolveStyleId((String)DocxRenderer.HEADING_2.get(options), !this.isResolved);
        this.HEADING_3 = this.resolveStyleId((String)DocxRenderer.HEADING_3.get(options), !this.isResolved);
        this.HEADING_4 = this.resolveStyleId((String)DocxRenderer.HEADING_4.get(options), !this.isResolved);
        this.HEADING_5 = this.resolveStyleId((String)DocxRenderer.HEADING_5.get(options), !this.isResolved);
        this.HEADING_6 = this.resolveStyleId((String)DocxRenderer.HEADING_6.get(options), !this.isResolved);
        this.HORIZONTAL_LINE_STYLE = this.resolveStyleId((String)DocxRenderer.HORIZONTAL_LINE_STYLE.get(options), !this.isResolved);
        this.HYPERLINK_STYLE = this.resolveStyleId((String)DocxRenderer.HYPERLINK_STYLE.get(options), !this.isResolved);
        this.INLINE_CODE_STYLE = this.resolveStyleId((String)DocxRenderer.INLINE_CODE_STYLE.get(options), !this.isResolved);
        this.INS_STYLE = this.resolveStyleId((String)DocxRenderer.INS_STYLE.get(options), !this.isResolved);
        this.ITALIC_STYLE = this.resolveStyleId((String)DocxRenderer.ITALIC_STYLE.get(options), !this.isResolved);
        this.LOOSE_PARAGRAPH_STYLE = this.resolveStyleId((String)DocxRenderer.LOOSE_PARAGRAPH_STYLE.get(options), !this.isResolved);
        this.PREFORMATTED_TEXT_STYLE = this.resolveStyleId((String)DocxRenderer.PREFORMATTED_TEXT_STYLE.get(options), !this.isResolved);
        this.STRIKE_THROUGH_STYLE = this.resolveStyleId((String)DocxRenderer.STRIKE_THROUGH_STYLE.get(options), !this.isResolved);
        this.SUBSCRIPT_STYLE = this.resolveStyleId((String)DocxRenderer.SUBSCRIPT_STYLE.get(options), !this.isResolved);
        this.SUPERSCRIPT_STYLE = this.resolveStyleId((String)DocxRenderer.SUPERSCRIPT_STYLE.get(options), !this.isResolved);
        this.TABLE_CAPTION = this.resolveStyleId((String)DocxRenderer.TABLE_CAPTION.get(options), !this.isResolved);
        this.TABLE_CONTENTS = this.resolveStyleId((String)DocxRenderer.TABLE_CONTENTS.get(options), !this.isResolved);
        this.TABLE_GRID = this.resolveStyleId((String)DocxRenderer.TABLE_GRID.get(options), !this.isResolved);
        this.TABLE_HEADING = this.resolveStyleId((String)DocxRenderer.TABLE_HEADING.get(options), !this.isResolved);
        this.TIGHT_PARAGRAPH_STYLE = this.resolveStyleId((String)DocxRenderer.TIGHT_PARAGRAPH_STYLE.get(options), !this.isResolved);
        this.BULLET_LIST_STYLE = this.resolveStyleId((String)DocxRenderer.BULLET_LIST_STYLE.get(options), !this.isResolved);
        this.NUMBERED_LIST_STYLE = this.resolveStyleId((String)DocxRenderer.NUMBERED_LIST_STYLE.get(options), !this.isResolved);
        this.PARAGRAPH_BULLET_LIST_STYLE = this.resolveStyleId((String)DocxRenderer.PARAGRAPH_BULLET_LIST_STYLE.get(options), !this.isResolved);
        this.PARAGRAPH_NUMBERED_LIST_STYLE = this.resolveStyleId((String)DocxRenderer.PARAGRAPH_NUMBERED_LIST_STYLE.get(options), !this.isResolved);
        this.HEADINGS = new String[]{this.HEADING_1, this.HEADING_2, this.HEADING_3, this.HEADING_4, this.HEADING_5, this.HEADING_6};
    }

    public DocxRendererOptions(DocxRendererOptions other, WordprocessingMLPackage out) {
        String[] stringArray;
        this.styleIdToStyleName = new HashMap();
        this.nameToStyleStyleId = new HashMap();
        this.isResolved = true;
        this.initializeStyleNames(out);
        this.escapeHtmlBlocks = other.escapeHtmlBlocks;
        this.escapeHtmlCommentBlocks = other.escapeHtmlCommentBlocks;
        this.escapeInlineHtml = other.escapeInlineHtml;
        this.escapeInlineHtmlComments = other.escapeInlineHtmlComments;
        this.percentEncodeUrls = other.percentEncodeUrls;
        this.suppressHtmlBlocks = other.suppressHtmlBlocks;
        this.suppressHtmlCommentBlocks = other.suppressHtmlCommentBlocks;
        this.suppressInlineHtml = other.suppressInlineHtml;
        this.suppressInlineHtmlComments = other.suppressInlineHtmlComments;
        this.maxImageWidth = other.maxImageWidth;
        this.tocInstruction = other.tocInstruction;
        this.tocGenerate = other.tocGenerate;
        this.logImageProcessing = other.logImageProcessing;
        this.noCharacterStyles = other.noCharacterStyles;
        this.codeHighlightShading = other.codeHighlightShading;
        this.localHyperlinkSuffix = other.localHyperlinkSuffix;
        this.localHyperlinkMissingHighlight = other.localHyperlinkMissingHighlight;
        this.localHyperlinkMissingFormat = other.localHyperlinkMissingFormat;
        this.errorsToStdErr = other.errorsToStdErr;
        this.docEmojiImageVertOffset = other.docEmojiImageVertOffset;
        this.docEmojiImageVertSize = other.docEmojiImageVertSize;
        this.errorSourceFile = other.errorSourceFile;
        this.prefixWwwLinks = other.prefixWwwLinks;
        this.formControls = other.formControls;
        this.runningTests = other.runningTests;
        this.ASIDE_BLOCK_STYLE = this.resolveStyleId(other.ASIDE_BLOCK_STYLE, other.isResolved);
        this.BLOCK_QUOTE_STYLE = this.resolveStyleId(other.BLOCK_QUOTE_STYLE, other.isResolved);
        this.BOLD_STYLE = this.resolveStyleId(other.BOLD_STYLE, other.isResolved);
        this.DEFAULT_STYLE = this.resolveStyleId(other.DEFAULT_STYLE, other.isResolved);
        this.ENDNOTE_ANCHOR_STYLE = this.resolveStyleId(other.ENDNOTE_ANCHOR_STYLE, other.isResolved);
        this.FOOTER = this.resolveStyleId(other.FOOTER, other.isResolved);
        this.FOOTNOTE_ANCHOR_STYLE = this.resolveStyleId(other.FOOTNOTE_ANCHOR_STYLE, other.isResolved);
        this.FOOTNOTE_STYLE = this.resolveStyleId(other.FOOTNOTE_STYLE, other.isResolved);
        this.FOOTNOTE_TEXT = this.resolveStyleId(other.FOOTNOTE_TEXT, other.isResolved);
        this.HEADER = this.resolveStyleId(other.HEADER, other.isResolved);
        this.HEADING_1 = this.resolveStyleId(other.HEADING_1, other.isResolved);
        this.HEADING_2 = this.resolveStyleId(other.HEADING_2, other.isResolved);
        this.HEADING_3 = this.resolveStyleId(other.HEADING_3, other.isResolved);
        this.HEADING_4 = this.resolveStyleId(other.HEADING_4, other.isResolved);
        this.HEADING_5 = this.resolveStyleId(other.HEADING_5, other.isResolved);
        this.HEADING_6 = this.resolveStyleId(other.HEADING_6, other.isResolved);
        this.HORIZONTAL_LINE_STYLE = this.resolveStyleId(other.HORIZONTAL_LINE_STYLE, other.isResolved);
        this.HYPERLINK_STYLE = this.resolveStyleId(other.HYPERLINK_STYLE, other.isResolved);
        this.INLINE_CODE_STYLE = this.resolveStyleId(other.INLINE_CODE_STYLE, other.isResolved);
        this.INS_STYLE = this.resolveStyleId(other.INS_STYLE, other.isResolved);
        this.ITALIC_STYLE = this.resolveStyleId(other.ITALIC_STYLE, other.isResolved);
        this.LOOSE_PARAGRAPH_STYLE = this.resolveStyleId(other.LOOSE_PARAGRAPH_STYLE, other.isResolved);
        this.PREFORMATTED_TEXT_STYLE = this.resolveStyleId(other.PREFORMATTED_TEXT_STYLE, other.isResolved);
        this.STRIKE_THROUGH_STYLE = this.resolveStyleId(other.STRIKE_THROUGH_STYLE, other.isResolved);
        this.SUBSCRIPT_STYLE = this.resolveStyleId(other.SUBSCRIPT_STYLE, other.isResolved);
        this.SUPERSCRIPT_STYLE = this.resolveStyleId(other.SUPERSCRIPT_STYLE, other.isResolved);
        this.TABLE_CAPTION = this.resolveStyleId(other.TABLE_CAPTION, other.isResolved);
        this.TABLE_CONTENTS = this.resolveStyleId(other.TABLE_CONTENTS, other.isResolved);
        this.TABLE_GRID = this.resolveStyleId(other.TABLE_GRID, other.isResolved);
        this.TABLE_HEADING = this.resolveStyleId(other.TABLE_HEADING, other.isResolved);
        this.TIGHT_PARAGRAPH_STYLE = this.resolveStyleId(other.TIGHT_PARAGRAPH_STYLE, other.isResolved);
        this.BULLET_LIST_STYLE = this.resolveStyleId(other.BULLET_LIST_STYLE, other.isResolved);
        this.NUMBERED_LIST_STYLE = this.resolveStyleId(other.NUMBERED_LIST_STYLE, other.isResolved);
        this.PARAGRAPH_BULLET_LIST_STYLE = this.resolveStyleId(other.PARAGRAPH_BULLET_LIST_STYLE, other.isResolved);
        this.PARAGRAPH_NUMBERED_LIST_STYLE = this.resolveStyleId(other.PARAGRAPH_NUMBERED_LIST_STYLE, other.isResolved);
        if (other.isResolved) {
            stringArray = other.HEADINGS;
        } else {
            String[] stringArray2 = new String[6];
            stringArray2[0] = this.HEADING_1;
            stringArray2[1] = this.HEADING_2;
            stringArray2[2] = this.HEADING_3;
            stringArray2[3] = this.HEADING_4;
            stringArray2[4] = this.HEADING_5;
            stringArray = stringArray2;
            stringArray2[5] = this.HEADING_6;
        }
        this.HEADINGS = stringArray;
    }

    private String resolveStyleId(String styleId, boolean isResolved) {
        String mappedStyleId;
        String standardStyleName;
        if (!isResolved && !this.styleIdToStyleName.containsKey(styleId) && (standardStyleName = standardStyleNames.get(styleId)) != null && (mappedStyleId = this.nameToStyleStyleId.get(standardStyleName)) != null) {
            return mappedStyleId;
        }
        return styleId;
    }

    private void initializeStyleNames(WordprocessingMLPackage out) {
        StyleDefinitionsPart styleDefinitionsPart = out.getMainDocumentPart().getStyleDefinitionsPart();
        try {
            Styles contents = (Styles)styleDefinitionsPart.getContents();
            List styles = contents.getStyle();
            for (Style style : styles) {
                String styleId = style.getStyleId();
                String styleName = style.getName().getVal();
                this.styleIdToStyleName.put(styleId, styleName);
                this.nameToStyleStyleId.put(styleName, styleId);
            }
        }
        catch (Docx4JException e) {
            e.printStackTrace();
        }
    }

    static {
        standardStyleNames.put("AsideBlock", "AsideBlock");
        standardStyleNames.put("BodyText", "Body Text");
        standardStyleNames.put("Emphasis", "Emphasis");
        standardStyleNames.put("EndnoteReference", "endnote reference");
        standardStyleNames.put("Footer", "footer");
        standardStyleNames.put("Footnote", "Footnote");
        standardStyleNames.put("FootnoteReference", "footnote reference");
        standardStyleNames.put("FootnoteText", "footnote text");
        standardStyleNames.put("Header", "header");
        standardStyleNames.put("Heading1", "heading 1");
        standardStyleNames.put("Heading2", "heading 2");
        standardStyleNames.put("Heading3", "heading 3");
        standardStyleNames.put("Heading4", "heading 4");
        standardStyleNames.put("Heading5", "heading 5");
        standardStyleNames.put("Heading6", "heading 6");
        standardStyleNames.put("HorizontalLine", "Horizontal Line");
        standardStyleNames.put("Hyperlink", "Hyperlink");
        standardStyleNames.put("Normal", "Normal");
        standardStyleNames.put("ParagraphTextBody", "Paragraph Text Body");
        standardStyleNames.put("PreformattedText", "Preformatted Text");
        standardStyleNames.put("Quotations", "Quotations");
        standardStyleNames.put("SourceText", "SourceText");
        standardStyleNames.put("Strikethrough", "Strikethrough");
        standardStyleNames.put("StrongEmphasis", "Strong Emphasis");
        standardStyleNames.put("Subscript", "Subscript");
        standardStyleNames.put("Superscript", "Superscript");
        standardStyleNames.put("TableCaption", "Table Caption");
        standardStyleNames.put("TableContents", "Table Contents");
        standardStyleNames.put("TableGrid", "Table Grid");
        standardStyleNames.put("TableHeading", "Table Heading");
        standardStyleNames.put("Underlined", "Underlined");
    }
}

