/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.BlockFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import java.math.BigInteger;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.Style;

public class QuotedFormatProvider<T>
extends BlockFormatProviderBase<T> {
    private final BigInteger myBefore;
    private final BigInteger myAfter;
    private final BigInteger myLeftInd;

    public QuotedFormatProvider(DocxContext<T> docx, int level, String styleId) {
        super(docx, styleId);
        BigInteger after;
        BigInteger before;
        BigInteger left;
        Style style = docx.getStyle(styleId);
        if (style != null) {
            left = docx.getHelper().safeIndLeft((PPrBase)style.getPPr(), 240L);
            before = docx.getHelper().safeSpacingBefore(style.getPPr());
            after = docx.getHelper().safeSpacingAfter(style.getPPr());
        } else {
            left = BigInteger.valueOf(240L);
            before = BigInteger.ZERO;
            after = BigInteger.ZERO;
        }
        BigInteger quoteLevel = BigInteger.valueOf(level);
        BigInteger leftInd = left.multiply(quoteLevel);
        this.myBefore = before;
        this.myAfter = after;
        this.myLeftInd = leftInd;
    }

    @Override
    public void open() {
        super.close();
        this.myDocx.addBlankLine(this.myBefore, this.myDocx.getRenderingOptions().DEFAULT_STYLE);
    }

    @Override
    public void close() {
        this.myDocx.addBlankLine(this.myAfter, this.myDocx.getRenderingOptions().DEFAULT_STYLE);
        super.close();
    }

    @Override
    public void adjustPPrForFormatting(PPr pPr) {
        CTBorder leftBorder;
        BigInteger newLeftInd = this.myDocx.getHelper().safeIndLeft((PPrBase)pPr);
        PPr styledPPr = this.myDocx.getHelper().getExplicitPPr(pPr);
        if (styledPPr == null || styledPPr.getPBdr() == null || newLeftInd == null || newLeftInd.compareTo(this.myLeftInd) <= 0 || (leftBorder = styledPPr.getPBdr().getLeft()) == null || leftBorder.getSpace() == null || leftBorder.getSpace().compareTo(BigInteger.ZERO) > 0) {
            // empty if block
        }
    }
}

