/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.util.Pair;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XmlDocxSorter {
    static DocxPartEntry[] entries = new DocxPartEntry[]{new DocxPartEntry(0, "application/vnd.openxmlformats-package.relationships+xml", "/_rels/.rels"), new DocxPartEntry(1, "application/vnd.openxmlformats-package.relationships+xml", "/word/_rels/document.xml.rels"), new DocxPartEntry(2, "application/vnd.openxmlformats-package.core-properties+xml", "/docProps/core.xml"), new DocxPartEntry(3, "application/vnd.openxmlformats-officedocument.extended-properties+xml", "/docProps/app.xml"), new DocxPartEntry(4, "application/vnd.openxmlformats-package.relationships+xml", "/word/_rels/header%d.xml.rels"), new DocxPartEntry(5, "application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml", "/word/header%d.xml"), new DocxPartEntry(6, "application/vnd.openxmlformats-package.relationships+xml", "/word/_rels/footer%d.xml.rels"), new DocxPartEntry(7, "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml", "/word/footer%d.xml"), new DocxPartEntry(8, "application/vnd.openxmlformats-package.relationships+xml", "/word/_rels/footnotes.xml.rels"), new DocxPartEntry(9, "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml", "/word/footnotes.xml"), new DocxPartEntry(10, "application/vnd.openxmlformats-package.relationships+xml", "/word/_rels/endnotes.xml.rels"), new DocxPartEntry(11, "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml", "/word/endnotes.xml"), new DocxPartEntry(12, "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", "/word/document.xml"), new DocxPartEntry(13, "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml", "/word/settings.xml"), new DocxPartEntry(14, "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml", "/word/webSettings.xml"), new DocxPartEntry(15, "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml", "/word/styles.xml"), new DocxPartEntry(16, "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml", "/word/numbering.xml"), new DocxPartEntry(17, "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml", "/word/fontTable.xml"), new DocxPartEntry(18, "application/vnd.openxmlformats-package.relationships+xml", "/customXml/_rels/item%d.xml.rels"), new DocxPartEntry(19, "application/xml", "/customXml/item%d.xml"), new DocxPartEntry(20, "application/vnd.openxmlformats-officedocument.customXmlProperties+xml", "/customXml/itemProps%d.xml"), new DocxPartEntry(21, "application/vnd.openxmlformats-officedocument.theme+xml", "/word/theme/theme%d.xml"), new DocxPartEntry(22, "application/vnd.ms-word.stylesWithEffects+xml", "/word/stylesWithEffects.xml")};
    static final String XMLNS_PKG = "http://schemas.microsoft.com/office/2006/xmlPackage";
    static final String XMLNS_RELATIONSHIPS = "http://schemas.openxmlformats.org/package/2006/relationships";
    static final String XMLNS_EXTENDED_PROPERTIES = "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties";
    static final String XMLNS_DRAWING = "http://schemas.openxmlformats.org/drawingml/2006/main";
    static final String XMLNS_CORE_PROPERTIES = "http://schemas.openxmlformats.org/package/2006/metadata/core-properties";
    static final String XMLNS_WORDPROCESSING = "http://schemas.openxmlformats.org/wordprocessingml/2006/main";
    static final HashMap<String, String> sortXmlDataAttributes = new HashMap<String, String>(XmlDocxSorter.mapOf("theme", "http://schemas.openxmlformats.org/drawingml/2006/main", "coreProperties", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties", "document", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "endnotes", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fonts", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "footnotes", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "ftr", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "hdr", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "numbering", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "settings", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "styles", "http://schemas.openxmlformats.org/wordprocessingml/2006/main", "webSettings", "http://schemas.openxmlformats.org/wordprocessingml/2006/main"));

    @SafeVarargs
    static <T> Map<T, T> mapOf(T ... keysValues) {
        HashMap<T, T> map = new HashMap<T, T>();
        int iMax = keysValues.length;
        for (int i = 0; i < iMax; ++i) {
            T key = keysValues[i++];
            if (i < iMax) {
                map.put(key, keysValues[i]);
                continue;
            }
            map.put(key, null);
        }
        return map;
    }

    @SafeVarargs
    static <T> T[] arrayOf(T ... content) {
        return content;
    }

    static String xmlnsPrefix(Node node, final String xmlns) {
        String xmlnsPrefix = "";
        if (xmlns != null && !xmlns.isEmpty() && (xmlnsPrefix = XmlDocxSorter.forAllAttributesUntil(node, null, null, null, new Function<Node, String>(){

            @Override
            public String apply(Node a) {
                if ((a.getNodeName().startsWith("xmlns:") || a.getNodeName().startsWith("xmlns:")) && a.getNodeValue().equals(xmlns)) {
                    return a.getNodeName().startsWith("xmlns:") ? a.getNodeName().substring("xmlns:".length()) + ":" : "";
                }
                return null;
            }
        })) == null) {
            xmlnsPrefix = XmlDocxSorter.forAllParentsUntil(node, "", new Function<Node, String>(){

                @Override
                public String apply(Node p) {
                    return XmlDocxSorter.forAllAttributesUntil(p, null, null, null, new Function<Node, String>(){

                        @Override
                        public String apply(Node a) {
                            if ((a.getNodeName().startsWith("xmlns:") || a.getNodeName().startsWith("xmlns:")) && a.getNodeValue().equals(xmlns)) {
                                return a.getNodeName().startsWith("xmlns:") ? a.getNodeName().substring("xmlns:".length()) + ":" : "";
                            }
                            return null;
                        }
                    });
                }
            });
        }
        return xmlnsPrefix;
    }

    static void forAllParents(Node node, final Consumer<Node> consumer) {
        XmlDocxSorter.forAllParentsUntil(node, null, new Function<Node, Object>(){

            @Override
            public Object apply(Node n) {
                consumer.accept(n);
                return null;
            }
        });
    }

    static <T> T forAllParentsUntil(Node node, T defaultValue, Function<Node, T> function) {
        for (Node parentNode = node.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            T result = function.apply(parentNode);
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }

    static void forAllChildren(Node node, Consumer<Node> consumer) {
        XmlDocxSorter.forAllChildren(node, null, null, consumer);
    }

    static void forAllChildren(Node node, String xmlns, String[] tagNames, final Consumer<Node> consumer) {
        XmlDocxSorter.forAllChildrenUntil(node, null, xmlns, tagNames, new Function<Node, Object>(){

            @Override
            public Object apply(Node n) {
                consumer.accept(n);
                return null;
            }
        });
    }

    static <T> T forAllChildrenUntil(Node node, Function<Node, T> function) {
        return XmlDocxSorter.forAllChildrenUntil(node, null, null, null, function);
    }

    static <T> T forAllChildrenUntil(Node node, T defaultValue, Function<Node, T> function) {
        return XmlDocxSorter.forAllChildrenUntil(node, defaultValue, null, null, function);
    }

    static <T> T forAllChildrenUntil(Node node, String xmlns, String[] tagNames, Function<Node, T> function) {
        return XmlDocxSorter.forAllChildrenUntil(node, null, xmlns, tagNames, function);
    }

    static <T> T forAllChildrenUntil(Node node, T defaultValue, String xmlns, String[] tagNames, Function<Node, T> function) {
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            int iMax = childNodes.getLength();
            for (int i = 0; i < iMax; ++i) {
                Node child = childNodes.item(i);
                if (tagNames == null || tagNames.length == 0) {
                    T result = function.apply(child);
                    if (result == null) continue;
                    return result;
                }
                for (String tagName : tagNames) {
                    T result;
                    String xmlnsPrefix = XmlDocxSorter.xmlnsPrefix(child, xmlns);
                    if (!child.getNodeName().equals(xmlnsPrefix + tagName) || (result = function.apply(child)) == null) continue;
                    return result;
                }
            }
        }
        return defaultValue;
    }

    static void forAllAttributes(Node node, Consumer<Node> consumer) {
        XmlDocxSorter.forAllAttributes(node, null, null, consumer);
    }

    static void forAllAttributes(Node node, String xmlns, String[] attributeNames, final Consumer<Node> consumer) {
        XmlDocxSorter.forAllAttributesUntil(node, null, null, attributeNames, new Function<Node, Object>(){

            @Override
            public Object apply(Node n) {
                consumer.accept(n);
                return null;
            }
        });
    }

    static <T> T forAllAttributesUntil(Node node, Function<Node, T> function) {
        return XmlDocxSorter.forAllChildrenUntil(node, null, null, null, function);
    }

    static <T> T forAllAttributesUntil(Node node, T defaultValue, Function<Node, T> function) {
        return XmlDocxSorter.forAllChildrenUntil(node, defaultValue, null, null, function);
    }

    static <T> T forAllAttributesUntil(Node node, T defaultValue, String xmlns, String[] attributeNames, Function<Node, T> function) {
        if (node.hasAttributes()) {
            String xmlnsPrefix = XmlDocxSorter.xmlnsPrefix(node, xmlns);
            NamedNodeMap attributes = node.getAttributes();
            int iMax = attributes.getLength();
            for (int i = 0; i < iMax; ++i) {
                Node item = attributes.item(i);
                if (attributeNames == null || attributeNames.length == 0) {
                    T result = function.apply(item);
                    if (result == null) continue;
                    return result;
                }
                for (String attributeName : attributeNames) {
                    T result;
                    if (!item.getNodeName().equals(xmlnsPrefix + attributeName) || (result = function.apply(item)) == null) continue;
                    return result;
                }
            }
        }
        return defaultValue;
    }

    static Pair<String, String> getXmlnsName(String xmlnsName) {
        int pos = xmlnsName.indexOf(":");
        if (pos >= 0) {
            return new Pair((Object)xmlnsName.substring(0, pos + 1), (Object)xmlnsName.substring(pos + 1));
        }
        return new Pair((Object)"", (Object)xmlnsName);
    }

    static void sortNodeAttributes(final Node node) {
        XmlDocxSorter.forAllChildrenUntil(node, XMLNS_PKG, XmlDocxSorter.arrayOf("xmlData"), new Function<Node, Boolean>(){

            @Override
            public Boolean apply(Node n) {
                XmlDocxSorter.forAllChildrenUntil(n, new Function<Node, Boolean>(){

                    @Override
                    public Boolean apply(Node c) {
                        String xmlnsPrefix;
                        Pair<String, String> xmlnsName = XmlDocxSorter.getXmlnsName(c.getNodeName());
                        if (sortXmlDataAttributes.containsKey(xmlnsName.getFirst()) && (xmlnsPrefix = XmlDocxSorter.xmlnsPrefix(node, sortXmlDataAttributes.get(xmlnsName.getFirst()))).equals(xmlnsName.getSecond())) {
                            final ArrayList toSort = new ArrayList();
                            XmlDocxSorter.forAllAttributes(c, new Consumer<Node>(){

                                @Override
                                public void accept(Node e) {
                                    toSort.add(e);
                                }
                            });
                            for (Node item : toSort) {
                                c.getAttributes().removeNamedItem(item.getNodeName());
                            }
                            Collections.sort(toSort, new Comparator<Node>(){

                                @Override
                                public int compare(Node o1, Node o2) {
                                    return ((String)XmlDocxSorter.getXmlnsName(o1.getNodeName()).getSecond()).compareTo((String)XmlDocxSorter.getXmlnsName(o2.getNodeName()).getSecond());
                                }
                            });
                            for (Node item : toSort) {
                                c.getAttributes().setNamedItem(item);
                            }
                            return true;
                        }
                        return null;
                    }
                });
                return true;
            }
        });
    }

    static void sortRelationships(Node node) {
        XmlDocxSorter.forAllChildrenUntil(node, XMLNS_PKG, XmlDocxSorter.arrayOf("xmlData"), new Function<Node, Boolean>(){

            @Override
            public Boolean apply(Node n) {
                XmlDocxSorter.forAllChildrenUntil(n, XmlDocxSorter.XMLNS_RELATIONSHIPS, XmlDocxSorter.arrayOf("Relationships"), new Function<Node, Boolean>(){

                    @Override
                    public Boolean apply(Node c) {
                        if (c.hasAttributes()) {
                            final ArrayList toSort = new ArrayList();
                            XmlDocxSorter.forAllChildren(c, XmlDocxSorter.XMLNS_RELATIONSHIPS, XmlDocxSorter.arrayOf("Relationship"), new Consumer<Node>(){

                                @Override
                                public void accept(Node r) {
                                    if (r.hasAttributes() && r.getAttributes().getNamedItem("Target") != null) {
                                        toSort.add(r);
                                    }
                                }
                            });
                            for (Node item : toSort) {
                                c.removeChild(item);
                            }
                            Collections.sort(toSort, new Comparator<Node>(){

                                @Override
                                public int compare(Node o1, Node o2) {
                                    return o1.getAttributes().getNamedItem("Target").getNodeValue().compareTo(o2.getAttributes().getNamedItem("Target").getNodeValue());
                                }
                            });
                            for (Node item : toSort) {
                                c.appendChild(item);
                            }
                        }
                        return true;
                    }
                });
                return true;
            }
        });
    }

    static void sortProperties(Node node) {
        XmlDocxSorter.forAllChildrenUntil(node, XMLNS_PKG, XmlDocxSorter.arrayOf("xmlData"), new Function<Node, Boolean>(){

            @Override
            public Boolean apply(Node n) {
                XmlDocxSorter.forAllChildrenUntil(n, XmlDocxSorter.XMLNS_EXTENDED_PROPERTIES, XmlDocxSorter.arrayOf("Properties"), new Function<Node, Boolean>(){

                    @Override
                    public Boolean apply(Node p) {
                        final ArrayList toSort = new ArrayList();
                        XmlDocxSorter.forAllChildren(p, new Consumer<Node>(){

                            @Override
                            public void accept(Node e) {
                                toSort.add(e);
                            }
                        });
                        if (!toSort.isEmpty()) {
                            for (Node item : toSort) {
                                p.removeChild(item);
                            }
                            Collections.sort(toSort, new Comparator<Node>(){

                                @Override
                                public int compare(Node o1, Node o2) {
                                    return ((String)XmlDocxSorter.getXmlnsName(o1.getNodeName()).getSecond()).compareTo((String)XmlDocxSorter.getXmlnsName(o2.getNodeName()).getSecond());
                                }
                            });
                            for (Node item : toSort) {
                                p.appendChild(item);
                            }
                        }
                        return true;
                    }
                });
                return true;
            }
        });
    }

    public static String sortDocumentParts(String xml) {
        try {
            InputSource src = new InputSource(new StringReader(xml));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            Document document = builderFactory.newDocumentBuilder().parse(src);
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            final LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", false);
            final HashMap<String, HashMap<Pattern, DocxPartEntry>> contentTypeNameEntry = new HashMap<String, HashMap<Pattern, DocxPartEntry>>();
            for (DocxPartEntry entry : entries) {
                HashMap<Pattern, DocxPartEntry> entryHashMap = (HashMap<Pattern, DocxPartEntry>)contentTypeNameEntry.get(entry.contentType);
                if (entryHashMap == null) {
                    entryHashMap = new HashMap<Pattern, DocxPartEntry>();
                    contentTypeNameEntry.put(entry.contentType, entryHashMap);
                }
                entryHashMap.put(entry.regex, entry);
            }
            final DocxPartEntry unknownPartEntry = new DocxPartEntry(99, "", "");
            final ArrayList partEntries = new ArrayList();
            final int[] unknownIndex = new int[]{0};
            final StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            XmlDocxSorter.forAllChildren(document, XMLNS_PKG, XmlDocxSorter.arrayOf("package"), new Consumer<Node>(){

                @Override
                public void accept(Node pkg) {
                    XmlDocxSorter.forAllChildren(pkg, XmlDocxSorter.XMLNS_PKG, XmlDocxSorter.arrayOf("part"), new Consumer<Node>(){

                        @Override
                        public void accept(Node part) {
                            Node nameNode;
                            String contentType;
                            HashMap entryHashMap;
                            XmlDocxSorter.sortNodeAttributes(part);
                            XmlDocxSorter.sortRelationships(part);
                            XmlDocxSorter.sortProperties(part);
                            NamedNodeMap attributes = part.getAttributes();
                            Node contentTypeNode = attributes.getNamedItem("pkg:contentType");
                            boolean handled = false;
                            if (contentTypeNode != null && (entryHashMap = (HashMap)contentTypeNameEntry.get(contentType = contentTypeNode.getNodeValue())) != null && (nameNode = attributes.getNamedItem("pkg:name")) != null) {
                                String name = nameNode.getNodeValue();
                                for (Map.Entry entry : entryHashMap.entrySet()) {
                                    Matcher matcher = ((Pattern)entry.getKey()).matcher(name);
                                    if (!matcher.matches()) continue;
                                    int index = matcher.groupCount() > 0 ? Integer.parseInt(matcher.group(1)) : 0;
                                    partEntries.add(new DocxPartEntry((DocxPartEntry)entry.getValue(), part, index));
                                    handled = true;
                                    break;
                                }
                            }
                            if (!handled) {
                                unknownIndex[0] = unknownIndex[0] + 1;
                                partEntries.add(new DocxPartEntry(unknownPartEntry, part, unknownIndex[0]));
                            }
                        }
                    });
                    for (DocxPartEntry pe : partEntries) {
                        pkg.removeChild(pe.node);
                    }
                    Collections.sort(partEntries, new Comparator<DocxPartEntry>(){

                        @Override
                        public int compare(DocxPartEntry o1, DocxPartEntry o2) {
                            int ordinals = Integer.compare(o1.ordinal, o2.ordinal);
                            return ordinals != 0 ? ordinals : Integer.compare(o1.index, o2.index);
                        }
                    });
                    for (DocxPartEntry pe : partEntries) {
                        pkg.appendChild(pe.node);
                    }
                    sb.append(writer.writeToString(pkg));
                }
            });
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class DocxPartEntry {
        public final int ordinal;
        public final String contentType;
        public final String name;
        public final Pattern regex;
        public Node node;
        public final int index;

        public DocxPartEntry(int ordinal, String contentType, String name) {
            this.ordinal = ordinal;
            this.contentType = contentType;
            this.name = name;
            this.regex = Pattern.compile("\\Q" + name.replace("%d", "\\E(\\d+)\\Q") + "\\E");
            this.node = null;
            this.index = 0;
        }

        public DocxPartEntry(DocxPartEntry other, Node node, int index) {
            this.ordinal = other.ordinal;
            this.contentType = other.contentType;
            this.name = other.name;
            this.regex = other.regex;
            this.node = node;
            this.index = index;
        }
    }
}

