/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.ColorNameMapper;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import com.vladsch.flexmark.util.Utils;
import java.math.BigInteger;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.STShd;

public class AttributeFormat {
    public final String fontFamily;
    public final String fontSize;
    public final Boolean fontBold;
    public final Boolean fontItalic;
    public final String textColor;
    public final String fillColor;

    public AttributeFormat(String fontFamily, String fontSize, String fontWeight, String fontStyle, String textColor, String fillColor) {
        this.fontFamily = this.getValidFontFamily(AttributeFormat.trimEmptyToNull(fontFamily));
        this.fontSize = this.getValidFontSize(AttributeFormat.trimEmptyToNull(fontSize));
        this.fontBold = this.getValidFontBold(AttributeFormat.trimEmptyToNull(fontWeight));
        this.fontItalic = this.getValidFontItalic(AttributeFormat.trimEmptyToNull(fontStyle));
        this.textColor = this.getValidNamedOrHexColor(AttributeFormat.trimEmptyToNull(textColor));
        this.fillColor = this.getValidNamedOrHexColor(AttributeFormat.trimEmptyToNull(fillColor));
    }

    private static String trimEmptyToNull(String textColor) {
        if (textColor == null) {
            return null;
        }
        String trimmed = textColor.trim();
        if (!trimmed.isEmpty()) {
            return trimmed;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.fontFamily == null && this.fontSize == null && this.fontBold == null && this.fontItalic == null && this.textColor == null && this.fillColor == null;
    }

    String getValidHexColor(String s) {
        if (s == null) {
            return null;
        }
        return ColorNameMapper.getValidHexColor(s);
    }

    String getValidNamedOrHexColor(String s) {
        if (s == null) {
            return null;
        }
        return ColorNameMapper.getValidNamedOrHexColor(s);
    }

    private String getValidFontFamily(String fontFamily) {
        return fontFamily == null || fontFamily.isEmpty() ? null : fontFamily;
    }

    private String getValidFontSize(String fontSize) {
        return fontSize == null || fontSize.isEmpty() ? null : fontSize;
    }

    private Boolean getValidFontBold(String s) {
        if (s == null) {
            return null;
        }
        switch (s) {
            case "bolder": 
            case "bold": {
                return true;
            }
            case "lighter": 
            case "normal": {
                return false;
            }
        }
        int weight = Utils.parseIntOrDefault((String)s, (int)-1);
        if (weight != -1) {
            return weight >= 550;
        }
        return null;
    }

    private Boolean getValidFontItalic(String s) {
        int angle;
        if (s == null) {
            return null;
        }
        switch (s) {
            case "oblique": 
            case "italic": {
                return true;
            }
            case "normal": {
                return false;
            }
        }
        if (s.startsWith("oblique ") && (angle = Utils.parseIntOrDefault((String)s.substring("oblique ".length()).trim(), (int)-1)) != -1) {
            return angle >= 14;
        }
        return null;
    }

    public <T> CTShd getShd(DocxContext<T> docx) {
        CTShd shd = docx.getFactory().createCTShd();
        shd.setColor("auto");
        shd.setFill(this.fillColor);
        shd.setVal(STShd.CLEAR);
        return shd;
    }

    public <T> void setFormatRPr(RPrAbstract rPr, DocxContext<T> docx) {
        if (this.textColor != null) {
            Color color = docx.getFactory().createColor();
            rPr.setColor(color);
            color.setVal(ColorNameMapper.getValidHexColor(this.textColor).toUpperCase());
            rPr.setColor(color);
        }
        if (this.fillColor != null) {
            CTShd shd = rPr.getShd();
            if (shd == null) {
                shd = docx.getFactory().createCTShd();
                rPr.setShd(shd);
            }
            shd.setColor("auto");
            shd.setFill(this.fillColor);
            shd.setVal(STShd.CLEAR);
        }
        if (this.fontBold != null) {
            rPr.setBCs(this.fontBold != false ? docx.getFactory().createBooleanDefaultTrue() : null);
            rPr.setB(this.fontBold != false ? docx.getFactory().createBooleanDefaultTrue() : null);
        }
        if (this.fontItalic != null) {
            rPr.setICs(this.fontItalic != false ? docx.getFactory().createBooleanDefaultTrue() : null);
            rPr.setI(this.fontItalic != false ? docx.getFactory().createBooleanDefaultTrue() : null);
        }
        if (this.fontSize != null) {
            float ptSz;
            long sz = 0L;
            if (this.fontSize.endsWith("pt")) {
                ptSz = Float.parseFloat(this.fontSize.substring(0, this.fontSize.length() - 2).trim());
                sz = Math.round((double)ptSz * 2.0);
            } else {
                ptSz = Float.parseFloat(this.fontSize);
                sz = Math.round((double)ptSz * 2.0);
            }
            if (sz != 0L) {
                HpsMeasure hpsMeasure = docx.getFactory().createHpsMeasure();
                hpsMeasure.setVal(BigInteger.valueOf(sz));
                rPr.setSzCs(hpsMeasure);
                rPr.setSz(hpsMeasure);
            } else {
                rPr.setSzCs(null);
                rPr.setSz(null);
            }
        }
    }
}

