/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.ColorNameMapper;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import com.vladsch.flexmark.docx.converter.util.RunFormatProvider;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.wml.CTShd;
import org.docx4j.wml.Highlight;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.Style;

public class RunFormatProviderBase<T>
implements RunFormatProvider<T> {
    protected final DocxContext<T> myDocx;
    protected final T myFrame;
    protected final RunFormatProvider<T> myParent;
    protected final String myBaseStyleId;
    protected final boolean myNoCharacterStyles;
    protected final String myHighlightShadingColor;

    public RunFormatProviderBase(DocxContext<T> docx, String baseStyleId, boolean noCharacterStyles, String highlightShadingColor) {
        this.myDocx = docx;
        this.myFrame = docx.getContextFrame();
        this.myParent = docx.getRunFormatProvider();
        this.myBaseStyleId = baseStyleId;
        this.myNoCharacterStyles = noCharacterStyles;
        this.myHighlightShadingColor = highlightShadingColor == null ? "" : highlightShadingColor;
    }

    @Override
    public T getProviderFrame() {
        return this.myFrame;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public Style getStyle() {
        return this.myDocx.getStyle(this.myBaseStyleId);
    }

    @Override
    public String getStyleId() {
        return this.myBaseStyleId;
    }

    @Override
    public RunFormatProvider<T> getRunParent() {
        return this.myParent;
    }

    protected RunFormatProvider<T> getStyleParent() {
        return this.myParent;
    }

    protected void inheritParentStyle(RPr rPr, RPr parentRPr) {
        RPr parentStyledRPr = this.myDocx.getHelper().getExplicitRPr(parentRPr);
        StyleUtil.apply((RPr)rPr, (RPr)parentStyledRPr);
        StyleUtil.apply((RPr)parentStyledRPr, (RPr)rPr);
        Style style = this.getStyle();
        if (style != null) {
            RPr styleRPr = this.myDocx.getHelper().getExplicitRPr(style.getRPr());
            StyleUtil.apply((RPr)rPr, (RPr)styleRPr);
            StyleUtil.apply((RPr)styleRPr, (RPr)rPr);
        }
    }

    @Override
    public void getRPr(RPr rPr) {
        Style thisStyle;
        RunFormatProvider<T> parent;
        if (!this.myNoCharacterStyles && this.myHighlightShadingColor.isEmpty()) {
            RStyle rstyle = this.myDocx.getFactory().createRStyle();
            rPr.setRStyle(rstyle);
            rstyle.setVal(this.myBaseStyleId);
        }
        if ((parent = this.myParent) != null) {
            RPr rpr1 = this.myDocx.getFactory().createRPr();
            parent.getRPr(rpr1);
            this.inheritParentStyle(rPr, rpr1);
        }
        if ((this.myNoCharacterStyles || !this.myHighlightShadingColor.isEmpty()) && (thisStyle = this.myDocx.getStyle(this.myBaseStyleId)) != null) {
            ParaRPr paraRPr = this.myDocx.getP().getPPr().getRPr();
            RPr pr = this.myDocx.getHelper().getExplicitRPr(thisStyle.getRPr());
            if (!this.myHighlightShadingColor.isEmpty()) {
                Highlight highlight;
                String color = this.myHighlightShadingColor;
                CTShd shd = rPr.getShd();
                if (shd != null) {
                    String shdFill = shd.getFill();
                    if (shdFill != null && !shdFill.isEmpty() && !shdFill.equals("auto") && color.equals("shade") && (ColorNameMapper.isNamedColor(shdFill) || ColorNameMapper.isHexColor(shdFill))) {
                        color = shdFill;
                    }
                    rPr.setShd(null);
                }
                if (ColorNameMapper.isNamedColor(color)) {
                    highlight = this.myDocx.getFactory().createHighlight();
                    highlight.setVal(color);
                    rPr.setHighlight(highlight);
                } else if (ColorNameMapper.isHexColor(color)) {
                    highlight = this.myDocx.getFactory().createHighlight();
                    highlight.setVal(ColorNameMapper.findClosestNamedColor(color));
                    rPr.setHighlight(highlight);
                }
            }
            this.myDocx.getHelper().keepDiff(rPr, (RPrAbstract)paraRPr);
        }
    }
}

