/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.BlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;

public class BlockFormatProviderBase<T>
implements BlockFormatProvider<T> {
    protected final DocxContext<T> myDocx;
    protected final T myFrame;
    protected final BlockFormatProvider<T> myParent;
    protected final String myBaseStyleId;
    protected int myPCount;

    public BlockFormatProviderBase(DocxContext<T> docx, String baseStyleId) {
        this.myDocx = docx;
        this.myFrame = docx.getContextFrame();
        this.myParent = docx.getBlockFormatProvider();
        this.myBaseStyleId = baseStyleId;
        this.myPCount = 0;
    }

    @Override
    public void adjustPPrForFormatting(PPr pP) {
        ++this.myPCount;
    }

    @Override
    public T getProviderFrame() {
        return this.myFrame;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    protected Style getBaseStyle() {
        return this.myDocx.getStyle(this.getBaseStyleId());
    }

    @Override
    public Style getStyle() {
        return this.myDocx.getStyle(this.getStyleId());
    }

    protected String getBaseStyleId() {
        return this.myBaseStyleId;
    }

    @Override
    public String getStyleId() {
        return this.myBaseStyleId;
    }

    protected BlockFormatProvider<T> getStyleParent() {
        return this.myParent;
    }

    @Override
    public BlockFormatProvider<T> getBlockParent() {
        return this.myParent;
    }

    protected void inheritIndent(PPr pPrBase, PPr parentPrBase) {
        if (parentPrBase != null) {
            this.myDocx.getHelper().inheritInd(pPrBase, parentPrBase);
        }
    }

    protected void inheritParentFormat(PPr pPr, PPr parentPPr) {
        this.inheritIndent(pPr, parentPPr);
        this.inheritBdr(pPr, parentPPr);
    }

    protected void adjustPPr(PPr pPrBase) {
    }

    protected void inheritBdr(PPr pPr, PPr parentPPr) {
        this.myDocx.getHelper().inheritPBdr(pPr, parentPPr);
    }

    @Override
    public void getPPr(PPr pPr) {
        BlockFormatProvider<T> parent;
        PPrBase.PStyle basePStyle = this.myDocx.getFactory().createPPrBasePStyle();
        pPr.setPStyle(basePStyle);
        basePStyle.setVal(this.myBaseStyleId);
        ParaRPr pararpr = pPr.getRPr();
        if (pararpr == null) {
            pararpr = this.myDocx.getFactory().createParaRPr();
            pPr.setRPr(pararpr);
        }
        if ((parent = this.getStyleParent()) != null) {
            PPr ppr = this.myDocx.getFactory().createPPr();
            parent.getPPr(ppr);
            ppr = this.myDocx.getHelper().getExplicitPPr(ppr);
            this.inheritParentFormat(pPr, ppr);
        }
        this.adjustPPr(pPr);
    }

    @Override
    public void getParaRPr(RPr rPr) {
        Style style;
        BlockFormatProvider<T> parent = this.getStyleParent();
        if (parent != null) {
            parent.getParaRPr(rPr);
        }
        if ((style = this.getStyle()) != null && style.getRPr() != null) {
            StyleUtil.apply((RPr)this.myDocx.getHelper().getExplicitRPr(style.getRPr()), (RPr)rPr);
        }
    }
}

