/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.internal.DocxRendererOptions;
import com.vladsch.flexmark.docx.converter.util.BlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ContentContainer;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import com.vladsch.flexmark.docx.converter.util.DocxHelper;
import com.vladsch.flexmark.docx.converter.util.FencedCodeBlockFormatProvider;
import com.vladsch.flexmark.docx.converter.util.ParaContainer;
import com.vladsch.flexmark.docx.converter.util.RunContainer;
import com.vladsch.flexmark.docx.converter.util.RunFormatProvider;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBElement;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTFtnDocProps;
import org.docx4j.wml.CTFtnEdn;
import org.docx4j.wml.CTFtnEdnRef;
import org.docx4j.wml.CTFtnEdnSepRef;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RPrAbstract;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.STFtnEdn;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.Style;
import org.docx4j.wml.Text;

public abstract class DocxContextImpl<T>
implements DocxContext<T>,
BlockFormatProvider<T>,
RunFormatProvider<T>,
ParaContainer,
RunContainer,
ContentContainer {
    protected final WordprocessingMLPackage myPackage;
    protected final MainDocumentPart myDocumentPart;
    protected final ObjectFactory myFactory;
    protected final DocxHelper myDocxHelper;
    protected final DocxRendererOptions myRendererOptions;
    protected final DataHolder options;
    protected final HashMap<String, Relationship> myHyperlinks;
    protected HashMap<T, BlockFormatProvider<T>> myBlockFormatProviders;
    protected HashMap<T, RunFormatProvider<T>> myRunFormatProviders;
    protected BlockFormatProvider<T> myBlockFormatProvider;
    protected RunFormatProvider<T> myRunFormatProvider;
    protected ContentContainer myContentContainer;
    protected ParaContainer myParaContainer;
    protected RunContainer myRunContainer;
    protected int myFootnoteRef;
    protected AtomicInteger myBookmarkID;

    public DocxContextImpl(WordprocessingMLPackage out, DataHolder options) {
        this.myPackage = out;
        this.options = options;
        this.myRendererOptions = new DocxRendererOptions(this.options);
        this.myFactory = new ObjectFactory();
        this.myDocxHelper = new DocxHelper(this.myPackage, this.myFactory, this.myRendererOptions);
        this.myRunFormatProvider = this;
        this.myRunContainer = this;
        this.myHyperlinks = new HashMap();
        this.myParaContainer = this;
        this.myContentContainer = this;
        this.myDocumentPart = out.getMainDocumentPart();
        this.myBlockFormatProviders = new HashMap();
        this.myRunFormatProviders = new HashMap();
        this.myBlockFormatProvider = this;
        this.myFootnoteRef = 1;
        this.myBookmarkID = new AtomicInteger(1);
    }

    public void setParent(DocxContext parent) {
    }

    @Override
    public T getContextFrame() {
        return null;
    }

    @Override
    public T getProviderFrame() {
        return this.getContextFrame();
    }

    @Override
    public List<Object> getContent() {
        return this.myContentContainer == this ? this.myDocumentPart.getContent() : this.myContentContainer.getContent();
    }

    @Override
    public Object getLastContentElement() {
        if (this.myContentContainer == this) {
            List<Object> content = this.getContent();
            return content != null && content.size() > 0 ? content.get(content.size() - 1) : null;
        }
        return this.myContentContainer.getLastContentElement();
    }

    @Override
    public void addContentElement(Object element) {
        if (this.myContentContainer == this) {
            this.getContent().add(element);
        } else {
            this.myContentContainer.addContentElement(element);
        }
    }

    @Override
    public void setContentContainer(ContentContainer container) {
        this.myContentContainer = container;
    }

    @Override
    public void setParaContainer(ParaContainer container) {
        this.myParaContainer = container;
    }

    @Override
    public void setBlockFormatProvider(BlockFormatProvider<T> formatProvider) {
        this.myBlockFormatProviders.put(this.getContextFrame(), formatProvider);
        this.myBlockFormatProvider = formatProvider;
        formatProvider.open();
    }

    @Override
    public BlockFormatProvider<T> getBlockFormatProvider(T node) {
        return this.myBlockFormatProviders.get(node);
    }

    @Override
    public BlockFormatProvider<T> getBlockFormatProvider() {
        return this.myBlockFormatProvider;
    }

    @Override
    public void setRunContainer(RunContainer container) {
        this.myRunContainer = container;
    }

    @Override
    public void setRunFormatProvider(RunFormatProvider<T> formatProvider) {
        this.myRunFormatProviders.put(this.getContextFrame(), formatProvider);
        this.myRunFormatProvider = formatProvider;
        formatProvider.open();
    }

    @Override
    public RunFormatProvider<T> getRunFormatProvider(T node) {
        return this.myRunFormatProviders.get(node);
    }

    @Override
    public RunFormatProvider<T> getRunFormatProvider() {
        return this.myRunFormatProvider;
    }

    @Override
    public DocxRendererOptions getRenderingOptions() {
        return this.myRendererOptions;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public BlockFormatProvider<T> getBlockParent() {
        return null;
    }

    @Override
    public RunFormatProvider<T> getRunParent() {
        return null;
    }

    @Override
    public String getStyleId() {
        return this.myRendererOptions.DEFAULT_STYLE;
    }

    @Override
    public Style getStyle() {
        return this.getStyle(this.myRendererOptions.DEFAULT_STYLE);
    }

    @Override
    public void adjustPPrForFormatting(PPr pP) {
    }

    @Override
    public void getPPr(PPr pPr) {
    }

    @Override
    public void getParaRPr(RPr rPr) {
    }

    @Override
    public void addP(P p) {
        this.myContentContainer.addContentElement(p);
    }

    @Override
    public void addR(R r) {
        this.getP().getContent().add(r);
    }

    @Override
    public void getRPr(RPr rPr) {
    }

    @Override
    public P getLastP() {
        Object o = this.getLastContentElement();
        return o instanceof P ? (P)o : null;
    }

    @Override
    public R getLastR() {
        P p = this.myParaContainer.getLastP();
        if (p == null) {
            return null;
        }
        List content = p.getContent();
        if (content == null || content.size() == 0) {
            return null;
        }
        Object o = content.get(content.size() - 1);
        return o instanceof R ? (R)o : null;
    }

    @Override
    public PPrBase.PStyle createPStyle(String style) {
        P p = this.getP();
        PPr pPr = p.getPPr();
        PPrBase.PStyle basePStyle = this.myFactory.createPPrBasePStyle();
        pPr.setPStyle(basePStyle);
        basePStyle.setVal(style);
        return basePStyle;
    }

    @Override
    public P createP() {
        return this.createP(null);
    }

    @Override
    public P createP(String style) {
        P p = this.myFactory.createP();
        PPr pPr = this.myFactory.createPPr();
        p.setPPr(pPr);
        this.myParaContainer.addP(p);
        if (style == null) {
            this.myBlockFormatProvider.getPPr(pPr);
            this.myBlockFormatProvider.adjustPPrForFormatting(pPr);
            if (StyleUtil.isEmpty((PPr)p.getPPr())) {
                p.setPPr(null);
            } else if (StyleUtil.isEmpty((ParaRPr)p.getPPr().getRPr())) {
                p.getPPr().setRPr(null);
            }
        } else {
            this.createPStyle(style);
        }
        return p;
    }

    @Override
    public P getP() {
        P p = this.myParaContainer.getLastP();
        if (p != null) {
            return p;
        }
        return this.createP();
    }

    @Override
    public R createR() {
        P p = this.getP();
        R r = this.myFactory.createR();
        RPr rPr = this.myFactory.createRPr();
        r.setRPr(rPr);
        this.myRunContainer.addR(r);
        if (this.myBlockFormatProvider != this || this.myRunFormatProvider != this) {
            Style style;
            PPrBase.PStyle pStyle;
            Style style2;
            RPr blockRPr = this.myFactory.createRPr();
            this.myBlockFormatProvider.getParaRPr(blockRPr);
            this.myRunFormatProvider.getRPr(rPr);
            StyleUtil.apply((RPr)rPr, (RPr)blockRPr);
            StyleUtil.apply((RPr)blockRPr, (RPr)rPr);
            RStyle rStyle = rPr.getRStyle();
            if (rStyle != null && rStyle.getVal() != null && (style2 = this.getStyle(rStyle.getVal())) != null) {
                RPr styleRPr = this.myDocxHelper.getExplicitRPr((RPrAbstract)style2.getRPr(), p.getPPr());
                this.myDocxHelper.keepDiff(rPr, (RPrAbstract)styleRPr);
            }
            if ((pStyle = p.getPPr().getPStyle()) != null && pStyle.getVal() != null && (style = this.getStyle(pStyle.getVal())) != null) {
                RPr styleRPr = this.myDocxHelper.getExplicitRPr((RPrAbstract)style.getRPr(), p.getPPr());
                this.myDocxHelper.keepDiff(rPr, (RPrAbstract)styleRPr);
            }
            if (StyleUtil.isEmpty((RFonts)rPr.getRFonts())) {
                rPr.setRFonts(null);
            }
            if (StyleUtil.isEmpty((RPr)rPr)) {
                r.setRPr(null);
            }
        }
        return r;
    }

    @Override
    public R getR() {
        R r = this.myRunContainer.getLastR();
        if (r == null) {
            return this.createR();
        }
        return r;
    }

    @Override
    public RPr getRPr() {
        R r = this.getR();
        RPr rPr = r.getRPr();
        if (rPr == null) {
            rPr = this.myFactory.createRPr();
            r.setRPr(rPr);
        }
        return rPr;
    }

    @Override
    public int getNextBookmarkId() {
        return this.myBookmarkID.getAndIncrement();
    }

    @Override
    public AtomicInteger getBookmarkIdAtomic() {
        return this.myBookmarkID;
    }

    @Override
    public CTBookmark createBookmarkStart(String bookmarkName, boolean isBlockBookmark) {
        CTBookmark bm = this.myFactory.createCTBookmark();
        int id = this.getNextBookmarkId();
        bm.setId(BigInteger.valueOf(id));
        if (bookmarkName != null && !bookmarkName.isEmpty()) {
            bm.setName(this.getValidBookmarkName(bookmarkName));
        } else {
            bm.setName(String.format("BM_%d", id));
        }
        JAXBElement bmStart = this.myFactory.createBodyBookmarkStart(bm);
        if (isBlockBookmark) {
            this.myContentContainer.addContentElement(bmStart);
        } else {
            this.getP().getContent().add(bmStart);
        }
        return bm;
    }

    @Override
    public CTMarkupRange createBookmarkEnd(CTBookmark bookmarkStart, boolean isBlockBookmark) {
        CTMarkupRange mr = this.myFactory.createCTMarkupRange();
        mr.setId(bookmarkStart.getId());
        JAXBElement bmEnd = this.myFactory.createBodyBookmarkEnd(mr);
        if (isBlockBookmark) {
            this.myContentContainer.addContentElement(bmEnd);
        } else {
            this.getP().getContent().add(bmEnd);
        }
        return mr;
    }

    @Override
    public P.Hyperlink createBookmarkHyperlink(String bookmarkName, String linkText) {
        P.Hyperlink h = MainDocumentPart.hyperlinkToBookmark((String)bookmarkName, (String)linkText);
        this.getP().getContent().add(h);
        return null;
    }

    @Override
    public DocxHelper getHelper() {
        return this.myDocxHelper;
    }

    @Override
    public ObjectFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public void addBlankLine(int size, String styleId) {
        this.addBlankLine(BigInteger.valueOf(size), styleId);
    }

    @Override
    public void addBlankLine(long size, String styleId) {
        this.addBlankLine(BigInteger.valueOf(size), styleId);
    }

    @Override
    public void addBlankLine(BigInteger size, String styleId) {
        if (size.compareTo(BigInteger.ZERO) > 0) {
            P p = this.myFactory.createP();
            PPr pPr = this.myFactory.createPPr();
            p.setPPr(pPr);
            this.myParaContainer.addP(p);
            if (styleId != null && !styleId.isEmpty()) {
                if (pPr.getPStyle() == null) {
                    PPrBase.PStyle pStyle = this.myDocxHelper.myFactory.createPPrBasePStyle();
                    pPr.setPStyle(pStyle);
                }
                pPr.getPStyle().setVal(styleId);
            }
            PPrBase.Spacing spacing = this.myFactory.createPPrBaseSpacing();
            pPr.setSpacing(spacing);
            spacing.setBefore(BigInteger.ZERO);
            spacing.setAfter(BigInteger.ZERO);
            spacing.setLine(size);
            spacing.setLineRule(STLineSpacingRule.EXACT);
        }
    }

    @Override
    public void addBlankLines(int count) {
        if (count > 0) {
            PPr pPr = this.myFactory.createPPr();
            this.myBlockFormatProvider.getPPr(pPr);
            PPr explicitPPr = this.myDocxHelper.getExplicitPPr(pPr);
            ParaRPr rPr = explicitPPr.getRPr();
            BigInteger size = rPr.getSz().getVal().max(rPr.getSzCs().getVal());
            this.addBlankLine(size.multiply(BigInteger.valueOf(count)), null);
        }
    }

    @Override
    public Text addWrappedText() {
        Text text = this.myFactory.createText();
        JAXBElement textWrapped = this.myFactory.createRT(text);
        this.getR().getContent().add(textWrapped);
        return text;
    }

    @Override
    public void addLineBreak() {
        this.addBreak(null);
    }

    @Override
    public void contextFramed(Runnable runnable) {
        BlockFormatProvider<T> blockFormatProvider;
        RunFormatProvider<T> runFormatProvider;
        this.myBlockFormatProviders.put(this.getContextFrame(), this.myBlockFormatProvider);
        this.myRunFormatProviders.put(this.getContextFrame(), this.myRunFormatProvider);
        BlockFormatProvider<T> oldRenderingBlockFormatProvider = this.myBlockFormatProvider;
        RunFormatProvider<T> oldRenderingRunFormatProvider = this.myRunFormatProvider;
        ContentContainer oldRenderingContentContainer = this.myContentContainer;
        ParaContainer oldRenderingParaContainer = this.myParaContainer;
        RunContainer oldRenderingRunContainer = this.myRunContainer;
        T oldNode = this.getContextFrame();
        runnable.run();
        if (oldNode != this.getContextFrame() && (runFormatProvider = this.myRunFormatProviders.remove(oldNode)) != oldRenderingRunFormatProvider) {
            runFormatProvider.close();
        }
        this.myRunFormatProvider = oldRenderingRunFormatProvider;
        if (oldNode != this.getContextFrame() && (blockFormatProvider = this.myBlockFormatProviders.remove(oldNode)) != oldRenderingBlockFormatProvider) {
            blockFormatProvider.close();
        }
        this.myBlockFormatProvider = oldRenderingBlockFormatProvider;
        this.myRunContainer = oldRenderingRunContainer;
        this.myParaContainer = oldRenderingParaContainer;
        this.myContentContainer = oldRenderingContentContainer;
    }

    @Override
    public void addPageBreak() {
        this.addBreak(STBrType.PAGE);
    }

    @Override
    public void addBreak(STBrType breakType) {
        R r = this.myFactory.createR();
        Br br = this.myFactory.createBr();
        if (breakType != null) {
            br.setType(breakType);
        }
        r.getContent().add(br);
        this.myRunContainer.addR(r);
    }

    @Override
    public RPr addBold() {
        RPr rPr = this.getRPr();
        rPr.setB(this.myFactory.createBooleanDefaultTrue());
        rPr.setBCs(this.myFactory.createBooleanDefaultTrue());
        return rPr;
    }

    @Override
    public Color createColor() {
        RPr rPr = this.getRPr();
        Color color = this.myFactory.createColor();
        color.setVal("BB002F");
        rPr.setColor(color);
        return color;
    }

    @Override
    public HpsMeasure createHpsMeasure(long val) {
        RPr rPr = this.getRPr();
        HpsMeasure hpsmeasure = this.myFactory.createHpsMeasure();
        rPr.setSz(hpsmeasure);
        hpsmeasure.setVal(BigInteger.valueOf(val));
        return hpsmeasure;
    }

    public void createHorizontalLine() {
        P p = this.createP(this.myRendererOptions.HORIZONTAL_LINE_STYLE);
        R r = this.createR();
    }

    @Override
    public Text text(String text) {
        R r = this.createR();
        Text textElem = this.addWrappedText();
        textElem.setValue(text);
        textElem.setSpace("preserve");
        return textElem;
    }

    @Override
    public WordprocessingMLPackage getPackage() {
        return this.myPackage;
    }

    @Override
    public MainDocumentPart getDocxDocument() {
        return this.myDocumentPart;
    }

    @Override
    public Style getStyle(String styleName) {
        return this.myDocumentPart.getStyleDefinitionsPart().getStyleById(styleName);
    }

    @Override
    public RelationshipsPart getRelationshipsPart() {
        return this.myContentContainer == this ? this.myDocumentPart.getRelationshipsPart() : this.myContentContainer.getRelationshipsPart();
    }

    @Override
    public Part getContainerPart() {
        return this.myContentContainer == this ? this.myDocumentPart : this.myContentContainer.getContainerPart();
    }

    @Override
    public Relationship getHyperlinkRelationship(String url) {
        Relationship rel = this.myHyperlinks.get(url);
        if (rel != null) {
            return rel;
        }
        org.docx4j.relationships.ObjectFactory factory = new org.docx4j.relationships.ObjectFactory();
        rel = factory.createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        rel.setTarget(url);
        rel.setTargetMode("External");
        this.myContentContainer.getRelationshipsPart().addRelationship(rel);
        this.myHyperlinks.put(url, rel);
        return rel;
    }

    @Override
    public void renderFencedCodeLines(CharSequence ... lines) {
        this.renderFencedCodeLines(Arrays.asList(lines));
    }

    @Override
    public void renderFencedCodeLines(final List<? extends CharSequence> lines) {
        this.contextFramed(new Runnable(){

            @Override
            public void run() {
                DocxContextImpl.this.setBlockFormatProvider(new FencedCodeBlockFormatProvider(DocxContextImpl.this));
                DocxContextImpl.this.createP();
                int[] leadColumns = new int[lines.size()];
                int minSpaces = Integer.MAX_VALUE;
                int i = 0;
                for (CharSequence line : lines) {
                    leadColumns[i] = BasedSequenceImpl.of((CharSequence)line).countLeadingColumns(0, (CharSequence)" \t");
                    minSpaces = Utils.min((int)minSpaces, (int[])new int[]{leadColumns[i]});
                    ++i;
                }
                ArrayList trimmedLines = new ArrayList();
                i = 0;
                for (CharSequence line : lines) {
                    StringBuilder sb = new StringBuilder();
                    int spaces = leadColumns[i] - minSpaces;
                    while (spaces-- > 0) {
                        sb.append(' ');
                    }
                    sb.append((CharSequence)BasedSequenceImpl.of((CharSequence)line).trim());
                    DocxContextImpl.this.text(sb.toString());
                    if (++i >= lines.size()) continue;
                    DocxContextImpl.this.addLineBreak();
                }
            }
        });
    }

    @Override
    public FootnotesPart getFootnotesPart() throws Docx4JException {
        FootnotesPart footnotesPart = this.myDocumentPart.getFootnotesPart();
        if (footnotesPart == null) {
            CTFtnDocProps ftndocprops;
            CTSettings settings;
            footnotesPart = new FootnotesPart();
            this.myDocumentPart.addTargetPart((Part)footnotesPart);
            CTFootnotes footnotes = this.myFactory.createCTFootnotes();
            CTFtnEdn ftnedn = this.myFactory.createCTFtnEdn();
            footnotes.getFootnote().add(ftnedn);
            ftnedn.setId(BigInteger.valueOf(-1L));
            ftnedn.setType(STFtnEdn.SEPARATOR);
            P p = this.myFactory.createP();
            ftnedn.getContent().add(p);
            R r = this.myFactory.createR();
            p.getContent().add(r);
            R.Separator rseparator = this.myFactory.createRSeparator();
            JAXBElement rseparatorWrapped = this.myFactory.createRSeparator(rseparator);
            r.getContent().add(rseparatorWrapped);
            CTFtnEdn ftnedn2 = this.myFactory.createCTFtnEdn();
            footnotes.getFootnote().add(ftnedn2);
            ftnedn2.setId(BigInteger.valueOf(0L));
            ftnedn2.setType(STFtnEdn.CONTINUATION_SEPARATOR);
            P p2 = this.myFactory.createP();
            ftnedn2.getContent().add(p2);
            R r2 = this.myFactory.createR();
            p2.getContent().add(r2);
            R.ContinuationSeparator rcontinuationseparator = this.myFactory.createRContinuationSeparator();
            JAXBElement rcontinuationseparatorWrapped = this.myFactory.createRContinuationSeparator(rcontinuationseparator);
            r2.getContent().add(rcontinuationseparatorWrapped);
            footnotesPart.setJaxbElement((Object)footnotes);
            DocumentSettingsPart dsp = this.myDocumentPart.getDocumentSettingsPart();
            if (dsp == null) {
                dsp = new DocumentSettingsPart();
                this.myDocumentPart.addTargetPart((Part)dsp);
            }
            if ((settings = (CTSettings)dsp.getContents()) == null) {
                settings = this.myFactory.createCTSettings();
                dsp.setJaxbElement((Object)settings);
            }
            if ((ftndocprops = settings.getFootnotePr()) == null) {
                ftndocprops = this.myFactory.createCTFtnDocProps();
                CTFtnEdnSepRef sepRef = this.myFactory.createCTFtnEdnSepRef();
                sepRef.setId(BigInteger.valueOf(-1L));
                ftndocprops.getFootnote().add(sepRef);
                sepRef = this.myFactory.createCTFtnEdnSepRef();
                sepRef.setId(BigInteger.valueOf(0L));
                ftndocprops.getFootnote().add(sepRef);
                settings.setFootnotePr(ftndocprops);
            }
        }
        return footnotesPart;
    }

    @Override
    public CTFtnEdn addFootnote(BigInteger footnoteID) throws Docx4JException {
        CTFtnEdnRef ftnednref = this.myFactory.createCTFtnEdnRef();
        JAXBElement ftnednrefWrapped = this.myFactory.createRFootnoteReference(ftnednref);
        R ftnR = this.myFactory.createR();
        this.getP().getContent().add(ftnR);
        ftnR.getContent().add(ftnednrefWrapped);
        RPr ftnRPr = this.myFactory.createRPr();
        ftnR.setRPr(ftnRPr);
        RStyle ftnRStyle = this.myFactory.createRStyle();
        ftnRPr.setRStyle(ftnRStyle);
        ftnRStyle.setVal(this.myRendererOptions.FOOTNOTE_ANCHOR_STYLE);
        boolean haveID = footnoteID.compareTo(BigInteger.ZERO) > 0;
        BigInteger i = haveID ? footnoteID : BigInteger.valueOf(this.myFootnoteRef++);
        ftnednref.setId(i);
        if (haveID) {
            for (CTFtnEdn ftnEdn : ((CTFootnotes)this.getFootnotesPart().getContents()).getFootnote()) {
                if (ftnEdn.getId().compareTo(footnoteID) != 0) continue;
                return ftnEdn;
            }
        }
        CTFtnEdn ftnEdn = this.myFactory.createCTFtnEdn();
        ftnEdn.setId(i);
        P p = this.myFactory.createP();
        ftnEdn.getContent().add(p);
        PPr pPr = this.myFactory.createPPr();
        p.setPPr(pPr);
        PPrBase.PStyle pStyle = this.myFactory.createPPrBasePStyle();
        pPr.setPStyle(pStyle);
        pStyle.setVal(this.myRendererOptions.FOOTNOTE_STYLE);
        R r1 = this.myFactory.createR();
        p.getContent().add(r1);
        RPr rPr = this.myFactory.createRPr();
        r1.setRPr(rPr);
        RStyle rStyle = this.myFactory.createRStyle();
        rPr.setRStyle(rStyle);
        rStyle.setVal(this.myRendererOptions.FOOTNOTE_ANCHOR_STYLE);
        R.FootnoteRef footnoteRef = this.myFactory.createRFootnoteRef();
        r1.getContent().add(footnoteRef);
        R r2 = this.myFactory.createR();
        Text text1 = this.myFactory.createText();
        JAXBElement textWrapped = this.myFactory.createRT(text1);
        r2.getContent().add(textWrapped);
        text1.setSpace("preserve");
        text1.setValue("\t");
        p.getContent().add(r2);
        ((CTFootnotes)this.getFootnotesPart().getContents()).getFootnote().add(ftnEdn);
        return ftnEdn;
    }
}

