/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XmlFormatter {
    public static String format(String xml) {
        try {
            InputSource src = new InputSource(new StringReader(xml));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            Boolean keepDeclaration = xml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            return writer.writeToString(document);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatDocumentBody(String xml) {
        try {
            Node item;
            int i;
            InputSource src = new InputSource(new StringReader(xml));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(false);
            Document document = builderFactory.newDocumentBuilder().parse(src);
            NodeList bodies = document.getElementsByTagName("w:body");
            NodeList sections = document.getElementsByTagName("w:sectPr");
            NodeList footnotes = document.getElementsByTagName("w:footnote");
            Boolean keepDeclaration = xml.startsWith("<?xml");
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            writer.getDomConfig().setParameter("xml-declaration", false);
            int iMax = sections.getLength();
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < iMax; ++i) {
                item = sections.item(i);
                item.getParentNode().removeChild(item);
            }
            iMax = bodies.getLength();
            for (i = 0; i < iMax; ++i) {
                item = bodies.item(i);
                sb.append(writer.writeToString(item));
            }
            iMax = footnotes.getLength();
            for (i = 0; i < iMax; ++i) {
                item = footnotes.item(i);
                sb.append(writer.writeToString(item));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

