/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.BlockFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import java.math.BigInteger;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;

public class HeadingBlockFormatProvider<T>
extends BlockFormatProviderBase<T> {
    private final DocxContext<T> myDocx;
    private final int myHeadingLevel;

    public HeadingBlockFormatProvider(DocxContext<T> docx, int headingLevel) {
        super(docx, String.format("Heading%d", headingLevel + 1));
        this.myDocx = docx;
        this.myHeadingLevel = headingLevel;
    }

    @Override
    public void getPPr(PPr pPr) {
        PPrBase.NumPr baseNumPr = this.myDocx.getFactory().createPPrBaseNumPr();
        pPr.setNumPr(baseNumPr);
        PPrBase.NumPr.NumId prNumId = this.myDocx.getFactory().createPPrBaseNumPrNumId();
        baseNumPr.setNumId(prNumId);
        prNumId.setVal(BigInteger.valueOf(0L));
        PPrBase.NumPr.Ilvl prIlvl = this.myDocx.getFactory().createPPrBaseNumPrIlvl();
        baseNumPr.setIlvl(prIlvl);
        prIlvl.setVal(BigInteger.valueOf(this.myHeadingLevel));
        super.getPPr(pPr);
    }
}

