/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.docx.converter.util.BlockFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import java.math.BigInteger;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.Style;

public class QuoteBlockFormatProvider<T>
extends BlockFormatProviderBase<T> {
    private final DocxContext<T> myDocx;
    private final BigInteger myBefore;
    private final BigInteger myAfter;
    private final BigInteger myLeftInd;

    public QuoteBlockFormatProvider(DocxContext<T> docx, int level) {
        super(docx, "Quotations");
        BigInteger after;
        BigInteger before;
        BigInteger left;
        Style style = docx.getStyle("Quotations");
        if (style != null) {
            left = docx.getHelper().safeIndLeft((PPrBase)style.getPPr(), 240L);
            before = docx.getHelper().safeSpacingBefore(style.getPPr());
            after = docx.getHelper().safeSpacingAfter(style.getPPr());
        } else {
            left = BigInteger.valueOf(240L);
            before = BigInteger.ZERO;
            after = BigInteger.ZERO;
        }
        BigInteger quoteLevel = BigInteger.valueOf(level);
        BigInteger leftInd = left.multiply(quoteLevel);
        this.myDocx = docx;
        this.myBefore = before;
        this.myAfter = after;
        this.myLeftInd = leftInd;
    }

    @Override
    public void open() {
        super.close();
        this.myDocx.addBlankLine(this.myBefore, "Normal");
    }

    @Override
    public void close() {
        this.myDocx.addBlankLine(this.myAfter, "Normal");
        super.close();
    }

    @Override
    public void adjustPPrForFormatting(PPr pPr) {
        Object currentNode;
        CTBorder leftBorder;
        BigInteger newLeftInd = this.myDocx.getHelper().safeIndLeft((PPrBase)pPr);
        PPr styledPPr = this.myDocx.getHelper().getExplicitPPr(pPr);
        if (styledPPr.getPBdr() != null && newLeftInd != null && newLeftInd.compareTo(this.myLeftInd) > 0 && (leftBorder = styledPPr.getPBdr().getLeft()).getSpace() != null && leftBorder.getSpace().compareTo(BigInteger.ZERO) > 0 && (currentNode = this.myDocx.getContextFrame()) instanceof Paragraph) {
            boolean bl = false;
        }
    }
}

