/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.docx.converter.util;

import com.vladsch.flexmark.docx.converter.util.BlockFormatProviderBase;
import com.vladsch.flexmark.docx.converter.util.DocxContext;
import java.math.BigInteger;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.Style;

public class FencedCodeBlockFormatProvider<T>
extends BlockFormatProviderBase<T> {
    private final DocxContext<T> myDocx;
    private final BigInteger myBefore;
    private final BigInteger myAfter;

    public FencedCodeBlockFormatProvider(DocxContext<T> docx) {
        super(docx, "PreformattedText");
        BigInteger after;
        BigInteger before;
        Style paragraphStyle = docx.getStyle("PreformattedText");
        if (paragraphStyle != null) {
            before = docx.getHelper().safeSpacingBefore(paragraphStyle.getPPr());
            after = docx.getHelper().safeSpacingAfter(paragraphStyle.getPPr());
        } else {
            before = BigInteger.ZERO;
            after = BigInteger.ZERO;
        }
        this.myDocx = docx;
        this.myBefore = before;
        this.myAfter = after;
    }

    @Override
    public void open() {
        super.open();
        this.myDocx.addBlankLine(this.myBefore, "Normal");
    }

    @Override
    public void close() {
        this.myDocx.addBlankLine(this.myAfter, "Normal");
        super.close();
    }

    @Override
    public void getPPr(PPr pPr) {
        this.myDocx.getHelper().ensureSpacing((PPrBase)pPr);
        PPrBase.Spacing spacing = pPr.getSpacing();
        spacing.setBefore(BigInteger.ZERO);
        spacing.setAfter(BigInteger.ZERO);
        super.getPPr(pPr);
    }
}

