/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.core.test.util;

import com.vladsch.flexmark.core.test.util.FormatterTranslationSpecTestBase;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.test.util.FlexmarkSpecExampleRenderer;
import com.vladsch.flexmark.test.util.SpecExampleRenderer;
import com.vladsch.flexmark.test.util.TestUtils;
import com.vladsch.flexmark.test.util.spec.SpecExample;
import com.vladsch.flexmark.util.ast.IParse;
import com.vladsch.flexmark.util.ast.IRender;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.format.TrackedOffset;
import com.vladsch.flexmark.util.misc.Pair;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatterSpecTest
extends FormatterTranslationSpecTestBase {
    public FormatterSpecTest(@NotNull SpecExample example, @Nullable Map<String, ? extends DataHolder> optionMap, DataHolder ... defaultOptions) {
        super(example, optionMap, defaultOptions);
    }

    @NotNull
    public SpecExampleRenderer getSpecExampleRenderer(@NotNull SpecExample example, @Nullable DataHolder exampleOptions) {
        DataHolder combinedOptions = FormatterSpecTest.aggregate((DataHolder)this.myDefaultOptions, (DataHolder)exampleOptions);
        return new FlexmarkSpecExampleRenderer(example, combinedOptions, (IParse)Parser.builder((DataHolder)combinedOptions).build(), (IRender)Formatter.builder((DataHolder)combinedOptions).build(), true){
            @NotNull
            List<TrackedOffset> trackedOffsets;
            BasedSequence trackedSequence;
            BasedSequence originalSequence;
            {
                this.trackedOffsets = Collections.emptyList();
            }

            public void parse(CharSequence input) {
                this.originalSequence = BasedSequence.of((CharSequence)input);
                Pair extractMarkup = TestUtils.extractMarkup((BasedSequence)this.originalSequence);
                this.trackedSequence = (BasedSequence)extractMarkup.getFirst();
                super.parse((CharSequence)this.trackedSequence.toString());
                if (((int[])extractMarkup.getSecond()).length > 0) {
                    this.trackedOffsets = new ArrayList<TrackedOffset>(((int[])extractMarkup.getSecond()).length);
                    char c = ((Character)FormatterTranslationSpecTestBase.EDIT_OP_CHAR.get(this.myOptions)).charValue();
                    int editOp = (Integer)FormatterTranslationSpecTestBase.EDIT_OP.get(this.myOptions);
                    for (int offset : (int[])extractMarkup.getSecond()) {
                        TrackedOffset trackedOffset = TrackedOffset.track((int)offset, (editOp != 0 && c == ' ' ? 1 : 0) != 0, (editOp > 0 ? 1 : 0) != 0, (editOp < 0 ? 1 : 0) != 0);
                        trackedOffset.setSpacesBefore(this.trackedSequence.getBaseSequence().countTrailingSpaceTab(offset));
                        trackedOffset.setSpacesAfter(this.trackedSequence.getBaseSequence().countLeadingSpaceTab(offset));
                        this.trackedOffsets.add(trackedOffset);
                    }
                    Formatter.TRACKED_SEQUENCE.set((MutableDataHolder)this.getDocument().getDocument(), (Object)this.trackedSequence);
                    Formatter.TRACKED_OFFSETS.set((MutableDataHolder)this.getDocument().getDocument(), this.trackedOffsets);
                    Formatter.RESTORE_TRACKED_SPACES.set((MutableDataHolder)this.getDocument().getDocument(), (Object)((Boolean)Formatter.RESTORE_TRACKED_SPACES.get(this.myOptions)));
                }
                Formatter.DOCUMENT_FIRST_PREFIX.set((MutableDataHolder)this.getDocument().getDocument(), (Object)((CharSequence)Formatter.DOCUMENT_FIRST_PREFIX.get(this.myOptions)));
                Formatter.DOCUMENT_PREFIX.set((MutableDataHolder)this.getDocument().getDocument(), (Object)((CharSequence)Formatter.DOCUMENT_PREFIX.get(this.myOptions)));
            }

            @NotNull
            protected String renderHtml() {
                if (this.trackedOffsets.isEmpty() && !((Boolean)FormatterTranslationSpecTestBase.SHOW_LINE_RANGES.get(this.myOptions)).booleanValue()) {
                    return this.getRenderer().render(this.getDocument());
                }
                if (((Boolean)SharedDataKeys.RUNNING_TESTS.get(this.myOptions)).booleanValue()) {
                    System.out.printf("%s:%d%n", this.myExample.getSection(), this.myExample.getExampleNumber());
                }
                SequenceBuilder builder = this.getDocument().getChars().getBuilder();
                this.getRenderer().render(this.getDocument(), (Appendable)builder);
                String html = builder.toString();
                List trackedOffsetList = (List)Formatter.TRACKED_OFFSETS.get((DataHolder)this.getDocument().getDocument());
                assert (trackedOffsetList.isEmpty() || trackedOffsetList == this.trackedOffsets);
                int[] offsets = new int[this.trackedOffsets.size()];
                int i = 0;
                for (TrackedOffset trackedOffset : this.trackedOffsets) {
                    if (trackedOffset.isResolved()) {
                        offsets[i++] = trackedOffset.getIndex();
                        continue;
                    }
                    System.out.println(String.format("Offset %s is not resolved", trackedOffset.toString()));
                }
                if (i < offsets.length) {
                    offsets = Arrays.copyOf(offsets, i);
                }
                String result = TestUtils.insertCaretMarkup((BasedSequence)BasedSequence.of((CharSequence)html), (int[])offsets).toString();
                if (((Boolean)FormatterTranslationSpecTestBase.SHOW_LINE_RANGES.get(this.myOptions)).booleanValue()) {
                    StringBuilder out = new StringBuilder();
                    out.append(result);
                    if (this.trackedSequence == this.getDocument().getDocument().getChars()) {
                        TestUtils.appendBanner((StringBuilder)out, (String)TestUtils.bannerText((String)"Ranges"), (boolean)false);
                        out.append(builder.toStringWithRanges(false));
                    } else {
                        if (!this.trackedOffsets.isEmpty()) {
                            TestUtils.appendBanner((StringBuilder)out, (String)TestUtils.bannerText((String)"Tracked Offsets"), (boolean)false);
                            int i1 = 0;
                            for (TrackedOffset trackedOffset1 : this.trackedOffsets) {
                                out.append("[").append(i1).append("]: ").append(trackedOffset1.toString()).append("\n");
                                ++i1;
                            }
                        }
                        TestUtils.appendBanner((StringBuilder)out, (String)TestUtils.bannerText((String)"Ranges"), (!this.trackedOffsets.isEmpty() ? 1 : 0) != 0);
                        BasedSequence sequence = builder.toSequence(this.trackedSequence);
                        out.append(((SequenceBuilder)sequence.getBuilder().append((CharSequence)sequence)).toStringWithRanges(false)).append("\n");
                        TestUtils.appendBanner((StringBuilder)out, (String)TestUtils.bannerText((String)"Segments"), (boolean)false);
                        out.append(((SequenceBuilder)sequence.getBuilder().append((CharSequence)sequence)).getSegmentBuilder().toString());
                    }
                    result = out.toString();
                }
                return result;
            }
        };
    }
}

