/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.HeaderIdGeneratorFactory;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.html.renderer.LinkResolverContext;
import java.util.HashMap;

public class HeaderIdGenerator
implements HtmlIdGenerator {
    @Override
    public void generateIds(Document document) {
        final HashMap headerBaseIds = new HashMap();
        final boolean resolveDupes = HtmlRenderer.HEADER_ID_GENERATOR_RESOLVE_DUPES.getFrom(document);
        final String toDashChars = HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.getFrom(document);
        final String nonDashChars = HtmlRenderer.HEADER_ID_GENERATOR_NON_DASH_CHARS.getFrom(document);
        final boolean noDupedDashes = HtmlRenderer.HEADER_ID_GENERATOR_NO_DUPED_DASHES.getFrom(document);
        new AnchorRefTargetBlockVisitor(){

            @Override
            protected void visit(AnchorRefTarget node) {
                String text;
                if (node.getAnchorRefId().isEmpty() && !(text = node.getAnchorRefText()).isEmpty()) {
                    String baseRefId = HeaderIdGenerator.generateId(text, toDashChars, nonDashChars, noDupedDashes);
                    if (resolveDupes) {
                        if (headerBaseIds.containsKey(baseRefId)) {
                            int index = (Integer)headerBaseIds.get(baseRefId);
                            headerBaseIds.put(baseRefId, ++index);
                            baseRefId = baseRefId + "-" + index;
                        } else {
                            headerBaseIds.put(baseRefId, 0);
                        }
                    }
                    node.setAnchorRefId(baseRefId);
                }
            }
        }.visit(document);
    }

    @Override
    public String getId(Node node) {
        return node instanceof AnchorRefTarget ? ((AnchorRefTarget)((Object)node)).getAnchorRefId() : null;
    }

    public static String generateId(CharSequence headerText, String toDashChars, boolean noDupedDashes) {
        return HeaderIdGenerator.generateId(headerText, toDashChars, null, noDupedDashes);
    }

    public static String generateId(CharSequence headerText, String toDashChars, String nonDashChars, boolean noDupedDashes) {
        int iMax = headerText.length();
        StringBuilder baseRefId = new StringBuilder(iMax);
        if (toDashChars == null) {
            toDashChars = HtmlRenderer.HEADER_ID_GENERATOR_TO_DASH_CHARS.getFrom(null);
        }
        if (nonDashChars == null) {
            nonDashChars = HtmlRenderer.HEADER_ID_GENERATOR_NON_DASH_CHARS.getFrom(null);
        }
        for (int i = 0; i < iMax; ++i) {
            char c = headerText.charAt(i);
            if (HeaderIdGenerator.isAlphabetic(c)) {
                baseRefId.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isDigit(c)) {
                baseRefId.append(c);
                continue;
            }
            if (nonDashChars.indexOf(c) != -1) {
                baseRefId.append(c);
                continue;
            }
            if (toDashChars.indexOf(c) == -1 || noDupedDashes && (c != '-' || baseRefId.length() != 0) && (baseRefId.length() == 0 || baseRefId.charAt(baseRefId.length() - 1) == '-')) continue;
            baseRefId.append('-');
        }
        return baseRefId.toString();
    }

    public static boolean isAlphabetic(char c) {
        return (1086 >> Character.getType((int)c) & 1) != 0;
    }

    public static class Factory
    implements HeaderIdGeneratorFactory {
        @Override
        public HtmlIdGenerator create(LinkResolverContext context) {
            return new HeaderIdGenerator();
        }
    }
}

