/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteOptions;
import com.vladsch.flexmark.ext.footnotes.internal.FootnoteRepository;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FootnoteNodeRenderer
implements PhasedNodeRenderer {
    private final FootnoteRepository footnoteRepository;
    private final FootnoteOptions options;
    private boolean recheckUndefinedReferences;

    public FootnoteNodeRenderer(DataHolder options) {
        this.options = new FootnoteOptions(options);
        this.footnoteRepository = options.get(FootnoteExtension.FOOTNOTES);
        this.recheckUndefinedReferences = HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.getFrom(options);
        this.footnoteRepository.resolveFootnoteOrdinals();
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<Footnote>(Footnote.class, new CustomNodeRenderer<Footnote>(){

            @Override
            public void render(Footnote node, NodeRendererContext context, HtmlWriter html) {
                FootnoteNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<FootnoteBlock>(FootnoteBlock.class, new CustomNodeRenderer<FootnoteBlock>(){

            @Override
            public void render(FootnoteBlock node, NodeRendererContext context, HtmlWriter html) {
                FootnoteNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    @Override
    public Set<RenderingPhase> getRenderingPhases() {
        HashSet<RenderingPhase> set = new HashSet<RenderingPhase>();
        set.add(RenderingPhase.BODY_TOP);
        set.add(RenderingPhase.BODY_BOTTOM);
        return set;
    }

    @Override
    public void renderDocument(final NodeRendererContext context, final HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP && this.recheckUndefinedReferences) {
            final boolean[] hadNewFootnotes = new boolean[]{false};
            NodeVisitor visitor = new NodeVisitor((VisitHandler<?>[])new VisitHandler[]{new VisitHandler<Footnote>(Footnote.class, new Visitor<Footnote>(){

                @Override
                public void visit(Footnote node) {
                    FootnoteBlock footonoteBlock;
                    if (!node.isDefined() && (footonoteBlock = node.getFootnoteBlock(FootnoteNodeRenderer.this.footnoteRepository)) != null) {
                        FootnoteNodeRenderer.this.footnoteRepository.addFootnoteReference(footonoteBlock, node);
                        node.setFootnoteBlock(footonoteBlock);
                        hadNewFootnotes[0] = true;
                    }
                }
            })});
            visitor.visit(document);
            if (hadNewFootnotes[0]) {
                this.footnoteRepository.resolveFootnoteOrdinals();
            }
        }
        if (phase == RenderingPhase.BODY_BOTTOM && this.footnoteRepository.getReferencedFootnoteBlocks().size() > 0) {
            ((HtmlWriter)html.attr("class", "footnotes")).withAttr().tagIndent("div", new Runnable(){

                @Override
                public void run() {
                    html.tagVoidLine("hr");
                    html.tagIndent("ol", new Runnable(){

                        @Override
                        public void run() {
                            for (final FootnoteBlock footnoteBlock : FootnoteNodeRenderer.this.footnoteRepository.getReferencedFootnoteBlocks()) {
                                final int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
                                html.attr("id", "fn-" + footnoteOrdinal);
                                html.withAttr().tagIndent("li", new Runnable(){

                                    @Override
                                    public void run() {
                                        context.renderChildren(footnoteBlock);
                                        html.attr("href", "#fnref-" + footnoteOrdinal);
                                        if (!((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteBackLinkRefClass.isEmpty()) {
                                            html.attr("class", ((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteBackLinkRefClass);
                                        }
                                        html.withAttr().tag("a");
                                        html.raw(((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteBackRefString);
                                        html.tag("/a");
                                    }
                                });
                            }
                        }
                    });
                }
            });
        }
    }

    private void render(FootnoteBlock node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(Footnote node, NodeRendererContext context, final HtmlWriter html) {
        FootnoteBlock footnoteBlock = node.getFootnoteBlock();
        if (footnoteBlock == null) {
            html.raw("[^");
            context.renderChildren(node);
            html.raw("]");
        } else {
            final int footnoteOrdinal = footnoteBlock.getFootnoteOrdinal();
            html.attr("id", "fnref-" + footnoteOrdinal);
            html.srcPos(node.getChars()).withAttr().tag("sup", false, false, new Runnable(){

                @Override
                public void run() {
                    if (!((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteLinkRefClass.isEmpty()) {
                        html.attr("class", ((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteLinkRefClass);
                    }
                    html.attr("href", "#fn-" + footnoteOrdinal);
                    html.withAttr().tag("a");
                    html.raw(((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteRefPrefix + String.valueOf(footnoteOrdinal) + ((FootnoteNodeRenderer)FootnoteNodeRenderer.this).options.footnoteRefSuffix);
                    html.tag("/a");
                }
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        public NodeRenderer create(DataHolder options) {
            return new FootnoteNodeRenderer(options);
        }
    }
}

