/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.autolink.internal;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.DoNotDecorate;
import com.vladsch.flexmark.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.LinkNode;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;

public class AutolinkNodePostProcessor
extends NodePostProcessor {
    private final Pattern ignoredLinks;
    private LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.WWW, LinkType.EMAIL)).build();

    public AutolinkNodePostProcessor(Document document) {
        String ignoreLinks = AutolinkExtension.IGNORE_LINKS.getFrom(document);
        this.ignoredLinks = ignoreLinks.isEmpty() ? null : Pattern.compile(ignoreLinks);
    }

    public boolean isIgnoredLinkPrefix(CharSequence url) {
        if (this.ignoredLinks != null) {
            Matcher matcher = this.ignoredLinks.matcher(url);
            return matcher.matches();
        }
        return false;
    }

    @Override
    public void process(NodeTracker state, Node node) {
        BasedSequence original = node.getChars();
        ReplacedTextMapper textMapper = new ReplacedTextMapper(original);
        BasedSequence literal = Escaping.unescape(original, textMapper);
        Iterable links = this.linkExtractor.extractLinks((CharSequence)literal);
        int lastEscaped = 0;
        boolean wrapInTextBase = !(node.getParent() instanceof TextBase);
        TextBase textBase = wrapInTextBase ? null : (TextBase)node.getParent();
        for (LinkSpan link : links) {
            LinkNode linkNode;
            BasedSequence linkText = literal.subSequence(link.getBeginIndex(), link.getEndIndex()).trimEnd();
            if (this.isIgnoredLinkPrefix(linkText)) continue;
            int startOffset = textMapper.originalOffset(link.getBeginIndex());
            if (wrapInTextBase) {
                wrapInTextBase = false;
                textBase = new TextBase(original);
                node.insertBefore(textBase);
                state.nodeAdded(textBase);
            }
            if (startOffset != lastEscaped) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, startOffset);
                Text node1 = new Text(escapedChars);
                textBase.appendChild(node1);
                state.nodeAdded(node1);
            }
            Text contentNode = new Text(linkText);
            if (link.getType() == LinkType.EMAIL) {
                linkNode = new MailLink();
                ((MailLink)linkNode).setText(linkText);
            } else {
                linkNode = new AutoLink();
                ((AutoLink)linkNode).setText(linkText);
            }
            linkNode.setCharsFromContent();
            linkNode.appendChild(contentNode);
            textBase.appendChild(linkNode);
            state.nodeAddedWithChildren(linkNode);
            lastEscaped = textMapper.originalOffset(link.getBeginIndex() + linkText.length());
        }
        if (lastEscaped > 0) {
            if (lastEscaped != original.length()) {
                BasedSequence escapedChars = original.subSequence(lastEscaped, original.length());
                Text node1 = new Text(escapedChars);
                textBase.appendChild(node1);
                state.nodeAdded(node1);
            }
            node.unlink();
            state.nodeRemoved(node);
        }
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory() {
            super(false);
            this.addNodeWithExclusions(Text.class, DoNotDecorate.class, DoNotLinkDecorate.class);
        }

        @Override
        public NodePostProcessor create(Document document) {
            return new AutolinkNodePostProcessor(document);
        }
    }
}

