/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.abbreviation.internal;

import com.vladsch.flexmark.ext.abbreviation.Abbreviation;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationBlock;
import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.abbreviation.internal.AbbreviationRepository;
import com.vladsch.flexmark.ext.abbreviation.internal.FormatOptions;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.internal.MarkdownWriter;
import com.vladsch.flexmark.formatter.internal.NodeFormatter;
import com.vladsch.flexmark.formatter.internal.NodeFormatterContext;
import com.vladsch.flexmark.formatter.internal.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.internal.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.internal.NodeRepositoryFormatter;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class AbbreviationNodeFormatter
extends NodeRepositoryFormatter<AbbreviationRepository, AbbreviationBlock, Abbreviation> {
    private final FormatOptions options;

    public AbbreviationNodeFormatter(DataHolder options) {
        super(options);
        this.options = new FormatOptions(options);
    }

    @Override
    public AbbreviationRepository getRepository(DataHolder options) {
        return AbbreviationExtension.ABBREVIATIONS.getFrom(options);
    }

    @Override
    public ElementPlacement getReferencePlacement() {
        return this.options.abbreviationsPlacement;
    }

    @Override
    public ElementPlacementSort getReferenceSort() {
        return this.options.abbreviationsSort;
    }

    @Override
    public void renderReferenceBlock(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append(node.getOpeningMarker()).append(node.getText()).append(node.getClosingMarker()).append(' ');
        markdown.append(node.getAbbreviation()).line();
    }

    @Override
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler<Abbreviation>(Abbreviation.class, new CustomNodeFormatter<Abbreviation>(){

            @Override
            public void render(Abbreviation node, NodeFormatterContext context, MarkdownWriter markdown) {
                AbbreviationNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler<AbbreviationBlock>(AbbreviationBlock.class, new CustomNodeFormatter<AbbreviationBlock>(){

            @Override
            public void render(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                AbbreviationNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    @Override
    public Set<Class<?>> getNodeClasses() {
        if (this.options.abbreviationsPlacement != ElementPlacement.AS_IS && this.options.abbreviationsSort != ElementPlacementSort.SORT_UNUSED_LAST) {
            return null;
        }
        return new HashSet(Arrays.asList(Abbreviation.class));
    }

    private void render(AbbreviationBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.renderReference(node, context, markdown);
    }

    private void render(Abbreviation node, NodeFormatterContext context, MarkdownWriter markdown) {
        markdown.append(node.getChars());
    }

    public static class Factory
    implements NodeFormatterFactory {
        @Override
        public NodeFormatter create(DataHolder options) {
            return new AbbreviationNodeFormatter(options);
        }
    }
}

