/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.util;

import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JndiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JndiUtils.class);

    private JndiUtils() {
        throw new UnsupportedOperationException("JndiUtils is not instantiable!");
    }

    public static <T> T lookup(String name) {
        InitialContext initialContext = JndiUtils.initialContext();
        try {
            Object object = initialContext.lookup(name);
            if (object == null) {
                throw new NameNotFoundException(name + " was found but is null");
            }
            Object object2 = object;
            return (T)object2;
        }
        catch (NameNotFoundException e) {
            throw new IllegalArgumentException(name + " was not found in JNDI", e);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("JNDI lookup failed", e);
        }
        finally {
            JndiUtils.closeContext(initialContext);
        }
    }

    protected static InitialContext initialContext() {
        try {
            return new InitialContext();
        }
        catch (NamingException e) {
            throw new IllegalStateException("Can't create the InitialContext object");
        }
    }

    protected static void closeContext(InitialContext initialContext) {
        if (initialContext != null) {
            try {
                initialContext.close();
            }
            catch (NamingException e) {
                LOGGER.debug("Can't close InitialContext", (Throwable)e);
            }
        }
    }
}

