/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.strategy;

import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.connection.ConnectionRequestContext;
import com.vladmihalcea.flexypool.exception.ConnectionAcquisitionTimeoutException;
import com.vladmihalcea.flexypool.metric.Histogram;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.strategy.AbstractConnectionAcquisitionStrategy;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquisitionStrategyFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncrementPoolOnTimeoutConnectionAcquisitionStrategy<T extends DataSource>
extends AbstractConnectionAcquisitionStrategy {
    public static final String MAX_POOL_SIZE_HISTOGRAM = "maxPoolSizeHistogram";
    public static final String OVERGROW_POOL_SIZE_HISTOGRAM = "overgrowPoolSizeHistogram";
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementPoolOnTimeoutConnectionAcquisitionStrategy.class);
    private final Lock lock = new ReentrantLock();
    private final int maxOvergrowPoolSize;
    private final int timeoutMillis;
    private AtomicLong overgrowPoolSize = new AtomicLong();
    private final Histogram maxPoolSizeHistogram;
    private final Histogram overgrowPoolSizeHistogram;
    private final PoolAdapter poolAdapter;

    private IncrementPoolOnTimeoutConnectionAcquisitionStrategy(ConfigurationProperties<? extends DataSource, Metrics, PoolAdapter> configurationProperties, int maxOvergrowPoolSize, int timeoutMillis) {
        super(configurationProperties);
        this.maxOvergrowPoolSize = maxOvergrowPoolSize;
        this.timeoutMillis = timeoutMillis;
        this.maxPoolSizeHistogram = configurationProperties.getMetrics().histogram(MAX_POOL_SIZE_HISTOGRAM);
        this.overgrowPoolSizeHistogram = configurationProperties.getMetrics().histogram(OVERGROW_POOL_SIZE_HISTOGRAM);
        this.maxPoolSizeHistogram.update(configurationProperties.getPoolAdapter().getMaxPoolSize());
        this.poolAdapter = configurationProperties.getPoolAdapter();
    }

    @Override
    public Connection getConnection(ConnectionRequestContext requestContext) throws SQLException {
        while (true) {
            int expectingMaxSize = this.poolAdapter.getMaxPoolSize();
            try {
                long startNanos = System.nanoTime();
                Connection connection = this.getConnectionFactory().getConnection(requestContext);
                long endNanos = System.nanoTime();
                long connectionAcquisitionDurationMillis = TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos);
                if (connectionAcquisitionDurationMillis > (long)this.timeoutMillis) {
                    LOGGER.warn("The connection was acquired in {} millis (timeoutMillis was set to {})", (Object)connectionAcquisitionDurationMillis, (Object)this.timeoutMillis);
                    int maxPoolSize = this.poolAdapter.getMaxPoolSize();
                    if (maxPoolSize < this.maxOvergrowPoolSize) {
                        if (!this.incrementPoolSize(expectingMaxSize)) {
                            LOGGER.warn("Can't increase pool size because it has already overgrown to its max size of {}", (Object)this.maxOvergrowPoolSize);
                        }
                    } else {
                        LOGGER.info("The pool size has already overgrown to its max size of {}", (Object)maxPoolSize);
                    }
                }
                return connection;
            }
            catch (ConnectionAcquisitionTimeoutException e) {
                if (this.incrementPoolSize(expectingMaxSize)) continue;
                LOGGER.warn("Can't acquire connection due to timeout at the connection pool level, and the pool size has already overgrown to its max size of {}", (Object)this.maxOvergrowPoolSize);
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean incrementPoolSize(int expectingMaxSize) {
        int maxSize;
        long currentOvergrowPoolSize;
        block8: {
            boolean poolSizeChanged = false;
            try {
                this.lock.lockInterruptibly();
                int currentMaxSize = this.poolAdapter.getMaxPoolSize();
                if (currentMaxSize > expectingMaxSize) {
                    LOGGER.info("The pool size was changed by a different thread (the expected value was {}, but the current value is {})", (Object)expectingMaxSize, (Object)currentMaxSize);
                    boolean bl = true;
                    return bl;
                }
                if (currentMaxSize < this.maxOvergrowPoolSize) {
                    currentOvergrowPoolSize = this.overgrowPoolSize.incrementAndGet();
                    this.poolAdapter.setMaxPoolSize(++currentMaxSize);
                    poolSizeChanged = true;
                    maxSize = currentMaxSize;
                    break block8;
                }
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                boolean bl = poolSizeChanged;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        LOGGER.info("The pool size changed from {} to {} connections", (Object)expectingMaxSize, (Object)maxSize);
        this.maxPoolSizeHistogram.update(maxSize);
        this.overgrowPoolSizeHistogram.update(currentOvergrowPoolSize);
        return true;
    }

    public String toString() {
        return "IncrementPoolOnTimeoutConnectionAcquiringStrategy{maxOvergrowPoolSize=" + this.maxOvergrowPoolSize + "}";
    }

    public static class Factory<T extends DataSource>
    implements ConnectionAcquisitionStrategyFactory<IncrementPoolOnTimeoutConnectionAcquisitionStrategy, T> {
        private final int maxOvergrowPoolSize;
        private final int timeoutMillis;

        public Factory(int maxOvergrowPoolSize, int timeoutMillis) {
            this.maxOvergrowPoolSize = maxOvergrowPoolSize;
            this.timeoutMillis = timeoutMillis;
        }

        public Factory(int maxOvergrowPoolSize) {
            this(maxOvergrowPoolSize, Integer.MAX_VALUE);
        }

        @Override
        public IncrementPoolOnTimeoutConnectionAcquisitionStrategy newInstance(ConfigurationProperties<T, Metrics, PoolAdapter<T>> configurationProperties) {
            return new IncrementPoolOnTimeoutConnectionAcquisitionStrategy(configurationProperties, this.maxOvergrowPoolSize, this.timeoutMillis);
        }
    }
}

