/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.config;

import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.adaptor.PoolAdapterFactory;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.connection.ConnectionDecoratorFactoryResolver;
import com.vladmihalcea.flexypool.connection.ConnectionProxyFactory;
import com.vladmihalcea.flexypool.event.EventListenerResolver;
import com.vladmihalcea.flexypool.event.EventPublisher;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.metric.MetricsFactoryResolver;
import com.vladmihalcea.flexypool.strategy.DefaultNamingStrategy;
import com.vladmihalcea.flexypool.strategy.MetricNamingStrategy;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public final class FlexyPoolConfiguration<T extends DataSource>
extends ConfigurationProperties<T, Metrics, PoolAdapter<T>> {
    public static final long DEFAULT_METRIC_LOG_REPORTER_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final T targetDataSource;
    private Metrics metrics;
    private PoolAdapter<T> poolAdapter;
    private ConnectionProxyFactory connectionProxyFactory;

    private FlexyPoolConfiguration(String uniqueName, T targetDataSource, EventPublisher eventPublisher) {
        super(uniqueName, eventPublisher);
        this.targetDataSource = targetDataSource;
    }

    @Override
    public T getTargetDataSource() {
        return this.targetDataSource;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public PoolAdapter<T> getPoolAdapter() {
        return this.poolAdapter;
    }

    @Override
    public ConnectionProxyFactory getConnectionProxyFactory() {
        return this.connectionProxyFactory;
    }

    public static class Builder<T extends DataSource> {
        private final String uniqueName;
        private final T targetDataSource;
        private final PoolAdapterFactory<T> poolAdapterFactory;
        private MetricsFactory metricsFactory;
        private ConnectionProxyFactory connectionProxyFactory = ConnectionDecoratorFactoryResolver.INSTANCE.resolve();
        private boolean jmxEnabled = true;
        private boolean jmxAutoStart = false;
        private long metricLogReporterMillis = DEFAULT_METRIC_LOG_REPORTER_MILLIS;
        private MetricNamingStrategy metricNamingStrategy = new DefaultNamingStrategy();
        private EventListenerResolver eventListenerResolver;
        private long connectionAcquisitionTimeThresholdMillis = Long.MAX_VALUE;
        private long connectionLeaseTimeThresholdMillis = Long.MAX_VALUE;

        public Builder(String uniqueName, T targetDataSource, PoolAdapterFactory<T> poolAdapterFactory) {
            this.uniqueName = uniqueName;
            this.targetDataSource = targetDataSource;
            this.poolAdapterFactory = poolAdapterFactory;
        }

        public Builder<T> setMetricsFactory(MetricsFactory metricsFactory) {
            this.metricsFactory = metricsFactory;
            return this;
        }

        public Builder<T> setConnectionProxyFactory(ConnectionProxyFactory connectionProxyFactory) {
            this.connectionProxyFactory = connectionProxyFactory;
            return this;
        }

        public Builder<T> setJmxEnabled(boolean enableJmx) {
            this.jmxEnabled = enableJmx;
            return this;
        }

        public Builder<T> setJmxAutoStart(boolean jmxAutoStart) {
            this.jmxAutoStart = jmxAutoStart;
            return this;
        }

        public Builder<T> setMetricLogReporterMillis(long metricLogReporterMillis) {
            this.metricLogReporterMillis = metricLogReporterMillis;
            return this;
        }

        public Builder<T> setMetricNamingUniqueName(MetricNamingStrategy metricNamingStrategy) {
            this.metricNamingStrategy = metricNamingStrategy;
            return this;
        }

        public Builder<T> setEventListenerResolver(EventListenerResolver eventListenerResolver) {
            this.eventListenerResolver = eventListenerResolver;
            return this;
        }

        public Builder<T> setConnectionAcquisitionTimeThresholdMillis(Long connectionAcquisitionTimeThresholdMillis) {
            if (connectionAcquisitionTimeThresholdMillis != null) {
                this.connectionAcquisitionTimeThresholdMillis = connectionAcquisitionTimeThresholdMillis;
            }
            return this;
        }

        public Builder<T> setConnectionLeaseTimeThresholdMillis(Long connectionLeaseTimeThresholdMillis) {
            if (connectionLeaseTimeThresholdMillis != null) {
                this.connectionLeaseTimeThresholdMillis = connectionLeaseTimeThresholdMillis;
            }
            return this;
        }

        public FlexyPoolConfiguration<T> build() {
            EventPublisher eventPublisher = EventPublisher.newInstance(this.eventListenerResolver);
            FlexyPoolConfiguration<T> configuration = new FlexyPoolConfiguration<T>(this.uniqueName, this.targetDataSource, eventPublisher);
            ((FlexyPoolConfiguration)configuration).setJmxEnabled(this.jmxEnabled);
            configuration.setJmxAutoStart(this.jmxAutoStart);
            ((FlexyPoolConfiguration)configuration).setMetricLogReporterMillis(this.metricLogReporterMillis);
            configuration.setMetricNamingStrategy(this.metricNamingStrategy);
            configuration.setConnectionAcquisitionTimeThresholdMillis(this.connectionAcquisitionTimeThresholdMillis);
            configuration.setConnectionLeaseTimeThresholdMillis(this.connectionLeaseTimeThresholdMillis);
            if (this.metricsFactory == null) {
                this.metricsFactory = MetricsFactoryResolver.INSTANCE.resolve();
            }
            configuration.metrics = this.metricsFactory.newInstance(configuration);
            configuration.poolAdapter = this.poolAdapterFactory.newInstance(configuration);
            configuration.connectionProxyFactory = this.connectionProxyFactory;
            return configuration;
        }
    }
}

