/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool;

import com.vladmihalcea.flexypool.adaptor.DataSourcePoolAdapter;
import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.adaptor.PoolAdapterFactory;
import com.vladmihalcea.flexypool.config.FlexyPoolConfiguration;
import com.vladmihalcea.flexypool.config.PropertyLoader;
import com.vladmihalcea.flexypool.connection.ConnectionPoolCallback;
import com.vladmihalcea.flexypool.connection.ConnectionProxyFactory;
import com.vladmihalcea.flexypool.connection.ConnectionRequestContext;
import com.vladmihalcea.flexypool.connection.Credentials;
import com.vladmihalcea.flexypool.event.ConnectionAcquisitionTimeThresholdExceededEvent;
import com.vladmihalcea.flexypool.event.ConnectionLeaseTimeThresholdExceededEvent;
import com.vladmihalcea.flexypool.event.EventListenerResolver;
import com.vladmihalcea.flexypool.event.EventPublisher;
import com.vladmihalcea.flexypool.exception.ConnectionAcquisitionException;
import com.vladmihalcea.flexypool.exception.ConnectionAcquisitionTimeoutException;
import com.vladmihalcea.flexypool.lifecycle.LifeCycleCallback;
import com.vladmihalcea.flexypool.metric.Histogram;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.metric.Timer;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquisitionStrategy;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquisitionStrategyFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexyPoolDataSource<T extends DataSource>
implements DataSource,
LifeCycleCallback,
ConnectionPoolCallback,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexyPoolDataSource.class);
    public static final String OVERALL_CONNECTION_ACQUISITION_MILLIS = "overallConnectionAcquisitionMillis";
    public static final String CONCURRENT_CONNECTIONS_HISTOGRAM = "concurrentConnectionsHistogram";
    public static final String CONCURRENT_CONNECTION_REQUESTS_HISTOGRAM = "concurrentConnectionRequestsHistogram";
    public static final String CONNECTION_LEASE_MILLIS = "connectionLeaseMillis";
    private final String uniqueName;
    private final PoolAdapter<T> poolAdapter;
    private final T targetDataSource;
    private final Metrics metrics;
    private final Timer connectionAcquisitionTotalTimer;
    private final Histogram concurrentConnectionCountHistogram;
    private final Histogram concurrentConnectionRequestCountHistogram;
    private final Timer connectionLeaseTimer;
    private final ConnectionProxyFactory connectionProxyFactory;
    private final Collection<ConnectionAcquisitionStrategy> connectionAcquiringStrategies = new LinkedHashSet<ConnectionAcquisitionStrategy>();
    private AtomicLong concurrentConnectionCount = new AtomicLong();
    private AtomicLong concurrentConnectionRequestCount = new AtomicLong();
    private final EventPublisher eventPublisher;
    private final long connectionAcquisitionTimeThresholdMillis;
    private final long connectionLeaseTimeThresholdMillis;

    public FlexyPoolDataSource(FlexyPoolConfiguration<T> configuration, ConnectionAcquisitionStrategyFactory<? extends ConnectionAcquisitionStrategy, T> ... connectionAcquiringStrategyFactories) {
        this(configuration, Arrays.asList(connectionAcquiringStrategyFactories));
    }

    public FlexyPoolDataSource() {
        this(new ConfigurationLoader().getFlexyPoolDataSourceConfiguration());
    }

    public FlexyPoolDataSource(T targetDataSource) {
        this(new ConfigurationLoader<T>(targetDataSource).getFlexyPoolDataSourceConfiguration());
    }

    public FlexyPoolDataSource(T targetDataSource, Properties overridingProperties) {
        this(new ConfigurationLoader<T>(targetDataSource, overridingProperties).getFlexyPoolDataSourceConfiguration());
    }

    private FlexyPoolDataSource(FlexyPoolConfiguration<T> configuration, List<ConnectionAcquisitionStrategyFactory<? extends ConnectionAcquisitionStrategy, T>> connectionAcquiringStrategyFactories) {
        this.uniqueName = configuration.getUniqueName();
        this.poolAdapter = configuration.getPoolAdapter();
        this.targetDataSource = this.poolAdapter.getTargetDataSource();
        this.metrics = configuration.getMetrics();
        this.connectionAcquisitionTotalTimer = this.metrics.timer(OVERALL_CONNECTION_ACQUISITION_MILLIS);
        this.concurrentConnectionCountHistogram = this.metrics.histogram(CONCURRENT_CONNECTIONS_HISTOGRAM);
        this.concurrentConnectionRequestCountHistogram = this.metrics.histogram(CONCURRENT_CONNECTION_REQUESTS_HISTOGRAM);
        this.connectionLeaseTimer = this.metrics.timer(CONNECTION_LEASE_MILLIS);
        this.connectionProxyFactory = configuration.getConnectionProxyFactory();
        if (connectionAcquiringStrategyFactories.isEmpty()) {
            LOGGER.info("FlexyPool is not using any strategy!");
        }
        for (ConnectionAcquisitionStrategyFactory<ConnectionAcquisitionStrategy, T> connectionAcquiringStrategyFactory : connectionAcquiringStrategyFactories) {
            this.connectionAcquiringStrategies.add(connectionAcquiringStrategyFactory.newInstance(configuration));
        }
        this.eventPublisher = configuration.getEventPublisher();
        this.connectionAcquisitionTimeThresholdMillis = configuration.getConnectionAcquisitionTimeThresholdMillis();
        this.connectionLeaseTimeThresholdMillis = configuration.getConnectionLeaseTimeThresholdMillis();
    }

    private FlexyPoolDataSource(FlexyPoolDataSourceConfiguration<T> flexyPoolDataSourceConfiguration) {
        this(flexyPoolDataSourceConfiguration.getConfiguration(), flexyPoolDataSourceConfiguration.getConnectionAcquiringStrategyFactories());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(new ConnectionRequestContext.Builder().build());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection(new ConnectionRequestContext.Builder().setCredentials(new Credentials(username, password)).build());
    }

    public T getTargetDataSource() {
        return this.targetDataSource;
    }

    private Connection getConnection(ConnectionRequestContext context) throws SQLException {
        block11: {
            Connection connection;
            this.concurrentConnectionRequestCountHistogram.update(this.concurrentConnectionRequestCount.incrementAndGet());
            long startNanos = System.nanoTime();
            try {
                Connection connection2 = null;
                if (!this.connectionAcquiringStrategies.isEmpty()) {
                    for (ConnectionAcquisitionStrategy strategy : this.connectionAcquiringStrategies) {
                        try {
                            connection2 = strategy.getConnection(context);
                            break;
                        }
                        catch (ConnectionAcquisitionTimeoutException e) {
                            LOGGER.warn("Couldn't retrieve connection from strategy {} with context {}", (Object)strategy, (Object)context);
                        }
                    }
                } else {
                    connection2 = this.poolAdapter.getConnection(context);
                }
                if (connection2 == null) break block11;
                connection = this.connectionProxyFactory.newInstance(connection2, this);
            }
            catch (Throwable throwable) {
                long endNanos = System.nanoTime();
                long acquisitionDurationMillis = TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos);
                this.connectionAcquisitionTotalTimer.update(acquisitionDurationMillis, TimeUnit.MILLISECONDS);
                this.concurrentConnectionRequestCountHistogram.update(this.concurrentConnectionRequestCount.decrementAndGet());
                if (acquisitionDurationMillis > this.connectionAcquisitionTimeThresholdMillis) {
                    this.eventPublisher.publish(new ConnectionAcquisitionTimeThresholdExceededEvent(this.uniqueName, this.connectionAcquisitionTimeThresholdMillis, acquisitionDurationMillis));
                    LOGGER.info("Connection acquired in {} millis, while threshold is set to {} in {} FlexyPoolDataSource", new Object[]{acquisitionDurationMillis, this.connectionAcquisitionTimeThresholdMillis, this.uniqueName});
                }
                throw throwable;
            }
            long endNanos = System.nanoTime();
            long acquisitionDurationMillis = TimeUnit.NANOSECONDS.toMillis(endNanos - startNanos);
            this.connectionAcquisitionTotalTimer.update(acquisitionDurationMillis, TimeUnit.MILLISECONDS);
            this.concurrentConnectionRequestCountHistogram.update(this.concurrentConnectionRequestCount.decrementAndGet());
            if (acquisitionDurationMillis > this.connectionAcquisitionTimeThresholdMillis) {
                this.eventPublisher.publish(new ConnectionAcquisitionTimeThresholdExceededEvent(this.uniqueName, this.connectionAcquisitionTimeThresholdMillis, acquisitionDurationMillis));
                LOGGER.info("Connection acquired in {} millis, while threshold is set to {} in {} FlexyPoolDataSource", new Object[]{acquisitionDurationMillis, this.connectionAcquisitionTimeThresholdMillis, this.uniqueName});
            }
            return connection;
        }
        throw new ConnectionAcquisitionException("Couldn't acquire connection for current strategies: " + this.connectionAcquiringStrategies);
    }

    @Override
    public void acquireConnection() {
        this.concurrentConnectionCountHistogram.update(this.concurrentConnectionCount.incrementAndGet());
    }

    @Override
    public void releaseConnection(long leaseDurationNanos) {
        this.concurrentConnectionCountHistogram.update(this.concurrentConnectionCount.decrementAndGet());
        long leaseDurationMillis = TimeUnit.NANOSECONDS.toMillis(leaseDurationNanos);
        this.connectionLeaseTimer.update(leaseDurationMillis, TimeUnit.MILLISECONDS);
        if (leaseDurationMillis > this.connectionLeaseTimeThresholdMillis) {
            this.eventPublisher.publish(new ConnectionLeaseTimeThresholdExceededEvent(this.uniqueName, this.connectionLeaseTimeThresholdMillis, leaseDurationMillis));
            LOGGER.info("Connection leased for {} millis, while threshold is set to {} in {} FlexyPoolDataSource", new Object[]{leaseDurationMillis, this.connectionLeaseTimeThresholdMillis, this.uniqueName});
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.targetDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.targetDataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.targetDataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.targetDataSource.setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.targetDataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.targetDataSource.isWrapperFor(iface);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return java.util.logging.Logger.getLogger("global");
    }

    @Override
    public void start() {
        this.metrics.start();
    }

    @Override
    public void stop() {
        this.metrics.stop();
    }

    @Override
    public void close() throws IOException {
        this.metrics.stop();
        if (this.targetDataSource instanceof Closeable) {
            ((Closeable)this.targetDataSource).close();
        }
    }

    private static class ConfigurationLoader<D extends DataSource> {
        private final PropertyLoader propertyLoader;
        private final FlexyPoolDataSourceConfiguration<D> flexyPoolDataSourceConfiguration;

        public ConfigurationLoader() {
            this.propertyLoader = new PropertyLoader();
            Object dataSource = this.propertyLoader.getDataSource();
            this.flexyPoolDataSourceConfiguration = this.init(dataSource);
        }

        public ConfigurationLoader(D dataSource) {
            this.propertyLoader = new PropertyLoader();
            this.flexyPoolDataSourceConfiguration = this.init(dataSource);
        }

        public ConfigurationLoader(D dataSource, Properties overridingProperties) {
            this.propertyLoader = new PropertyLoader(overridingProperties);
            this.flexyPoolDataSourceConfiguration = this.init(dataSource);
        }

        private FlexyPoolDataSourceConfiguration<D> init(D dataSource) {
            return new FlexyPoolDataSourceConfiguration<D>(this.configuration(dataSource), this.connectionAcquiringStrategyFactories());
        }

        private FlexyPoolConfiguration<D> configuration(D dataSource) {
            String uniqueName = this.propertyLoader.getUniqueName();
            PoolAdapterFactory<Object> poolAdapterFactory = this.propertyLoader.getPoolAdapterFactory();
            MetricsFactory metricsFactory = this.propertyLoader.getMetricsFactory();
            ConnectionProxyFactory connectionProxyFactory = this.propertyLoader.getConnectionProxyFactory();
            Integer metricLogReporterMillis = this.propertyLoader.getMetricLogReporterMillis();
            Boolean jmxEnabled = this.propertyLoader.isJmxEnabled();
            Boolean jmxAutoStart = this.propertyLoader.isJmxAutoStart();
            EventListenerResolver eventListenerResolver = this.propertyLoader.getEventListenerResolver();
            Long connectionAcquisitionTimeThresholdMillis = this.propertyLoader.getConnectionAcquisitionTimeThresholdMillis();
            Long connectionLeaseTimeThresholdMillis = this.propertyLoader.getConnectionLeaseTimeThresholdMillis();
            if (poolAdapterFactory == null) {
                poolAdapterFactory = DataSourcePoolAdapter.FACTORY;
            }
            FlexyPoolConfiguration.Builder<D> configurationBuilder = new FlexyPoolConfiguration.Builder<D>(uniqueName, dataSource, poolAdapterFactory);
            if (metricsFactory != null) {
                configurationBuilder.setMetricsFactory(metricsFactory);
            }
            if (connectionProxyFactory != null) {
                configurationBuilder.setConnectionProxyFactory(connectionProxyFactory);
            }
            if (metricLogReporterMillis != null) {
                configurationBuilder.setMetricLogReporterMillis(metricLogReporterMillis.intValue());
            }
            if (jmxEnabled != null) {
                configurationBuilder.setJmxEnabled(jmxEnabled);
            }
            if (jmxAutoStart != null) {
                configurationBuilder.setJmxAutoStart(jmxAutoStart);
            }
            if (eventListenerResolver != null) {
                configurationBuilder.setEventListenerResolver(eventListenerResolver);
            }
            if (connectionAcquisitionTimeThresholdMillis != null) {
                configurationBuilder.setConnectionAcquisitionTimeThresholdMillis(connectionAcquisitionTimeThresholdMillis);
            }
            if (connectionLeaseTimeThresholdMillis != null) {
                configurationBuilder.setConnectionLeaseTimeThresholdMillis(connectionLeaseTimeThresholdMillis);
            }
            return configurationBuilder.build();
        }

        private List<ConnectionAcquisitionStrategyFactory<? extends ConnectionAcquisitionStrategy, D>> connectionAcquiringStrategyFactories() {
            return this.propertyLoader.getConnectionAcquiringStrategyFactories();
        }

        public FlexyPoolDataSourceConfiguration<D> getFlexyPoolDataSourceConfiguration() {
            return this.flexyPoolDataSourceConfiguration;
        }
    }

    private static class FlexyPoolDataSourceConfiguration<D extends DataSource> {
        private final FlexyPoolConfiguration<D> configuration;
        private final List<ConnectionAcquisitionStrategyFactory<? extends ConnectionAcquisitionStrategy, D>> connectionAcquiringStrategyFactories;

        public FlexyPoolDataSourceConfiguration(FlexyPoolConfiguration<D> configuration, List<ConnectionAcquisitionStrategyFactory<? extends ConnectionAcquisitionStrategy, D>> connectionAcquiringStrategyFactories) {
            this.configuration = configuration;
            this.connectionAcquiringStrategyFactories = connectionAcquiringStrategyFactories;
        }

        public FlexyPoolConfiguration<D> getConfiguration() {
            return this.configuration;
        }

        public List<ConnectionAcquisitionStrategyFactory<? extends ConnectionAcquisitionStrategy, D>> getConnectionAcquiringStrategyFactories() {
            return this.connectionAcquiringStrategyFactories;
        }
    }
}

