/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.callback;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.vk.api.sdk.callback.objects.board.CallbackBoardPostDelete;
import com.vk.api.sdk.callback.objects.group.CallbackGroupChangePhoto;
import com.vk.api.sdk.callback.objects.group.CallbackGroupChangeSettings;
import com.vk.api.sdk.callback.objects.group.CallbackGroupJoin;
import com.vk.api.sdk.callback.objects.group.CallbackGroupLeave;
import com.vk.api.sdk.callback.objects.group.CallbackGroupOfficersEdit;
import com.vk.api.sdk.callback.objects.market.CallbackMarketComment;
import com.vk.api.sdk.callback.objects.market.CallbackMarketCommentDelete;
import com.vk.api.sdk.callback.objects.messages.CallbackConfirmationMessage;
import com.vk.api.sdk.callback.objects.messages.CallbackMessage;
import com.vk.api.sdk.callback.objects.messages.CallbackMessageAllow;
import com.vk.api.sdk.callback.objects.messages.CallbackMessageDeny;
import com.vk.api.sdk.callback.objects.photo.CallbackPhotoComment;
import com.vk.api.sdk.callback.objects.photo.CallbackPhotoCommentDelete;
import com.vk.api.sdk.callback.objects.poll.CallbackPollVoteNew;
import com.vk.api.sdk.callback.objects.user.CallbackUserBlock;
import com.vk.api.sdk.callback.objects.user.CallbackUserUnblock;
import com.vk.api.sdk.callback.objects.video.CallbackVideoComment;
import com.vk.api.sdk.callback.objects.video.CallbackVideoCommentDelete;
import com.vk.api.sdk.callback.objects.wall.CallbackWallComment;
import com.vk.api.sdk.callback.objects.wall.CallbackWallCommentDelete;
import com.vk.api.sdk.objects.audio.Audio;
import com.vk.api.sdk.objects.board.TopicComment;
import com.vk.api.sdk.objects.messages.Message;
import com.vk.api.sdk.objects.photos.Photo;
import com.vk.api.sdk.objects.video.Video;
import com.vk.api.sdk.objects.wall.WallPost;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackApi {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackApi.class);
    private static final String CALLBACK_EVENT_MESSAGE_NEW = "message_new";
    private static final String CALLBACK_EVENT_MESSAGE_REPLY = "message_reply";
    private static final String CALLBACK_EVENT_MESSAGE_ALLOW = "message_allow";
    private static final String CALLBACK_EVENT_MESSAGE_DENY = "message_deny";
    private static final String CALLBACK_EVENT_MESSAGE_EDIT = "message_edit";
    private static final String CALLBACK_EVENT_PHOTO_NEW = "photo_new";
    private static final String CALLBACK_EVENT_PHOTO_COMMENT_NEW = "photo_comment_new";
    private static final String CALLBACK_EVENT_PHOTO_COMMENT_EDIT = "photo_comment_edit";
    private static final String CALLBACK_EVENT_PHOTO_COMMENT_RESTORE = "photo_comment_restore";
    private static final String CALLBACK_EVENT_PHOTO_COMMENT_DELETE = "photo_comment_delete";
    private static final String CALLBACK_EVENT_AUDIO_NEW = "audio_new";
    private static final String CALLBACK_EVENT_VIDEO_NEW = "video_new";
    private static final String CALLBACK_EVENT_VIDEO_COMMENT_NEW = "video_comment_new";
    private static final String CALLBACK_EVENT_VIDEO_COMMENT_EDIT = "video_comment_edit";
    private static final String CALLBACK_EVENT_VIDEO_COMMENT_RESTORE = "video_comment_restore";
    private static final String CALLBACK_EVENT_VIDEO_COMMENT_DELETE = "video_comment_delete";
    private static final String CALLBACK_EVENT_WALL_POST_NEW = "wall_post_new";
    private static final String CALLBACK_EVENT_WALL_REPOST = "wall_repost";
    private static final String CALLBACK_EVENT_WALL_REPLY_NEW = "wall_reply_new";
    private static final String CALLBACK_EVENT_WALL_REPLY_EDIT = "wall_reply_edit";
    private static final String CALLBACK_EVENT_WALL_REPLY_RESTORE = "wall_reply_restore";
    private static final String CALLBACK_EVENT_WALL_REPLY_DELETE = "wall_reply_delete";
    private static final String CALLBACK_EVENT_BOARD_POST_NEW = "board_post_new";
    private static final String CALLBACK_EVENT_BOARD_POST_EDIT = "board_post_edit";
    private static final String CALLBACK_EVENT_BOARD_POST_RESTORE = "board_post_restore";
    private static final String CALLBACK_EVENT_BOARD_POST_DELETE = "board_post_delete";
    private static final String CALLBACK_EVENT_MARKET_COMMENT_NEW = "market_comment_new";
    private static final String CALLBACK_EVENT_MARKET_COMMENT_EDIT = "market_comment_edit";
    private static final String CALLBACK_EVENT_MARKET_COMMENT_RESTORE = "market_comment_restore";
    private static final String CALLBACK_EVENT_MARKET_COMMENT_DELETE = "market_comment_delete";
    private static final String CALLBACK_EVENT_GROUP_LEAVE = "group_leave";
    private static final String CALLBACK_EVENT_GROUP_JOIN = "group_join";
    private static final String CALLBACK_EVENT_GROUP_CHANGE_SETTINGS = "group_change_settings";
    private static final String CALLBACK_EVENT_GROUP_CHANGE_PHOTO = "group_change_photo";
    private static final String CALLBACK_EVENT_GROUP_OFFICERS_EDIT = "group_officers_edit";
    private static final String CALLBACK_EVENT_POLL_VOTE_NEW = "poll_vote_new";
    private static final String CALLBACK_EVENT_USER_BLOCK = "user_block";
    private static final String CALLBACK_EVENT_USER_UNBLOCK = "user_unblock";
    private static final String CALLBACK_EVENT_CONFIRMATION = "confirmation";
    private static final Map<String, Type> CALLBACK_TYPES;
    private final Gson gson = new Gson();

    public void messageNew(Integer groupId, Message message) {
    }

    public void messageNew(Integer groupId, String secret, Message message) {
        this.messageNew(groupId, message);
    }

    public void messageReply(Integer groupId, Message message) {
    }

    public void messageReply(Integer groupId, String secret, Message message) {
        this.messageReply(groupId, message);
    }

    public void messageEdit(Integer groupId, Message message) {
    }

    public void messageEdit(Integer groupId, String secret, Message message) {
        this.messageEdit(groupId, message);
    }

    public void messageAllow(Integer groupId, CallbackMessageAllow message) {
    }

    public void messageAllow(Integer groupId, String secret, CallbackMessageAllow message) {
        this.messageAllow(groupId, message);
    }

    public void messageDeny(Integer groupId, CallbackMessageDeny message) {
    }

    public void messageDeny(Integer groupId, String secret, CallbackMessageDeny message) {
        this.messageDeny(groupId, message);
    }

    public void photoNew(Integer groupId, Photo message) {
    }

    public void photoNew(Integer groupId, String secret, Photo message) {
        this.photoNew(groupId, message);
    }

    public void photoCommentNew(Integer groupId, CallbackPhotoComment message) {
    }

    public void photoCommentNew(Integer groupId, String secret, CallbackPhotoComment message) {
        this.photoCommentNew(groupId, message);
    }

    public void photoCommentEdit(Integer groupId, CallbackPhotoComment message) {
    }

    public void photoCommentEdit(Integer groupId, String secret, CallbackPhotoComment message) {
        this.photoCommentEdit(groupId, message);
    }

    public void photoCommentRestore(Integer groupId, CallbackPhotoComment message) {
    }

    public void photoCommentRestore(Integer groupId, String secret, CallbackPhotoComment message) {
        this.photoCommentRestore(groupId, message);
    }

    public void photoCommentDelete(Integer groupId, CallbackPhotoCommentDelete message) {
    }

    public void photoCommentDelete(Integer groupId, String secret, CallbackPhotoCommentDelete message) {
        this.photoCommentDelete(groupId, message);
    }

    public void audioNew(Integer groupId, Audio message) {
    }

    public void audioNew(Integer groupId, String secret, Audio message) {
        this.audioNew(groupId, message);
    }

    public void videoNew(Integer groupId, Video message) {
    }

    public void videoNew(Integer groupId, String secret, Video message) {
        this.videoNew(groupId, message);
    }

    public void videoCommentNew(Integer groupId, CallbackVideoComment message) {
    }

    public void videoCommentNew(Integer groupId, String secret, CallbackVideoComment message) {
        this.videoCommentNew(groupId, message);
    }

    public void videoCommentEdit(Integer groupId, CallbackVideoComment message) {
    }

    public void videoCommentEdit(Integer groupId, String secret, CallbackVideoComment message) {
        this.videoCommentEdit(groupId, message);
    }

    public void videoCommentRestore(Integer groupId, CallbackVideoComment message) {
    }

    public void videoCommentRestore(Integer groupId, String secret, CallbackVideoComment message) {
        this.videoCommentRestore(groupId, message);
    }

    public void videoCommentDelete(Integer groupId, CallbackVideoCommentDelete message) {
    }

    public void videoCommentDelete(Integer groupId, String secret, CallbackVideoCommentDelete message) {
        this.videoCommentDelete(groupId, message);
    }

    public void wallPostNew(Integer groupId, WallPost message) {
    }

    public void wallPostNew(Integer groupId, String secret, WallPost message) {
        this.wallPostNew(groupId, message);
    }

    public void wallRepost(Integer groupId, WallPost message) {
    }

    public void wallRepost(Integer groupId, String secret, WallPost message) {
        this.wallRepost(groupId, message);
    }

    public void wallReplyNew(Integer groupId, CallbackWallComment object) {
    }

    public void wallReplyNew(Integer groupId, String secret, CallbackWallComment object) {
        this.wallReplyNew(groupId, object);
    }

    public void wallReplyEdit(Integer groupId, CallbackWallComment message) {
    }

    public void wallReplyEdit(Integer groupId, String secret, CallbackWallComment message) {
        this.wallReplyEdit(groupId, message);
    }

    public void wallReplyRestore(Integer groupId, CallbackWallComment message) {
    }

    public void wallReplyRestore(Integer groupId, String secret, CallbackWallComment message) {
        this.wallReplyRestore(groupId, message);
    }

    public void wallReplyDelete(Integer groupId, CallbackWallCommentDelete message) {
    }

    public void wallReplyDelete(Integer groupId, String secret, CallbackWallCommentDelete message) {
        this.wallReplyDelete(groupId, message);
    }

    public void boardPostNew(Integer groupId, TopicComment message) {
    }

    public void boardPostNew(Integer groupId, String secret, TopicComment message) {
        this.boardPostNew(groupId, message);
    }

    public void boardPostEdit(Integer groupId, TopicComment message) {
    }

    public void boardPostEdit(Integer groupId, String secret, TopicComment message) {
        this.boardPostEdit(groupId, message);
    }

    public void boardPostRestore(Integer groupId, TopicComment message) {
    }

    public void boardPostRestore(Integer groupId, String secret, TopicComment message) {
        this.boardPostRestore(groupId, message);
    }

    public void boardPostDelete(Integer groupId, CallbackBoardPostDelete message) {
    }

    public void boardPostDelete(Integer groupId, String secret, CallbackBoardPostDelete message) {
        this.boardPostDelete(groupId, message);
    }

    public void marketCommentNew(Integer groupId, CallbackMarketComment message) {
    }

    public void marketCommentNew(Integer groupId, String secret, CallbackMarketComment message) {
        this.marketCommentNew(groupId, message);
    }

    public void marketCommentEdit(Integer groupId, CallbackMarketComment message) {
    }

    public void marketCommentEdit(Integer groupId, String secret, CallbackMarketComment message) {
        this.marketCommentEdit(groupId, message);
    }

    public void marketCommentRestore(Integer groupId, CallbackMarketComment message) {
    }

    public void marketCommentRestore(Integer groupId, String secret, CallbackMarketComment message) {
        this.marketCommentRestore(groupId, message);
    }

    public void marketCommentDelete(Integer groupId, CallbackMarketCommentDelete message) {
    }

    public void marketCommentDelete(Integer groupId, String secret, CallbackMarketCommentDelete message) {
        this.marketCommentDelete(groupId, message);
    }

    public void groupLeave(Integer groupId, CallbackGroupLeave message) {
    }

    public void groupLeave(Integer groupId, String secret, CallbackGroupLeave message) {
        this.groupLeave(groupId, message);
    }

    public void groupJoin(Integer groupId, CallbackGroupJoin message) {
    }

    public void groupJoin(Integer groupId, String secret, CallbackGroupJoin message) {
        this.groupJoin(groupId, message);
    }

    public void groupChangeSettings(Integer groupId, CallbackGroupChangeSettings message) {
    }

    public void groupChangeSettings(Integer groupId, String secret, CallbackGroupChangeSettings message) {
        this.groupChangeSettings(groupId, message);
    }

    public void groupChangePhoto(Integer groupId, CallbackGroupChangePhoto message) {
    }

    public void groupChangePhoto(Integer groupId, String secret, CallbackGroupChangePhoto message) {
        this.groupChangePhoto(groupId, message);
    }

    public void groupOfficersEdit(Integer groupId, CallbackGroupOfficersEdit message) {
    }

    public void groupOfficersEdit(Integer groupId, String secret, CallbackGroupOfficersEdit message) {
        this.groupOfficersEdit(groupId, message);
    }

    public void pollVoteNew(Integer groupId, CallbackPollVoteNew message) {
    }

    public void pollVoteNew(Integer groupId, String secret, CallbackPollVoteNew message) {
        this.pollVoteNew(groupId, message);
    }

    public void userBlock(Integer groupId, CallbackUserBlock message) {
    }

    public void userBlock(Integer groupId, String secret, CallbackUserBlock message) {
        this.userBlock(groupId, message);
    }

    public void userUnblock(Integer groupId, CallbackUserUnblock message) {
    }

    public void userUnblock(Integer groupId, String secret, CallbackUserUnblock message) {
        this.userUnblock(groupId, message);
    }

    public void confirmation(Integer groupId) {
    }

    public void confirmation(Integer groupId, String secret) {
        this.confirmation(groupId);
    }

    public boolean parse(String json) {
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(json, JsonObject.class);
        return this.parse(jsonObject);
    }

    public boolean parse(JsonObject json) {
        String type = json.get("type").getAsString();
        if (type.equalsIgnoreCase(CALLBACK_EVENT_CONFIRMATION)) {
            CallbackConfirmationMessage message = (CallbackConfirmationMessage)this.gson.fromJson((JsonElement)json, CallbackConfirmationMessage.class);
            this.confirmation(message.getGroupId(), message.getSecret());
            return true;
        }
        Type typeOfClass = CALLBACK_TYPES.get(type);
        if (typeOfClass == null) {
            LOG.warn("Unsupported callback event", (Object)type);
            return false;
        }
        CallbackMessage message = (CallbackMessage)this.gson.fromJson((JsonElement)json, typeOfClass);
        switch (type) {
            case "message_new": {
                this.messageNew(message.getGroupId(), message.getSecret(), (Message)message.getObject());
                break;
            }
            case "message_reply": {
                this.messageReply(message.getGroupId(), message.getSecret(), (Message)message.getObject());
                break;
            }
            case "message_edit": {
                this.messageEdit(message.getGroupId(), message.getSecret(), (Message)message.getObject());
                break;
            }
            case "message_allow": {
                this.messageAllow(message.getGroupId(), message.getSecret(), (CallbackMessageAllow)message.getObject());
                break;
            }
            case "message_deny": {
                this.messageDeny(message.getGroupId(), message.getSecret(), (CallbackMessageDeny)message.getObject());
                break;
            }
            case "photo_new": {
                this.photoNew(message.getGroupId(), message.getSecret(), (Photo)message.getObject());
                break;
            }
            case "photo_comment_new": {
                this.photoCommentNew(message.getGroupId(), message.getSecret(), (CallbackPhotoComment)message.getObject());
                break;
            }
            case "photo_comment_edit": {
                this.photoCommentEdit(message.getGroupId(), message.getSecret(), (CallbackPhotoComment)message.getObject());
                break;
            }
            case "photo_comment_restore": {
                this.photoCommentRestore(message.getGroupId(), message.getSecret(), (CallbackPhotoComment)message.getObject());
                break;
            }
            case "photo_comment_delete": {
                this.photoCommentDelete(message.getGroupId(), message.getSecret(), (CallbackPhotoCommentDelete)message.getObject());
                break;
            }
            case "audio_new": {
                this.audioNew(message.getGroupId(), message.getSecret(), (Audio)message.getObject());
                break;
            }
            case "video_new": {
                this.videoNew(message.getGroupId(), message.getSecret(), (Video)message.getObject());
                break;
            }
            case "video_comment_new": {
                this.videoCommentNew(message.getGroupId(), message.getSecret(), (CallbackVideoComment)message.getObject());
                break;
            }
            case "video_comment_edit": {
                this.videoCommentEdit(message.getGroupId(), message.getSecret(), (CallbackVideoComment)message.getObject());
                break;
            }
            case "video_comment_restore": {
                this.videoCommentRestore(message.getGroupId(), message.getSecret(), (CallbackVideoComment)message.getObject());
                break;
            }
            case "video_comment_delete": {
                this.videoCommentDelete(message.getGroupId(), message.getSecret(), (CallbackVideoCommentDelete)message.getObject());
                break;
            }
            case "wall_post_new": {
                this.wallPostNew(message.getGroupId(), message.getSecret(), (WallPost)message.getObject());
                break;
            }
            case "wall_repost": {
                this.wallRepost(message.getGroupId(), message.getSecret(), (WallPost)message.getObject());
                break;
            }
            case "wall_reply_new": {
                this.wallReplyNew(message.getGroupId(), message.getSecret(), (CallbackWallComment)message.getObject());
                break;
            }
            case "wall_reply_edit": {
                this.wallReplyEdit(message.getGroupId(), message.getSecret(), (CallbackWallComment)message.getObject());
                break;
            }
            case "wall_reply_restore": {
                this.wallReplyRestore(message.getGroupId(), message.getSecret(), (CallbackWallComment)message.getObject());
                break;
            }
            case "wall_reply_delete": {
                this.wallReplyDelete(message.getGroupId(), message.getSecret(), (CallbackWallCommentDelete)message.getObject());
                break;
            }
            case "board_post_new": {
                this.boardPostNew(message.getGroupId(), message.getSecret(), (TopicComment)message.getObject());
                break;
            }
            case "board_post_edit": {
                this.boardPostEdit(message.getGroupId(), message.getSecret(), (TopicComment)message.getObject());
                break;
            }
            case "board_post_restore": {
                this.boardPostRestore(message.getGroupId(), message.getSecret(), (TopicComment)message.getObject());
                break;
            }
            case "board_post_delete": {
                this.boardPostDelete(message.getGroupId(), message.getSecret(), (CallbackBoardPostDelete)message.getObject());
                break;
            }
            case "market_comment_new": {
                this.marketCommentNew(message.getGroupId(), message.getSecret(), (CallbackMarketComment)message.getObject());
                break;
            }
            case "market_comment_edit": {
                this.marketCommentEdit(message.getGroupId(), message.getSecret(), (CallbackMarketComment)message.getObject());
                break;
            }
            case "market_comment_restore": {
                this.marketCommentRestore(message.getGroupId(), message.getSecret(), (CallbackMarketComment)message.getObject());
                break;
            }
            case "market_comment_delete": {
                this.marketCommentDelete(message.getGroupId(), message.getSecret(), (CallbackMarketCommentDelete)message.getObject());
                break;
            }
            case "group_leave": {
                this.groupLeave(message.getGroupId(), message.getSecret(), (CallbackGroupLeave)message.getObject());
                break;
            }
            case "group_join": {
                this.groupJoin(message.getGroupId(), message.getSecret(), (CallbackGroupJoin)message.getObject());
                break;
            }
            case "group_change_settings": {
                this.groupChangeSettings(message.getGroupId(), message.getSecret(), (CallbackGroupChangeSettings)message.getObject());
                break;
            }
            case "group_change_photo": {
                this.groupChangePhoto(message.getGroupId(), message.getSecret(), (CallbackGroupChangePhoto)message.getObject());
                break;
            }
            case "group_officers_edit": {
                this.groupOfficersEdit(message.getGroupId(), message.getSecret(), (CallbackGroupOfficersEdit)message.getObject());
                break;
            }
            case "user_block": {
                this.userBlock(message.getGroupId(), message.getSecret(), (CallbackUserBlock)message.getObject());
                break;
            }
            case "user_unblock": {
                this.userUnblock(message.getGroupId(), message.getSecret(), (CallbackUserUnblock)message.getObject());
                break;
            }
            case "poll_vote_new": {
                this.pollVoteNew(message.getGroupId(), message.getSecret(), (CallbackPollVoteNew)message.getObject());
                break;
            }
            default: {
                LOG.warn("Unsupported callback event", (Object)type);
                return false;
            }
        }
        return true;
    }

    static {
        HashMap<String, Type> types = new HashMap<String, Type>();
        types.put(CALLBACK_EVENT_MESSAGE_NEW, new TypeToken<CallbackMessage<Message>>(){}.getType());
        types.put(CALLBACK_EVENT_MESSAGE_REPLY, new TypeToken<CallbackMessage<Message>>(){}.getType());
        types.put(CALLBACK_EVENT_MESSAGE_EDIT, new TypeToken<CallbackMessage<Message>>(){}.getType());
        types.put(CALLBACK_EVENT_MESSAGE_ALLOW, new TypeToken<CallbackMessage<CallbackMessageAllow>>(){}.getType());
        types.put(CALLBACK_EVENT_MESSAGE_DENY, new TypeToken<CallbackMessage<CallbackMessageDeny>>(){}.getType());
        types.put(CALLBACK_EVENT_PHOTO_NEW, new TypeToken<CallbackMessage<Photo>>(){}.getType());
        types.put(CALLBACK_EVENT_PHOTO_COMMENT_NEW, new TypeToken<CallbackMessage<CallbackPhotoComment>>(){}.getType());
        types.put(CALLBACK_EVENT_PHOTO_COMMENT_EDIT, new TypeToken<CallbackMessage<CallbackPhotoComment>>(){}.getType());
        types.put(CALLBACK_EVENT_PHOTO_COMMENT_RESTORE, new TypeToken<CallbackMessage<CallbackPhotoComment>>(){}.getType());
        types.put(CALLBACK_EVENT_PHOTO_COMMENT_DELETE, new TypeToken<CallbackMessage<CallbackPhotoCommentDelete>>(){}.getType());
        types.put(CALLBACK_EVENT_AUDIO_NEW, new TypeToken<CallbackMessage<Audio>>(){}.getType());
        types.put(CALLBACK_EVENT_VIDEO_NEW, new TypeToken<CallbackMessage<Video>>(){}.getType());
        types.put(CALLBACK_EVENT_VIDEO_COMMENT_NEW, new TypeToken<CallbackMessage<CallbackVideoComment>>(){}.getType());
        types.put(CALLBACK_EVENT_VIDEO_COMMENT_EDIT, new TypeToken<CallbackMessage<CallbackVideoComment>>(){}.getType());
        types.put(CALLBACK_EVENT_VIDEO_COMMENT_RESTORE, new TypeToken<CallbackMessage<CallbackVideoComment>>(){}.getType());
        types.put(CALLBACK_EVENT_VIDEO_COMMENT_DELETE, new TypeToken<CallbackMessage<CallbackVideoCommentDelete>>(){}.getType());
        types.put(CALLBACK_EVENT_WALL_POST_NEW, new TypeToken<CallbackMessage<WallPost>>(){}.getType());
        types.put(CALLBACK_EVENT_WALL_REPOST, new TypeToken<CallbackMessage<WallPost>>(){}.getType());
        types.put(CALLBACK_EVENT_WALL_REPLY_NEW, new TypeToken<CallbackMessage<CallbackWallComment>>(){}.getType());
        types.put(CALLBACK_EVENT_WALL_REPLY_EDIT, new TypeToken<CallbackMessage<CallbackWallComment>>(){}.getType());
        types.put(CALLBACK_EVENT_WALL_REPLY_RESTORE, new TypeToken<CallbackMessage<CallbackWallComment>>(){}.getType());
        types.put(CALLBACK_EVENT_WALL_REPLY_DELETE, new TypeToken<CallbackMessage<CallbackWallCommentDelete>>(){}.getType());
        types.put(CALLBACK_EVENT_BOARD_POST_NEW, new TypeToken<CallbackMessage<TopicComment>>(){}.getType());
        types.put(CALLBACK_EVENT_BOARD_POST_EDIT, new TypeToken<CallbackMessage<TopicComment>>(){}.getType());
        types.put(CALLBACK_EVENT_BOARD_POST_RESTORE, new TypeToken<CallbackMessage<TopicComment>>(){}.getType());
        types.put(CALLBACK_EVENT_BOARD_POST_DELETE, new TypeToken<CallbackMessage<CallbackBoardPostDelete>>(){}.getType());
        types.put(CALLBACK_EVENT_MARKET_COMMENT_NEW, new TypeToken<CallbackMessage<CallbackMarketComment>>(){}.getType());
        types.put(CALLBACK_EVENT_MARKET_COMMENT_EDIT, new TypeToken<CallbackMessage<CallbackMarketComment>>(){}.getType());
        types.put(CALLBACK_EVENT_MARKET_COMMENT_RESTORE, new TypeToken<CallbackMessage<CallbackMarketComment>>(){}.getType());
        types.put(CALLBACK_EVENT_MARKET_COMMENT_DELETE, new TypeToken<CallbackMessage<CallbackMarketCommentDelete>>(){}.getType());
        types.put(CALLBACK_EVENT_GROUP_LEAVE, new TypeToken<CallbackMessage<CallbackGroupLeave>>(){}.getType());
        types.put(CALLBACK_EVENT_GROUP_JOIN, new TypeToken<CallbackMessage<CallbackGroupJoin>>(){}.getType());
        types.put(CALLBACK_EVENT_GROUP_CHANGE_SETTINGS, new TypeToken<CallbackMessage<CallbackGroupChangeSettings>>(){}.getType());
        types.put(CALLBACK_EVENT_GROUP_CHANGE_PHOTO, new TypeToken<CallbackMessage<CallbackGroupChangePhoto>>(){}.getType());
        types.put(CALLBACK_EVENT_GROUP_OFFICERS_EDIT, new TypeToken<CallbackMessage<CallbackGroupOfficersEdit>>(){}.getType());
        types.put(CALLBACK_EVENT_USER_BLOCK, new TypeToken<CallbackMessage<CallbackUserBlock>>(){}.getType());
        types.put(CALLBACK_EVENT_USER_UNBLOCK, new TypeToken<CallbackMessage<CallbackUserUnblock>>(){}.getType());
        types.put(CALLBACK_EVENT_POLL_VOTE_NEW, new TypeToken<CallbackMessage<CallbackPollVoteNew>>(){}.getType());
        CALLBACK_TYPES = Collections.unmodifiableMap(types);
    }
}

