package com.vk.api.sdk.queries.wall;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.wall.responses.PostResponse;

import java.util.Arrays;
import java.util.List;

/**
 * Query for Wall.post method
 */
public class WallPostQuery extends AbstractQueryBuilder<WallPostQuery, PostResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build api request with various parameters
     *
     * @param client VK API client
     * @param actor  actor with access token
     */
    public WallPostQuery(VkApiClient client, UserActor actor) {
        super(client, "wall.post", PostResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * User ID or community ID. Use a negative value to designate a community ID.
     *
     * @param value value of "owner id" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery ownerId(Integer value) {
        return unsafeParam("owner_id", value);
    }

    /**
     * Post will be available to friends only
     *
     * @param value value of "friends only" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery friendsOnly(Boolean value) {
        return unsafeParam("friends_only", value);
    }

    /**
     * Post will be published by the community
     *
     * @param value value of "from group" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery fromGroup(Boolean value) {
        return unsafeParam("from_group", value);
    }

    /**
     * (Required if "attachments" is not set.) Text of the post.
     *
     * @param value value of "message" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery message(String value) {
        return unsafeParam("message", value);
    }

    /**
     * (Required if "message" is not set.) List of objects attached to the post, in the following format:
     * "type""owner_id"_"media_id"
     * ""type"" - Type of media attachment:
     * "photo" - photo
     * "video" - video
     * "audio" - audio
     * "doc" - document
     * "page" - wiki-page
     * "note" - note
     * "poll" - poll
     * "album" - photo album
     * ""owner_id"" - ID of the media application owner.
     * ""media_id"" - Media application ID.

     * Example:
     * photo100172_166443618,photo66748_265827614
     *
     * May contain a link to an external page to include in the post. Example:
     * <pre>photo66748_265827614,http://habrahabr.ru</pre>
     * NOTE: If more than one link is being attached, an error will be thrown.
     *
     * @param value value of "attachments" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery attachments(String... value) {
        return unsafeParam("attachments", value);
    }

    /**
     * (Required if "message" is not set.) List of objects attached to the post, in the following format:
     * "type""owner_id"_"media_id"
     * ""type"" - Type of media attachment:
     * "photo" - photo
     * "video" - video
     * "audio" - audio
     * "doc" - document
     * "page" - wiki-page
     * "note" - note
     * "poll" - poll
     * "album" - photo album
     * ""owner_id"" - ID of the media application owner.
     * ""media_id"" - Media application ID.

     * Example:
     * photo100172_166443618,photo66748_265827614
     *
     * May contain a link to an external page to include in the post. Example:
     * <pre>photo66748_265827614,http://habrahabr.ru</pre>
     * NOTE: If more than one link is being attached, an error will be thrown.
     *
     * @param value value of "attachments" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery attachments(List<String> value) {
        return unsafeParam("attachments", value);
    }

    /**
     * List of services or websites the update will be exported to, if the user has so requested. Sample values: "twitter", "facebook".
     *
     * @param value value of "services" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery services(String value) {
        return unsafeParam("services", value);
    }

    /**
     * Post will be signed with the name of the posting user
     * Only for posts in communities with "from_group"
     *
     * @param value value of "signed" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery signed(Boolean value) {
        return unsafeParam("signed", value);
    }

    /**
     * Publication date (in Unix time). If used, posting will be delayed until the set time.
     *
     * @param value value of "publish date" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery publishDate(Integer value) {
        return unsafeParam("publish_date", value);
    }

    /**
     * Geographical latitude of a check-in, in degrees (from -90 to 90).
     *
     * @param value value of "lat" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery lat(Float value) {
        return unsafeParam("lat", value);
    }

    /**
     * Geographical longitude of a check-in, in degrees (from -180 to 180).
     *
     * @param value value of "long" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery lng(Float value) {
        return unsafeParam("long", value);
    }

    /**
     * ID of the location where the user was tagged.
     *
     * @param value value of "place id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery placeId(Integer value) {
        return unsafeParam("place_id", value);
    }

    /**
     * Post ID. Used for publishing of scheduled and suggested posts.
     *
     * @param value value of "post id" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery postId(Integer value) {
        return unsafeParam("post_id", value);
    }

    /**
     * Set guid
     *
     * @param value value of "guid" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery guid(String value) {
        return unsafeParam("guid", value);
    }

    /**
     * Set mark as ads
     *
     * @param value value of "mark as ads" parameter. By default 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public WallPostQuery markAsAds(Boolean value) {
        return unsafeParam("mark_as_ads", value);
    }

    @Override
    protected WallPostQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
