package com.vk.api.sdk.queries.newsfeed;

import com.vk.api.sdk.client.AbstractQueryBuilder;
import com.vk.api.sdk.client.VkApiClient;
import com.vk.api.sdk.client.actors.UserActor;
import com.vk.api.sdk.objects.newsfeed.responses.GetCommentsResponse;
import com.vk.api.sdk.queries.EnumParam;

import java.util.Arrays;
import java.util.List;

/**
 * Query for Newsfeed.getComments method
 */
public class NewsfeedGetCommentsQuery extends AbstractQueryBuilder<NewsfeedGetCommentsQuery, GetCommentsResponse> {
    /**
     * Creates a AbstractQueryBuilder instance that can be used to build api request with various parameters
     *
     * @param client VK API client
     * @param actor  actor with access token
     */
    public NewsfeedGetCommentsQuery(VkApiClient client, UserActor actor) {
        super(client, "newsfeed.getComments", GetCommentsResponse.class);
        accessToken(actor.getAccessToken());
    }

    /**
     * Number of comments to return. For auto feed, you can use the "new_offset" parameter returned by this method.
     *
     * @param value value of "count" parameter. Maximum is 100. Minimum is 0. By default 30.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery count(Integer value) {
        return unsafeParam("count", value);
    }

    /**
     * Filters to apply
     *
     * @param value value of "filters" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery filters(NewsfeedGetCommentsFilter... value) {
        return unsafeParam("filters", value);
    }

    /**
     * Filters to apply
     *
     * @param value value of "filters" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery filters(List<NewsfeedGetCommentsFilter> value) {
        return unsafeParam("filters", value);
    }

    /**
     * Object ID, comments on repost of which shall be returned, e.g. "wall1_45486".
     * If the parameter is set, the "filters" parameter is optional.
     *
     * @param value value of "reposts" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery reposts(String value) {
        return unsafeParam("reposts", value);
    }

    /**
     * Earliest timestamp (in Unix time) of a comment to return. By default, 24 hours ago.
     *
     * @param value value of "start time" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery startTime(Integer value) {
        return unsafeParam("start_time", value);
    }

    /**
     * Latest timestamp (in Unix time) of a comment to return. By default, the current time.
     *
     * @param value value of "end time" parameter. Minimum is 0.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery endTime(Integer value) {
        return unsafeParam("end_time", value);
    }

    /**
     * Identificator needed to return the next oage with results. Value for this parameter returns in "next_from" field.
     *
     * @param value value of "start from" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery startFrom(String value) {
        return unsafeParam("start_from", value);
    }

    /**
     * Set fields
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery fields(EnumParam... value) {
        return unsafeParam("fields", value);
    }

    /**
     * Set fields
     *
     * @param value value of "fields" parameter.
     * @return a reference to this {@code AbstractQueryBuilder} object to fulfill the "Builder" pattern.
     */
    public NewsfeedGetCommentsQuery fields(List<EnumParam> value) {
        return unsafeParam("fields", value);
    }

    @Override
    protected NewsfeedGetCommentsQuery getThis() {
        return this;
    }

    @Override
    protected List<String> essentialKeys() {
        return Arrays.asList("access_token");
    }
}
