/*
 * Decompiled with CFR 0.152.
 */
package com.vistrav.ask;

import android.app.Activity;
import android.app.Fragment;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.vistrav.ask.AskActivity;
import com.vistrav.ask.annotations.AskDenied;
import com.vistrav.ask.annotations.AskGranted;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Ask {
    private Context context;
    private String[] permissions;
    private String[] rationalMessages;
    private Map<String, Boolean> permissionGrantResults = new HashMap<String, Boolean>();
    private static final String TAG = Ask.class.getSimpleName();
    private static Permission permissionObj;
    private static Fragment fragment;
    private static Activity activity;
    private static int id;
    private static Map<String, Method> permissionMethodMap;
    private static boolean warn;

    private Ask(Context context) {
        this.context = context;
        permissionMethodMap = new HashMap<String, Method>();
    }

    public static Ask on(Activity lActivity) {
        activity = lActivity;
        return new Ask((Context)lActivity);
    }

    public static Ask on(Fragment lFragment) {
        fragment = lFragment;
        return new Ask((Context)lFragment.getActivity());
    }

    public Ask forPermissions(String ... permissions) {
        if (permissions.length == 0) {
            throw new IllegalArgumentException("The permissions to request are missing");
        }
        this.permissions = permissions;
        return this;
    }

    public Ask withRationales(String ... rationalMessages) {
        this.rationalMessages = rationalMessages;
        return this;
    }

    public Ask warn(boolean lWarn) {
        warn = lWarn;
        return this;
    }

    public Ask id(int lId) {
        id = lId;
        return this;
    }

    public void go() {
        this.getAnnotatedMethod();
        if (Build.VERSION.SDK_INT < 23) {
            if (permissionObj != null) {
                permissionObj.granted(Arrays.asList(this.permissions));
                permissionObj.denied(new ArrayList<String>());
            }
            for (String permission : this.permissions) {
                Ask.invokeMethod(permission, true);
            }
        } else {
            Intent intent = new Intent(this.context, AskActivity.class);
            intent.putExtra("__permissions__", this.permissions);
            intent.putExtra("__rational_messages__", this.rationalMessages);
            this.context.startActivity(intent);
        }
    }

    public Ask when(@Nullable Permission permission) {
        permissionObj = permission;
        return this;
    }

    private void getAnnotatedMethod() {
        Method[] methods;
        permissionMethodMap.clear();
        for (Method method : methods = fragment != null ? fragment.getClass().getMethods() : activity.getClass().getMethods()) {
            AskDenied askDenied = method.getAnnotation(AskDenied.class);
            AskGranted askGranted = method.getAnnotation(AskGranted.class);
            if (askDenied != null) {
                permissionMethodMap.put("false_" + askDenied.value() + "_" + askDenied.id(), method);
            }
            if (askGranted == null) continue;
            permissionMethodMap.put("true_" + askGranted.value() + "_" + askGranted.id(), method);
        }
    }

    private static void invokeMethod(String permission, boolean isGranted) {
        block5: {
            String key = isGranted + "_" + permission + "_" + id;
            String val = isGranted ? "Granted" : "Denied";
            try {
                if (permissionMethodMap.containsKey(key)) {
                    permissionMethodMap.get(key).invoke(fragment != null ? fragment : activity, new Object[0]);
                } else if (warn) {
                    Log.w((String)TAG, (String)("No method found to handle the " + permission + " " + val + " case. Please check for the detail here https://github.com/00ec454/Ask"));
                }
            }
            catch (Exception e) {
                if (!warn) break block5;
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        id = 987655678;
        warn = true;
    }

    public static class Receiver
    extends BroadcastReceiver {
        public void onReceive(Context lContext, Intent intent) {
            String[] permissions = intent.getStringArrayExtra("__permissions__");
            int[] grantResults = intent.getIntArrayExtra("__grant_results__");
            HashMap permissionGrantResults = new HashMap();
            ArrayList<String> grantedPermissions = new ArrayList<String>();
            ArrayList<String> deniedPermissions = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                boolean isGranted = grantResults[i] == 0;
                Ask.invokeMethod(permissions[i], isGranted);
                if (isGranted) {
                    grantedPermissions.add(permissions[i]);
                    continue;
                }
                deniedPermissions.add(permissions[i]);
            }
            if (permissionObj != null) {
                permissionObj.denied(deniedPermissions);
                permissionObj.granted(grantedPermissions);
            }
        }
    }

    public static interface Permission {
        public void granted(List<String> var1);

        public void denied(List<String> var1);
    }
}

