/*
 * Decompiled with CFR 0.152.
 */
package com.vistrav.ask;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.vistrav.ask.AskActivity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Ask {
    private Context context;
    private String[] permissions;
    private String[] rationalMessages;
    private Map<String, Boolean> permissionGrantResults = new HashMap<String, Boolean>();
    private static final String TAG = Ask.class.getSimpleName();
    private static Permission permissionObj;

    private Ask(Context context) {
        this.context = context;
    }

    public static Ask on(Context context) {
        return new Ask(context);
    }

    public Ask forPermissions(String ... permissions) {
        if (permissions.length == 0) {
            throw new IllegalArgumentException("The permissions missing");
        }
        this.permissions = permissions;
        return this;
    }

    public Ask withRationales(String ... rationalMessages) {
        this.rationalMessages = rationalMessages;
        return this;
    }

    public void go() {
        Intent intent = new Intent(this.context, AskActivity.class);
        intent.putExtra("__permissions__", this.permissions);
        intent.putExtra("__rational_messages__", this.rationalMessages);
        this.context.startActivity(intent);
    }

    public Ask when(@NonNull Permission permission) {
        permissionObj = permission;
        return this;
    }

    public static class Receiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            String[] permissions = intent.getStringArrayExtra("__permissions__");
            int[] grantResults = intent.getIntArrayExtra("__grant_results__");
            HashMap permissionGrantResults = new HashMap();
            ArrayList<String> grantedPermissions = new ArrayList<String>();
            ArrayList<String> deniedPermissions = new ArrayList<String>();
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    grantedPermissions.add(permissions[i]);
                    continue;
                }
                deniedPermissions.add(permissions[i]);
            }
            permissionObj.denied(deniedPermissions);
            permissionObj.granted(grantedPermissions);
        }
    }

    public static interface Permission {
        public void granted(List<String> var1);

        public void denied(List<String> var1);
    }
}

