/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.highlevel;

import com.virgilsecurity.sdk.client.CardValidator;
import com.virgilsecurity.sdk.client.RequestSigner;
import com.virgilsecurity.sdk.client.VirgilClient;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.client.utils.VirgilCardValidator;
import com.virgilsecurity.sdk.crypto.Crypto;
import com.virgilsecurity.sdk.crypto.KeyStorage;
import com.virgilsecurity.sdk.crypto.VirgilCrypto;
import com.virgilsecurity.sdk.highlevel.ServiceContainer;
import com.virgilsecurity.sdk.keystorage.VirgilKeyStorage;
import java.lang.reflect.Type;

public class VirgilConfig {
    private static ServiceContainer serviceContainer = new ServiceContainer();

    private static void init() {
        serviceContainer.registerSingleton(Crypto.class, VirgilCrypto.class);
        serviceContainer.registerSingleton(RequestSigner.class, RequestSigner.class);
        serviceContainer.registerSingleton(KeyStorage.class, VirgilKeyStorage.class);
    }

    public static void init(String accessToken) {
        if (StringUtils.isBlank(accessToken)) {
            throw new IllegalArgumentException();
        }
        Crypto crypto = serviceContainer.resolve(Crypto.class);
        VirgilClient client = new VirgilClient(accessToken);
        client.setCardValidator(new VirgilCardValidator(crypto));
        serviceContainer.registerInstance(VirgilClient.class, client);
    }

    public static void setCardValidator(CardValidator validator) {
        VirgilClient client = serviceContainer.resolve(VirgilClient.class);
        client.setCardValidator(validator);
    }

    public static void setKeyStorage(KeyStorage storage) {
        serviceContainer.remove((Type)((Object)KeyStorage.class));
        serviceContainer.registerInstance(KeyStorage.class, storage);
    }

    public static void reset() {
        serviceContainer.clear();
        VirgilConfig.init();
    }

    static <T> T getService(Class<T> type) {
        return serviceContainer.resolve(type);
    }

    static {
        VirgilConfig.init();
    }
}

