/*
 * Decompiled with CFR 0.152.
 */
package com.virgilsecurity.sdk.client.utils;

import com.virgilsecurity.sdk.client.CardValidator;
import com.virgilsecurity.sdk.client.model.Card;
import com.virgilsecurity.sdk.client.utils.ConvertionUtils;
import com.virgilsecurity.sdk.client.utils.StringUtils;
import com.virgilsecurity.sdk.crypto.Crypto;
import com.virgilsecurity.sdk.crypto.Fingerprint;
import com.virgilsecurity.sdk.crypto.PublicKey;
import com.virgilsecurity.sdk.crypto.exceptions.EmptyArgumentException;
import java.util.HashMap;
import java.util.Map;

public class VirgilCardValidator
implements CardValidator {
    private Crypto crypto;
    private Map<String, PublicKey> verifiers;
    private static final String SERVICE_CARD_ID = "3e29d43373348cfb373b7eae189214dc01d7237765e572db685839b64adca853";
    private static final String SERVICE_PUBLIC_KEY = "LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUNvd0JRWURLMlZ3QXlFQVlSNTAxa1YxdFVuZTJ1T2RrdzRrRXJSUmJKcmMyU3lhejVWMWZ1RytyVnM9Ci0tLS0tRU5EIFBVQkxJQyBLRVktLS0tLQo=";

    public VirgilCardValidator(Crypto crypto) {
        this.crypto = crypto;
        PublicKey servicePublicKey = crypto.importPublicKey(ConvertionUtils.base64ToBytes(SERVICE_PUBLIC_KEY));
        this.verifiers = new HashMap<String, PublicKey>();
        this.verifiers.put(SERVICE_CARD_ID, servicePublicKey);
    }

    public void addVerifier(String verifierId, byte[] verifierPublicKey) {
        if (StringUtils.isBlank(verifierId)) {
            throw new EmptyArgumentException("verifierId");
        }
        if (verifierPublicKey == null) {
            throw new EmptyArgumentException("verifierPublicKey");
        }
        PublicKey publicKey = this.crypto.importPublicKey(verifierPublicKey);
        this.verifiers.put(verifierId, publicKey);
    }

    @Override
    public boolean validate(Card card) {
        if ("3.0".equals(card.getVersion())) {
            return true;
        }
        Fingerprint fingerprint = this.crypto.calculateFingerprint(card.getSnapshot());
        for (Map.Entry<String, PublicKey> verifier : this.verifiers.entrySet()) {
            if (!card.getSignatures().containsKey(verifier.getKey())) {
                return false;
            }
            boolean isValid = this.crypto.verify(fingerprint.getValue(), card.getSignatures().get(verifier.getKey()), verifier.getValue());
            if (isValid) continue;
            return false;
        }
        return true;
    }
}

